/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;

public class DeletableFile {
    public static String CheckInstallDirectory(String strInstallDirectory, String strExcludedDirectory) throws IOException {
        String strDirectoryInUse = "";
        String fileName = strInstallDirectory;
        File file = new File(fileName);
        if (file.exists() && file.isDirectory()) {
            File[] fList;
            for (File f : fList = file.listFiles()) {
                if (!strExcludedDirectory.isEmpty() && f.getCanonicalPath().contains(strExcludedDirectory) || DeletableFile.canRename(f)) continue;
                strDirectoryInUse = strDirectoryInUse + f.getAbsolutePath() + System.lineSeparator();
            }
        }
        return strDirectoryInUse;
    }

    public static boolean canRename(String fileName) throws IOException {
        return DeletableFile.canRename(new File(fileName));
    }

    public static boolean canRename(File file) throws IOException {
        File newFile = DeletableFile.getNewFile(file);
        boolean canRename = file.renameTo(newFile);
        if (canRename) {
            newFile.renameTo(file);
        } else {
            System.out.println("-- " + file.getAbsolutePath() + " can NOT be reanmed/deleted!!!");
        }
        return canRename;
    }

    public static File getNewFile(File baseFile) throws IOException {
        String canonicalPath = baseFile.getCanonicalPath();
        return new File(canonicalPath + "__bak");
    }
}

