/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.SocketException;

public class FindAvailablePort
extends CustomCodeAction {
    private static int[] portRange = new int[]{9300, 9900};
    private static int[] httpsPortRange = new int[]{3888, 4800};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailable(int iNewPort) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(iNewPort);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(iNewPort);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (ss != null) {
                    ss.close();
                }
                if (ds != null) {
                    ds.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private static int findAvailablePort(int begin, int end) {
        int port = -1;
        for (int i = begin; i < end; i += 5) {
            if (!FindAvailablePort.isAvailable(i)) continue;
            port = i;
            break;
        }
        return port;
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void install(InstallerProxy ip) throws InstallException {
        int newPort = FindAvailablePort.findAvailablePort(portRange[0], portRange[1]);
        if (newPort < 0) {
            CustomError err = (CustomError)ip.getService(CustomError.class);
            err.appendError("Unable to find available port in range: " + portRange[0] + "-" + portRange[1], 97);
            err.setLogDescription("Unable to get a port ");
        }
        ip.setVariable("$AVAILABLE_PORT$", newPort);
        int newhttpsPort = FindAvailablePort.findAvailablePort(httpsPortRange[0], httpsPortRange[1]);
        if (newhttpsPort < 0) {
            CustomError err = (CustomError)ip.getService(CustomError.class);
            err.appendError("Unable to find available port in range: " + httpsPortRange[0] + "-" + httpsPortRange[1], 97);
            err.setLogDescription("Unable to get a https port ");
        }
        ip.setVariable("$AVAILABLE_HTTPSPORT$", newhttpsPort);
    }

    @Override
    public void uninstall(UninstallerProxy up) throws InstallException {
    }
}

