/*
 * Decompiled with CFR 0.152.
 */
import core.InstallerState;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;

public class InstallDirectoryValidator {
    private char BACKSLASH = (char)92;
    private char FORWARD_SLASH = (char)47;
    private final String IDS_INVALID_CHARACTERS_WIN = ".*[/?*\\<>|\"].*";
    private final String IDS_INVALID_CHARACTERS_UNIX = ".*[?*\\<>|\"].*";
    private String installDirectory = "";

    public InstallDirectoryValidator(String strInstallDirectory) {
        this.installDirectory = strInstallDirectory;
    }

    public installDirError Validate() {
        InstallerState.log.enter(this);
        installDirError errCode = installDirError.ERR_NONE;
        errCode = this.CheckInvalidCharacters(this.installDirectory);
        if (errCode != installDirError.ERR_NONE) {
            return errCode;
        }
        if (InstallerState.isWindows && (errCode = this.CheckForInvalidDrive(this.installDirectory)) != installDirError.ERR_NONE) {
            return errCode;
        }
        errCode = this.CheckForWriteAccess(this.installDirectory);
        if (errCode != installDirError.ERR_NONE) {
            return errCode;
        }
        InstallerState.log.exit(this);
        return installDirError.ERR_NONE;
    }

    public installDirError CheckInvalidCharacters(String strInstallDirectory) {
        Pattern pattern;
        Matcher matcher;
        InstallerState.log.enter(this);
        installDirError retCode = installDirError.ERR_NONE;
        boolean bInvalidCharFound = false;
        String strInvalidChars = ".*[/?*\\<>|\"].*";
        if (!InstallerState.isWindows) {
            strInvalidChars = ".*[?*\\<>|\"].*";
        }
        if (bInvalidCharFound = (matcher = (pattern = Pattern.compile(strInvalidChars)).matcher(strInstallDirectory)).find()) {
            retCode = installDirError.ERR_INVALID_CHARACTER;
        }
        InstallerState.log.exit(this);
        return retCode;
    }

    public installDirError CheckForInvalidDrive(String strInstallDirectory) {
        InstallerState.log.enter(this);
        installDirError retCode = installDirError.ERR_NONE;
        boolean bValidDrive = true;
        String strDrive = strInstallDirectory.substring(0, 3);
        if (strDrive.length() == 3 && strDrive.charAt(0) != this.FORWARD_SLASH && strDrive.charAt(0) != this.BACKSLASH) {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            bValidDrive = fsv.isDrive(new File(strDrive));
        }
        if (!bValidDrive) {
            retCode = installDirError.ERR_INVALID_DRIVE;
        }
        InstallerState.log.exit(this);
        return retCode;
    }

    public installDirError CheckForWriteAccess(String strInstallDirectory) {
        InstallerState.log.enter(this);
        installDirError retCode = installDirError.ERR_NONE;
        boolean bWriteable = false;
        Path newPath = Paths.get(this.getExistingPath(strInstallDirectory), new String[0]);
        if (Files.isWritable(newPath)) {
            bWriteable = true;
        }
        if (!bWriteable) {
            retCode = installDirError.ERR_NO_WRITE_ACCESS;
        }
        InstallerState.log.exit(this);
        return retCode;
    }

    private String getExistingPath(String strPath) {
        InstallerState.log.enter(this);
        boolean bExists = false;
        String strExistingPath = strPath;
        File fPath = new File(strExistingPath);
        if (!fPath.exists()) {
            while (!bExists) {
                strExistingPath = fPath.getParent();
                if (!(fPath = new File(strExistingPath)).exists()) continue;
                bExists = true;
            }
        }
        InstallerState.log.exit(this);
        return strExistingPath;
    }

    public void SetInstallDirectory(String strInstallDirectory) {
        this.installDirectory = strInstallDirectory;
    }

    public String GetInstallDirectory() {
        return this.installDirectory;
    }

    public static enum installDirError {
        ERR_NONE,
        ERR_INVALID_CHARACTER,
        ERR_INVALID_DRIVE,
        ERR_NO_WRITE_ACCESS;

    }
}

