/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import core.CustomCodeActionShim;
import core.InstallerState;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import manifest.InstallManifest;
import manifest.Installable;

public class InstallDiskSpace
extends CustomCodeActionShim {
    String m_strInstallDestination = "";
    CustomError m_InstallLog = null;
    CustomError m_UninstallLog = null;
    IAProxy m_installProxy = null;
    String m_strChosenFeature = "";
    String m_strInstallType = "Custom";
    float diskSpaceAvailableGB = 0.0f;
    float diskSpaceRequiredGB = 0.0f;

    @Override
    public void installImpl(IAProxy ip) throws InstallException {
        if (ip != null) {
            InstallManifest iManifest;
            this.m_installProxy = ip;
            this.m_InstallLog = (CustomError)ip.getService(CustomError.class);
            this.m_InstallLog.setLogDescription("Calculating Disk space: ");
            this.m_InstallLog.log();
            this.m_strChosenFeature = ip.substitute("$CHOSEN_FEATURE_LIST$");
            String strChosenInstallType = ip.substitute("$BISRVR_INSTALLTYPE_READY$");
            if (strChosenInstallType.equals("1")) {
                this.m_strInstallType = "Easy";
            }
            InstallerState.log.debug("InstallDiskspace imanifest null?", (iManifest = CARepositoryState.GetRepositoryState().GetInstallSelectedManifest()) == null ? "yep" : "nope");
            String strLog = "Manifest used for installation: " + CARepositoryState.GetRepositoryState().GetInstallSelectedManifestName();
            if (this.m_InstallLog != null) {
                this.m_InstallLog.appendMessage(strLog);
                this.m_InstallLog.log();
            }
            InstallerState.log.info("Install diskSpace", strLog);
            iManifest.ResetInstallableInstallSelectedStatus();
            for (Installable installItem : iManifest.getInstallables()) {
                if (installItem.isSelectedForInstallation() || !this.IsInstallableChosenForInstallation(installItem)) continue;
                installItem.setSelectedForInstallation(true);
                if (installItem.getinstallablesRef() == null) continue;
                for (String ref : installItem.getinstallablesRef()) {
                    iManifest.getInstallable(ref).setSelectedForInstallation(true);
                    Installable installSubItem = iManifest.getInstallable(ref);
                    if (installSubItem.getinstallablesRef() == null) continue;
                    for (String refSubItem : installSubItem.getinstallablesRef()) {
                        iManifest.getInstallable(refSubItem).setSelectedForInstallation(true);
                    }
                }
            }
            long totalInstallSizeCompressed = iManifest.getSelectedInstallablesSize();
            double totalInstallSize = totalInstallSizeCompressed * 2L;
            double totalInstallSizeroundoff = (double)Math.round(totalInstallSize * 100.0) / 100.0;
            double totalInstallSizeInMb = totalInstallSizeroundoff / 1048576.0;
            this.diskSpaceRequiredGB = (float)totalInstallSizeroundoff / 1.0737418E9f;
            DecimalFormat df = new DecimalFormat("#.##");
            df.setRoundingMode(RoundingMode.CEILING);
            ip.setVariable("$TOTAL_INSTALL_SIZE_BYTES$", df.format(totalInstallSizeroundoff));
            ip.setVariable("$TOTAL_INSTALL_SIZE_IN_GIGABYTES$", df.format(this.diskSpaceRequiredGB));
            ip.setVariable("$TOTAL_INSTALL_SIZE_IN_MEGABYTES$", df.format(totalInstallSizeInMb));
            String checkDir = ip.substitute("$USER_INSTALL_DIR$");
            File f = new File(ip.substitute(checkDir));
            boolean dirExists = f.exists();
            while (!dirExists) {
                checkDir = f.getParent();
                f = new File(checkDir);
                dirExists = f.exists();
            }
            this.diskSpaceAvailableGB = f.getUsableSpace() / 0x40000000L;
            ip.setVariable("$AVAILABLE_SPACE_IN_GIGABYTES$", Float.valueOf(this.diskSpaceAvailableGB));
            ip.setVariable("$INSUFFICIENT_DISKSPACE_WARNING$", "$EMPTY_STRING$");
            this.validateDiskSpace();
        }
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void uninstallImpl(IAProxy up) throws InstallException {
    }

    boolean IsInstallableChosenForInstallation(Installable installItem) {
        boolean bRet = false;
        String strChosenFeatures = this.m_strChosenFeature;
        String[] strList = strChosenFeatures.split(",");
        if (this.IsThisAnEasyInstallInstallable(installItem)) {
            return true;
        }
        block22: for (int i = 0; i < strList.length; ++i) {
            String strFeature;
            switch (strFeature = strList[i]) {
                case "FTR_APPTIER": {
                    if (installItem.getName().compareToIgnoreCase("CASRVR_AppTier") != 0) continue block22;
                    return true;
                }
                case "FTR_DATATIER": {
                    if (installItem.getName().compareToIgnoreCase("CASRVR_DataTier") != 0) continue block22;
                    return true;
                }
                case "FTR_GATETIER": {
                    if (installItem.getName().compareToIgnoreCase("CASRVR_Gate") != 0) continue block22;
                    return true;
                }
                case "FTR_FM": {
                    if (installItem.getName().compareToIgnoreCase("CACLIENT_fm") != 0) continue block22;
                    return true;
                }
                case "FTR_DCUBE": {
                    if (installItem.getName().compareToIgnoreCase("CACLIENT_dcubemodel") != 0) continue block22;
                    return true;
                }
                case "FTR_DQA": {
                    if (installItem.getName().compareToIgnoreCase("CACLIENT_dqa") != 0) continue block22;
                    return true;
                }
                case "FTR_LCM": {
                    if (installItem.getName().compareToIgnoreCase("CACLIENT_lcm") != 0) continue block22;
                    return true;
                }
                case "FTR_JUPYTER": {
                    if (installItem.getName().compareToIgnoreCase("CA_JupyterServer") != 0) continue block22;
                    return true;
                }
                case "FTR_SDK": {
                    if (installItem.getName().compareToIgnoreCase("CA_SDK") != 0) continue block22;
                    return true;
                }
            }
        }
        return bRet;
    }

    boolean IsThisAnEasyInstallInstallable(Installable installItem) {
        return this.m_strInstallType.compareTo("Easy") == 0 && installItem.getName().compareToIgnoreCase("CASRVR_EasyInstall") == 0;
    }

    void validateDiskSpace() {
        String strLog = "Required Disk space: " + this.diskSpaceRequiredGB + "GB";
        strLog = strLog + "\nAvailable Disk space: " + this.diskSpaceAvailableGB + "GB";
        if (this.m_InstallLog != null) {
            this.m_InstallLog.appendMessage(strLog);
            this.m_InstallLog.log();
        }
        this.m_strInstallDestination = this.m_installProxy.substitute("$USER_INSTALL_DIR$");
        if (this.diskSpaceAvailableGB < this.diskSpaceRequiredGB) {
            String info4;
            String info3;
            String info2;
            String info1 = this.m_installProxy.getValue("InstallDiskSpace.info1");
            if (info1.equals("")) {
                this.m_installProxy.getValue("InstallDiskSpace.info1", Locale.ENGLISH);
            }
            if ((info2 = this.m_installProxy.getValue("InstallDiskSpace.info2")).equals("")) {
                this.m_installProxy.getValue("InstallDiskSpace.info2", Locale.ENGLISH);
            }
            if ((info3 = this.m_installProxy.getValue("InstallDiskSpace.info3")).equals("")) {
                this.m_installProxy.getValue("InstallDiskSpace.info3", Locale.ENGLISH);
            }
            if ((info4 = this.m_installProxy.getValue("InstallDiskSpace.info4")).equals("")) {
                this.m_installProxy.getValue("InstallDiskSpace.info4", Locale.ENGLISH);
            }
            DecimalFormat df = new DecimalFormat("#.##");
            df.setRoundingMode(RoundingMode.CEILING);
            strLog = info1 + " " + this.m_strInstallDestination;
            strLog = strLog + "\n" + info2 + " " + df.format(this.diskSpaceRequiredGB) + "GB\n" + info3 + " " + this.diskSpaceAvailableGB + "GB";
            strLog = strLog + "\n" + info4;
            if (this.m_InstallLog != null) {
                this.m_InstallLog.appendError(strLog, 97);
                this.m_InstallLog.log();
            }
            this.m_installProxy.setVariable("$INSUFFICIENT_DISKSPACE_WARNING$", strLog);
        }
    }
}

