/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.FatalInstallException;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import core.InstallerState;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import manifest.CmpList;
import manifest.InstallManifest;
import manifest.InstallMetadata;
import manifest.Installable;
import manifest.Part;
import repository.AbstractExternalRepository;

public class InstallFromRepo
extends CustomCodeAction {
    protected static final String IDS_REPO = "repo";
    protected static final String IDS_REPO_ZIP = "repo.zip";
    public static final String BACKSLASH = "\\";
    public static final String FORWARD_SLASH = "/";
    protected static final String IDS_ZIP = ".zip";
    protected static final String IDS_PREFIX_ARCHIVE = "archive-";
    protected static final String IDS_HTTP = "http";
    public static final String UNINSTALL = "uninstall";
    public static final String LOGS = "logs";
    public static final String MANIFEST_FILE_PATTERN = "*manifest*.json";
    String m_strInstallDestination = "";
    String m_strLaunchDir = "";
    String m_strChosenFeature = "";
    String m_strInstallType = "Custom";
    String m_strInstallExecutable = "";
    CustomError m_InstallLog = null;
    CustomError m_UninstallLog = null;
    InstallerProxy m_installProxy = null;

    public void InitializeMemberVariables(String strInstallLocation, String strChosenFeaures, String strInstallationType) {
        this.m_strInstallDestination = strInstallLocation;
        this.m_strChosenFeature = strChosenFeaures;
        this.m_strInstallType = strInstallationType;
        InstallerState.log.debug("InstallFromRepo::m_strInstallType: ", this.m_strInstallType);
        InstallerState.log.debug("InstallFromRepo::m_strChosenFeature: ", this.m_strChosenFeature);
    }

    @Override
    public void install(InstallerProxy ip) throws InstallException {
        InstallManifest iManifest;
        block9: {
            String strLog;
            block8: {
                if (ip != null) {
                    this.m_installProxy = ip;
                    this.m_InstallLog = (CustomError)ip.getService(CustomError.class);
                    this.m_InstallLog.setLogDescription("Download and Extract Files: ");
                    this.m_InstallLog.log();
                    this.m_strLaunchDir = ip.substitute("$INSTALLER_LAUNCH_DIR$");
                    this.m_strLaunchDir = this.m_strLaunchDir + File.separator;
                    this.m_strInstallDestination = ip.substitute("$USER_INSTALL_DIR$");
                    this.m_strChosenFeature = ip.substitute("$CHOSEN_FEATURE_LIST$");
                    String strChosenInstallType = ip.substitute("$BISRVR_INSTALLTYPE_READY$");
                    if (strChosenInstallType.equals("1")) {
                        this.m_strInstallType = "Easy";
                    }
                    this.m_strInstallExecutable = ip.substitute("$EXTRACTOR_EXECUTABLE$");
                    InstallerState.log.debug("InstallFromRepo::m_strInstallType: ", this.m_strInstallType);
                    InstallerState.log.debug("InstallFromRepo::m_strChosenFeature: ", this.m_strChosenFeature);
                }
                iManifest = this.ProcessManifest();
                iManifest.applyOverrides(InstallerState.partOverrides);
                try {
                    this.InstallParts(InstallerState.repository, iManifest);
                }
                catch (Exception e1) {
                    FatalInstallException e = new FatalInstallException(e1.getMessage());
                    throw e;
                }
                try {
                    CmpList.write(iManifest, this.m_strInstallDestination + File.separator + "cmplst.txt", this.m_strInstallType, this.m_strChosenFeature, this.m_strInstallExecutable);
                }
                catch (IOException e) {
                    strLog = "Error generating the file cmplst.txt\n" + e.getMessage();
                    if (this.m_InstallLog == null) break block8;
                    this.m_InstallLog.appendError(strLog, 97);
                    this.m_InstallLog.log();
                }
            }
            try {
                InstallMetadata.write(iManifest, this.m_strInstallDestination + File.separator + "configuration" + File.separator + InstallerState.CONFIGURATION_METADATA_DIR, "metadata_install.xml");
            }
            catch (IOException e) {
                strLog = "Error generating the file metadata_install.xml\n" + e.getMessage();
                if (this.m_InstallLog == null) break block9;
                this.m_InstallLog.appendError(strLog, 97);
                this.m_InstallLog.log();
            }
        }
        this.installSelectedManifest(iManifest);
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void uninstall(UninstallerProxy up) throws InstallException {
        this.m_strInstallDestination = up.substitute("$USER_INSTALL_DIR$");
        this.m_UninstallLog = (CustomError)up.getService(CustomError.class);
        this.m_UninstallLog.setLogDescription("Delete folders custom action: ");
        this.m_UninstallLog.log();
        String progressText = "";
        up.setProgressStatusText(progressText);
        String userInstallDir = up.substitute("$USER_INSTALL_DIR$");
        String manifestDir = userInstallDir + File.separator + UNINSTALL + File.separator + LOGS;
        InstallFromRepo.deleteFilesByFileNamePattern(manifestDir, MANIFEST_FILE_PATTERN);
        this.m_UninstallLog.setLogDescription("Delete manifest from " + manifestDir + " custom action: ");
        this.m_UninstallLog.log();
        ArrayList<String> exludeDirs = new ArrayList<String>();
        exludeDirs.add(UNINSTALL);
        exludeDirs.add("install_backup");
        File installLocation = new File(userInstallDir);
        this.deletePath(installLocation, exludeDirs);
    }

    private InstallManifest ProcessManifest() {
        InstallManifest iManifest = CARepositoryState.GetRepositoryState().GetInstallSelectedManifest();
        InstallerState.log.debug("InstallFromRepo::ProcessManifest():iManifest", iManifest.getManifestName());
        for (Installable installItem : iManifest.getInstallables()) {
            if (installItem.isSelectedForInstallation() || !this.IsInstallableChosenForInstallation(installItem)) continue;
            installItem.setSelectedForInstallation(true);
            if (installItem.getinstallablesRef() == null) continue;
            for (String ref : installItem.getinstallablesRef()) {
                iManifest.getInstallable(ref).setSelectedForInstallation(true);
                Installable installSubItem = iManifest.getInstallable(ref);
                if (installSubItem.getinstallablesRef() == null) continue;
                for (String refSubItem : installSubItem.getinstallablesRef()) {
                    iManifest.getInstallable(refSubItem).setSelectedForInstallation(true);
                }
            }
        }
        return iManifest;
    }

    boolean IsInstallableChosenForInstallation(Installable installItem) {
        boolean bRet = false;
        String strChosenFeatures = this.m_strChosenFeature;
        String[] strList = strChosenFeatures.split(",");
        InstallerState.log.debug("InstallFromRepo::IsInstallableChosenForInstallation():m_strChosenFeature: ", strChosenFeatures);
        if (this.IsThisAnEasyInstallInstallable(installItem)) {
            InstallerState.log.debug("InstallFromRepo::IsInstallableChosenForInstallation():EasyInstall", "TRUE");
            return true;
        }
        block22: for (int i = 0; i < strList.length; ++i) {
            String strFeature;
            switch (strFeature = strList[i]) {
                case "FTR_APPTIER": {
                    if (installItem.getName().compareToIgnoreCase("CASRVR_AppTier") != 0) continue block22;
                    return true;
                }
                case "FTR_DATATIER": {
                    if (installItem.getName().compareToIgnoreCase("CASRVR_DataTier") != 0) continue block22;
                    return true;
                }
                case "FTR_GATETIER": {
                    if (installItem.getName().compareToIgnoreCase("CASRVR_Gate") != 0) continue block22;
                    return true;
                }
                case "FTR_FM": {
                    if (installItem.getName().compareToIgnoreCase("CACLIENT_fm") != 0) continue block22;
                    return true;
                }
                case "FTR_DCUBE": {
                    if (installItem.getName().compareToIgnoreCase("CACLIENT_dcubemodel") != 0) continue block22;
                    return true;
                }
                case "FTR_DQA": {
                    if (installItem.getName().compareToIgnoreCase("CACLIENT_dqa") != 0) continue block22;
                    return true;
                }
                case "FTR_LCM": {
                    if (installItem.getName().compareToIgnoreCase("CACLIENT_lcm") != 0) continue block22;
                    return true;
                }
                case "FTR_JUPYTER": {
                    if (installItem.getName().compareToIgnoreCase("CA_JupyterServer") != 0) continue block22;
                    return true;
                }
                case "FTR_SDK": {
                    if (installItem.getName().compareToIgnoreCase("CA_SDK") != 0) continue block22;
                    return true;
                }
            }
        }
        return bRet;
    }

    int InstallParts(AbstractExternalRepository repo, InstallManifest iManifest) throws Exception {
        long totalInstallSize = iManifest.getSelectedInstallablesSize();
        float numOfPercentAvailable = 92.0f;
        float progressCountPerSizeUnit = 0.0f;
        float progressPercentToAddPerPart = 0.0f;
        if (totalInstallSize > 0L) {
            progressCountPerSizeUnit = numOfPercentAvailable / (float)totalInstallSize;
        }
        HashSet<Part> installedParts = new HashSet<Part>();
        int currentprogress = 4;
        for (Installable installItem : iManifest.getInstallables()) {
            if (!installItem.isSelectedForInstallation()) continue;
            for (Part partItem : installItem.getParts()) {
                if (installedParts.contains(partItem)) continue;
                String strLogMsg = "\nInstalling archive: " + partItem.getRepositoryPath() + "\n";
                InstallerState.log.debug("Install Parts", strLogMsg);
                if (this.m_InstallLog != null) {
                    this.m_InstallLog.setLogDescription(strLogMsg);
                    this.m_InstallLog.log();
                }
                try {
                    String progressText = partItem.getName();
                    if (this.m_installProxy != null) {
                        this.m_installProxy.setProgressStatusText(progressText);
                    }
                    partItem.install(repo, this.m_strInstallDestination, installItem.getInstallpath());
                    if (this.m_installProxy != null && (progressPercentToAddPerPart += (float)partItem.getSize() * progressCountPerSizeUnit) >= 1.0f) {
                        this.m_installProxy.setProgressPercentage(++currentprogress);
                        progressPercentToAddPerPart = 0.0f;
                    }
                    installedParts.add(partItem);
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    String strLog = "\nError installing file: " + partItem.getRepositoryPath() + " \nException Message: " + e.getMessage() + " \nCall Stack:\n" + sw.toString() + "\n";
                    if (this.m_InstallLog != null) {
                        this.m_InstallLog.appendError(strLog, 97);
                        this.m_InstallLog.log();
                    }
                    InstallerState.log.error("InstallFromRepo::InstallParts()", strLog);
                    throw e;
                }
            }
        }
        return 0;
    }

    boolean IsThisAnEasyInstallInstallable(Installable installItem) {
        return this.m_strInstallType.compareTo("Easy") == 0 && installItem.getName().compareToIgnoreCase("CASRVR_EasyInstall") == 0;
    }

    public void deletePath(File pathtodelete, List<String> excludeList) {
        block7: {
            try {
                File[] listpathtodelete = pathtodelete.listFiles();
                if (listpathtodelete != null) {
                    for (File f : listpathtodelete) {
                        if (!excludeList.contains(f.getName())) {
                            this.deletePath(f, excludeList);
                            continue;
                        }
                        String strLog = "excluding file/folder : " + f.getName();
                        if (this.m_UninstallLog == null) continue;
                        this.m_UninstallLog.appendMessage(strLog);
                        this.m_UninstallLog.log();
                    }
                }
                if (!pathtodelete.getAbsolutePath().equals(this.m_strInstallDestination)) {
                    pathtodelete.delete();
                    String strLog = "successfully deleted file/folder : " + pathtodelete.getName();
                    if (this.m_UninstallLog != null) {
                        this.m_UninstallLog.appendMessage(strLog);
                        this.m_UninstallLog.log();
                    }
                }
            }
            catch (Exception e) {
                String strLog = "Error deleting file/folder : " + pathtodelete.getName() + "\n" + e.getMessage();
                if (this.m_UninstallLog == null) break block7;
                this.m_UninstallLog.appendError(strLog, 97);
                this.m_UninstallLog.log();
            }
        }
    }

    @Override
    public long getEstimatedTimeToInstall(InstallerProxy ip) {
        return 12000L;
    }

    private void installSelectedManifest(InstallManifest iManifest) {
        String manifestOutputDir = this.m_strInstallDestination + File.separator + UNINSTALL + File.separator + LOGS + File.separator;
        File outDir = new File(manifestOutputDir);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        String manifestName = CARepositoryState.GetRepositoryState().GetInstallSelectedManifestName();
        manifestName = manifestName.replace(BACKSLASH, FORWARD_SLASH);
        manifestName = manifestName.substring(manifestName.lastIndexOf(FORWARD_SLASH) + 1);
        try {
            InstallManifest.prettyPrintJsonObjToFile(manifestOutputDir + manifestName, iManifest);
            String strLog = manifestName + " is written to " + manifestOutputDir;
            if (this.m_UninstallLog != null) {
                this.m_UninstallLog.appendMessage(strLog);
                this.m_UninstallLog.log();
            }
        }
        catch (FileNotFoundException e) {
            String strMsg = String.format(InstallerState.LOCALIZED_WRITING_MANIFEST_ERROR, manifestOutputDir + manifestName);
            InstallerState.log.error("InstallFromRepo::installSelectedManifest()", strMsg + e.getMessage());
        }
    }

    public static void deleteFilesByFileNamePattern(String userInstallDir, String fileNamePattern) {
        Path path = Paths.get(userInstallDir, new String[0]);
        try (DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(path, fileNamePattern);){
            for (Path newDirectoryStreamItem : newDirectoryStream) {
                Files.delete(newDirectoryStreamItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

