/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomCodePanel;
import com.zerog.ia.api.pub.CustomCodePanelProxy;
import com.zerog.ia.api.pub.ReplayVariableService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class PasswordPanelLcm
extends CustomCodePanel {
    private boolean inited = false;
    private Font plainFont;
    private Font boldFont;
    private Font boldSubTitleFont;
    private Map<String, JTextField> varName2TextField = new HashMap<String, JTextField>();
    String databaseType = "";
    private static final String PASSWORD_PATTERN = "((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%]).{15,20})";
    private static final String USERNAME_PATTERN = "[a-zA-Z]{1}([a-zA-Z0-9]|[._]){4,19}$";
    private Pattern pattern = Pattern.compile("((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%]).{15,20})");
    private Matcher matcher;
    private Pattern userpattern = Pattern.compile("[a-zA-Z]{1}([a-zA-Z0-9]|[._]){4,19}$");
    private Matcher usermatcher;

    public static void infoBox(String infoMessage, String titleBar) {
        JOptionPane.showMessageDialog(null, infoMessage, "Error: " + titleBar, 1);
    }

    public boolean validateWindowsCredReq(String password) {
        this.matcher = this.pattern.matcher(password);
        return this.matcher.matches();
    }

    public boolean validateWindowsUserReq(String user) {
        this.usermatcher = this.userpattern.matcher(user);
        return this.usermatcher.matches();
    }

    @Override
    public boolean setupUI(CustomCodePanelProxy customCodePanelProxy) {
        if (!this.inited) {
            String fontName = "SansSerif";
            LineBorder border = new LineBorder(Color.GRAY, 1, true);
            int fontSize = 14;
            this.plainFont = new Font("SansSerif", 0, 14);
            this.boldFont = new Font("SansSerif", 1, 14);
            int fontBigSize = System.getProperty("os.name").contains("Windows") ? 16 : 14;
            this.boldSubTitleFont = new Font("SansSerif", 1, fontBigSize);
            this.setLayout(new BorderLayout());
            Panel dataEntryPanel = new Panel();
            this.add((Component)dataEntryPanel, "North");
            dataEntryPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(11, 11, 0, 11);
            gbc.fill = 2;
            Panel topPanel = new Panel();
            String text1 = customCodePanelProxy.getValue("PasswordCustomPanel.textarea1Lcm");
            if (text1.equals("")) {
                text1 = customCodePanelProxy.getValue("PasswordCustomPanel.textarea1Lcm", Locale.ENGLISH);
            }
            String text2 = customCodePanelProxy.getValue("PasswordCustomPanel.textarea2");
            if (text1.equals("")) {
                text2 = customCodePanelProxy.getValue("PasswordCustomPanel.textarea2", Locale.ENGLISH);
            }
            JTextArea topPrompt = new JTextArea(text1 + text2);
            topPrompt.setRows(5);
            topPrompt.setEditable(false);
            topPrompt.setFont(this.plainFont);
            topPrompt.setOpaque(false);
            topPrompt.setLineWrap(true);
            topPrompt.setWrapStyleWord(true);
            ReplayVariableService replay = (ReplayVariableService)customCodePanelProxy.getService(ReplayVariableService.class);
            dataEntryPanel.add((Component)this.makeLabelField(customCodePanelProxy.getValue("PasswordCustomPanel.CreateCredentials"), 20), gbc);
            gbc.gridy = 1;
            dataEntryPanel.add((Component)topPrompt, gbc);
            gbc.gridy = 2;
            String userlabel = customCodePanelProxy.getValue("PasswordCustomPanel.user");
            if (userlabel.equals("")) {
                userlabel = customCodePanelProxy.getValue("PasswordCustomPanel.user", Locale.ENGLISH);
            }
            dataEntryPanel.add((Component)this.makeEditField(userlabel, "$BISRVR_COGNOSUSER$", 20), gbc);
            replay.register("$BISRVR_COGNOSUSER$", userlabel);
            gbc.gridy = 3;
            String pwlabel = customCodePanelProxy.getValue("PasswordCustomPanel.password");
            if (pwlabel.equals("")) {
                pwlabel = customCodePanelProxy.getValue("PasswordCustomPanel.password", Locale.ENGLISH);
            }
            dataEntryPanel.add((Component)this.makePasswordField(pwlabel, "$BISRVR_COGNOSUSER_PASSWORD$", 29), gbc);
            replay.register("$BISRVR_COGNOSUSER_PASSWORD$", pwlabel);
            replay.addVariableException("$BISRVR_COGNOSUSER_PASSWORD$", 4);
            gbc.gridy = 4;
            String pwcnflabel = customCodePanelProxy.getValue("PasswordCustomPanel.cnfpassword");
            if (pwcnflabel.equals("")) {
                pwcnflabel = customCodePanelProxy.getValue("PasswordCustomPanel.cnfpassword", Locale.ENGLISH);
            }
            dataEntryPanel.add((Component)this.makePasswordField(pwcnflabel, "$BISRVR_COGNOSUSER_CONFIRM_PASSWORD$", 21), gbc);
            replay.addVariableException("$BISRVR_COGNOSUSER_CONFIRM_PASSWORD$", 4);
            this.inited = true;
        }
        return true;
    }

    private Panel makeEditField(String labelText, String varName, int hgap) {
        Panel panel = new Panel(new GridLayout(0, 1));
        panel.add(this.makeLabel(labelText));
        LineBorder border = new LineBorder(Color.GRAY, 1, true);
        JTextField tf = new JTextField();
        tf.setFont(this.plainFont);
        tf.setBorder(border);
        tf.setPreferredSize(new Dimension(300, 20));
        panel.add(tf);
        this.varName2TextField.put(varName, tf);
        return panel;
    }

    private Panel makeLabelField(String labelText, int hgap) {
        Panel panel = new Panel(new GridLayout(0, 1));
        JLabel label = new JLabel(labelText, 2);
        label.setFont(this.boldSubTitleFont);
        panel.add(label);
        LineBorder border = new LineBorder(Color.GRAY, 1, true);
        return panel;
    }

    private Panel makePasswordField(String labelText, String varName, int hgap) {
        Panel panel = new Panel(new GridLayout(0, 1));
        panel.add(this.makeLabel(labelText));
        LineBorder border = new LineBorder(Color.GRAY, 1, true);
        JPasswordField tf = new JPasswordField();
        tf.setBorder(border);
        tf.setPreferredSize(new Dimension(300, 20));
        panel.add(tf);
        this.varName2TextField.put(varName, tf);
        return panel;
    }

    private JLabel makeLabel(String text) {
        JLabel label = new JLabel(text, 2);
        label.setFont(this.plainFont);
        return label;
    }

    @Override
    public String getTitle() {
        return " ";
    }

    @Override
    public void panelIsDisplayed() {
        this.populate("$BISRVR_COGNOSUSER$");
        this.populate("$BISRVR_COGNOSUSER_PASSWORD$");
        this.populate("$BISRVR_COGNOSUSER_CONFIRM_PASSWORD$");
    }

    private void populate(String varName) {
        JTextField tf = this.varName2TextField.get(varName);
        String value = (String)customCodePanelProxy.getVariable(varName);
        tf.setText(value);
    }

    @Override
    public boolean okToContinue() {
        String pw = "";
        String user = "";
        for (Map.Entry<String, JTextField> entry : this.varName2TextField.entrySet()) {
            String varName = entry.getKey();
            JTextField tf = entry.getValue();
            String value = tf.getText().trim();
            if (varName.equals("$BISRVR_COGNOSUSER$") && !this.validateWindowsUserReq(user = value)) {
                String badpw = customCodePanelProxy.getValue("PasswordCustomPanel.userrule");
                if (badpw.equals("")) {
                    badpw = customCodePanelProxy.getValue("PasswordCustomPanel.userrule", Locale.ENGLISH);
                }
                PasswordPanelLcm.infoBox(badpw, customCodePanelProxy.getValue("PasswordCustomPanel.userinfotitle"));
                return false;
            }
            if (varName.equals("$BISRVR_COGNOSUSER_PASSWORD$")) {
                pw = value;
                if (!this.validateWindowsCredReq(pw)) {
                    String badpw = customCodePanelProxy.getValue("PasswordCustomPanel.pwruleLcm");
                    if (badpw.equals("")) {
                        badpw = customCodePanelProxy.getValue("PasswordCustomPanel.pwruleLcm", Locale.ENGLISH);
                    }
                    PasswordPanelLcm.infoBox(badpw, customCodePanelProxy.getValue("PasswordCustomPanel.infotitle"));
                    return false;
                }
                int n = pw.indexOf(33);
                if (n != -1) {
                    String badpw = customCodePanelProxy.getValue("PasswordCustomPanel.pwrule");
                    if (badpw.equals("")) {
                        badpw = customCodePanelProxy.getValue("PasswordCustomPanel.pwrule", Locale.ENGLISH);
                    }
                    PasswordPanelLcm.infoBox(badpw, customCodePanelProxy.getValue("PasswordCustomPanel.infotitle"));
                    return false;
                }
            }
            if (varName.equals("$BISRVR_COGNOSUSER_CONFIRM_PASSWORD$") && !value.equals(pw)) {
                String badpw = customCodePanelProxy.getValue("PasswordCustomPanel.nomatch");
                if (badpw.equals("")) {
                    badpw = customCodePanelProxy.getValue("PasswordCustomPanel.nomatch", Locale.ENGLISH);
                }
                PasswordPanelLcm.infoBox(badpw, customCodePanelProxy.getValue("PasswordCustomPanel.infotitle"));
                return false;
            }
            customCodePanelProxy.setVariable(varName, value);
        }
        return true;
    }
}

