/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.FatalInstallException;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import core.CustomCodeActionShim;
import core.InstallerState;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

public class PreserveFiles
extends CustomCodeActionShim {
    static final List<String> m_listExcludeFiles = new ArrayList<String>();

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void installImpl(IAProxy ip) throws InstallException {
        m_listExcludeFiles.clear();
        String strPreserveListFile = ip.substitute("$PRESERVE_LIST_FILENAME$");
        String strBackupDirectory = ip.substitute("$USER_INSTALL_BACKUP_DIR$");
        String strInstallDirectory = ip.substitute("$USER_INSTALL_DIR$");
        String strBackupOrRestoreMode = ip.substitute("$BACKUP_OR_RESTORE_MODE$");
        String strExcludeId = ip.substitute("$EXCLUDE_IDENTIFIER$");
        if (strExcludeId.isEmpty()) {
            strExcludeId = "exclude:";
        }
        boolean bBackup = false;
        String strSourceFolderRoot = "";
        String strDestinationFolderRoot = "";
        String strSourceFile = "";
        String strDestinationFile = "";
        try {
            if (strBackupOrRestoreMode.contains("backup")) {
                strSourceFolderRoot = strInstallDirectory;
                strDestinationFolderRoot = strBackupDirectory;
                bBackup = true;
            } else {
                strSourceFolderRoot = strBackupDirectory;
                strDestinationFolderRoot = strInstallDirectory;
            }
            strSourceFolderRoot = strSourceFolderRoot + File.separator;
            strDestinationFolderRoot = strDestinationFolderRoot + File.separator;
            List<String> listFilebyLine = this.ReadFileIntoList(strPreserveListFile);
            for (String line : listFilebyLine) {
                if (line.isEmpty() || line.contains("#")) continue;
                if (line.contains("*")) {
                    this.UseCopyCommand(strSourceFolderRoot, strDestinationFolderRoot, line);
                    continue;
                }
                if (line.contains(strExcludeId)) {
                    if (!bBackup) continue;
                    line = line.replace("\\", "/");
                    m_listExcludeFiles.add(line.substring(strExcludeId.length()));
                    continue;
                }
                if (line.contains("\\")) {
                    line = line.replace("\\", "/");
                }
                strSourceFile = strSourceFolderRoot + line;
                strDestinationFile = strDestinationFolderRoot + line;
                File source = new File(strSourceFile);
                File destination = new File(strDestinationFile);
                PreserveFiles.copyFiles(source, destination);
            }
        }
        catch (Exception e) {
            InstallerState.log.error("PreserveFiles::installImpl,SourceFile:" + strSourceFile + ",DestFile:" + strDestinationFile, e.getMessage());
            throw new FatalInstallException(e.getLocalizedMessage());
        }
    }

    private List<String> ReadFileIntoList(String strPreserveListFile) throws IOException {
        ArrayList<String> listFileByLine = new ArrayList<String>();
        listFileByLine.clear();
        try (BufferedReader BRPreserveFile = new BufferedReader(new FileReader(strPreserveListFile));){
            String line = BRPreserveFile.readLine();
            while (line != null) {
                listFileByLine.add(line.trim());
                line = BRPreserveFile.readLine();
            }
            BRPreserveFile.close();
        }
        return listFileByLine;
    }

    public static void copyFiles(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            String[] files;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            for (String file : files = source.list()) {
                File srcFile = new File(source, file);
                File destFile = new File(destination, file);
                PreserveFiles.copyFiles(srcFile, destFile);
            }
        } else {
            if (!source.isFile()) {
                return;
            }
            if (PreserveFiles.ExcludeFile(source)) {
                return;
            }
            if (!destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
            try {
                Files.copy(source.toPath(), destination.toPath(), options);
            }
            catch (IOException e) {
                InstallerState.log.error("PreserveFiles::copyFiles,SourceFile:" + source.toString() + ",DestFile:" + destination.toString(), e.getMessage());
                throw new IOException(e.getLocalizedMessage());
            }
        }
    }

    private static boolean ExcludeFile(File file) {
        boolean bRet = false;
        if (!m_listExcludeFiles.isEmpty()) {
            String strCurrentFile = file.toString();
            String strUpdatedFile = strCurrentFile.replace("\\", "/");
            for (String strExcludeFile : m_listExcludeFiles) {
                if (!strUpdatedFile.contains(strExcludeFile)) continue;
                bRet = true;
                break;
            }
        }
        return bRet;
    }

    private boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().indexOf("win") != -1;
    }

    public void UseCopyCommand(String strSourceFolderRoot, String strDestinationFolderRoot, String line) throws IOException {
        String strCPCommand = "cp ";
        String strLine = line.replace("\\", "/");
        strSourceFolderRoot = strSourceFolderRoot.replace("\\", "/");
        strDestinationFolderRoot = strDestinationFolderRoot.replace("\\", "/");
        String strSubFolder = "";
        String strWildCard = strLine;
        if (strLine.contains("/")) {
            strSubFolder = strLine.substring(0, strLine.lastIndexOf("/"));
            strWildCard = strLine.substring(strLine.lastIndexOf("/") + 1);
        }
        String strSourceFile = strSourceFolderRoot + strSubFolder;
        String strDestFile = strDestinationFolderRoot + strSubFolder;
        File destFolder = new File(strDestFile);
        if (!destFolder.exists()) {
            destFolder.mkdirs();
        }
        if (this.isWindowsPlatform()) {
            strCPCommand = "robocopy " + strSourceFile + " " + strDestFile + " " + strWildCard;
            try {
                Runtime.getRuntime().exec(strCPCommand);
                System.out.println(strCPCommand);
            }
            catch (IOException e) {
                InstallerState.log.error("PreserveFiles::UseCopyCommand:" + strCPCommand, e.getMessage());
                throw new IOException(e.getLocalizedMessage());
            }
        }
        strSourceFile = strSourceFile + File.separator + strWildCard;
        strCPCommand = strCPCommand + strSourceFile + " " + strDestFile;
        try {
            Process proc = new ProcessBuilder("bash", "-c", strCPCommand).start();
            proc.waitFor();
        }
        catch (IOException e) {
            InstallerState.log.error("PreserveFiles::UseCopyCommand:bash -c " + strCPCommand, e.getMessage());
            throw new IOException(e.getLocalizedMessage());
        }
        catch (InterruptedException e) {
            InstallerState.log.error("PreserveFiles::UseCopyCommand:bash -c " + strCPCommand, e.getMessage());
            throw new IOException(e.getLocalizedMessage());
        }
    }

    @Override
    protected void uninstallImpl(IAProxy iap) throws InstallException {
    }
}

