/*
 * Decompiled with CFR 0.152.
 */
import core.InstallerState;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import manifest.Installable;
import manifest.Part;
import manifest.UnsupportedArchiveException;
import repository.ExternalRepositoryException;

public class RepoLicense {
    String m_strSelectedProduct = "";
    String m_strExtractionDirectory = "";
    String m_strLicenseDirectory = "";
    String IDS_PARTNAME_LICENSE = "license";
    String IDS_PARTNAME_CA_RELEASE = "ca-release";
    String IDS_CASRVR_INSTALLABLE = "CASRVR_AppTier";
    String IDS_BISERVER_LICENSE_FOLDER = "BI_Server";
    String IDS_FM_PRODUCTNAME = "fm";
    String IDS_BIMODEL_LICENSE_FOLDER = "bimodel";

    RepoLicense(String strSelectedProduct, String strExtractionDirectory) {
        this.m_strSelectedProduct = strSelectedProduct;
        this.m_strExtractionDirectory = strExtractionDirectory;
        this.m_strLicenseDirectory = this.m_strSelectedProduct;
        if (this.m_strLicenseDirectory.contains(this.IDS_CASRVR_INSTALLABLE)) {
            this.m_strLicenseDirectory = this.IDS_BISERVER_LICENSE_FOLDER;
        } else if (this.m_strLicenseDirectory.contains(this.IDS_FM_PRODUCTNAME)) {
            this.m_strLicenseDirectory = this.IDS_BIMODEL_LICENSE_FOLDER;
        }
    }

    public installPartError GetLicense() throws ExternalRepositoryException, IOException, UnsupportedArchiveException {
        installPartError iRet = installPartError.SUCCESS;
        if (InstallerState.repository == null || InstallerState.manifest == null) {
            return installPartError.ERR_REPO_MANIFEST;
        }
        iRet = this.GetLicensePart();
        return iRet;
    }

    private installPartError GetLicensePart() throws ExternalRepositoryException, IOException, UnsupportedArchiveException {
        boolean bExtractCaRelease = false;
        Installable productInstallable = InstallerState.manifest.getInstallableByProductName(this.m_strSelectedProduct);
        if (productInstallable == null) {
            return installPartError.ERR_INSTALLABLE;
        }
        Part licensePart = this.GetLicensePartFromInstallable(productInstallable, this.IDS_PARTNAME_LICENSE);
        if (licensePart == null && (licensePart = this.GetLicensePartFromInstallable(productInstallable, this.IDS_PARTNAME_CA_RELEASE)) != null) {
            bExtractCaRelease = true;
        }
        if (licensePart == null) {
            return installPartError.ERR_PART;
        }
        licensePart.install(InstallerState.repository, this.m_strExtractionDirectory, "");
        if (bExtractCaRelease) {
            this.UpdateLicenseFilesLocation();
        }
        return installPartError.SUCCESS;
    }

    private void UpdateLicenseFilesLocation() throws IOException {
        String strSourcePath = this.m_strExtractionDirectory + File.separator + this.IDS_PARTNAME_LICENSE + File.separator + this.m_strLicenseDirectory;
        String strDestPath = this.m_strExtractionDirectory + File.separator + this.IDS_PARTNAME_LICENSE;
        this.copyLicenseFiles(new File(strSourcePath), new File(strDestPath));
    }

    private void copyLicenseFiles(File sourcePath, File destPath) throws IOException {
        String[] files;
        if (destPath.exists()) {
            this.CleanupLicenseFiles(destPath);
        }
        CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
        for (String file : files = sourcePath.list()) {
            File srcFile = new File(sourcePath, file);
            File destFile = new File(destPath, file);
            Files.copy(srcFile.toPath(), destFile.toPath(), options);
        }
    }

    private void CleanupLicenseFiles(File destPath) {
        String[] files;
        for (String file : files = destPath.list()) {
            File destFile = new File(destPath, file);
            if (!destFile.isFile()) continue;
            destFile.delete();
        }
    }

    private Part GetLicensePartFromInstallable(Installable productInstallable, String strLicensePartName) {
        Part licensePart = null;
        String[] listInstallableRefs = productInstallable.getinstallablesRef();
        licensePart = productInstallable.getPart(strLicensePartName);
        if (licensePart == null && listInstallableRefs != null) {
            for (String item : listInstallableRefs) {
                Installable installableItem = InstallerState.manifest.getInstallable(item);
                if (installableItem != null) {
                    licensePart = installableItem.getPart(strLicensePartName);
                }
                if (licensePart != null) break;
            }
        }
        return licensePart;
    }

    public static enum installPartError {
        SUCCESS,
        ERR_REPO_MANIFEST,
        ERR_INSTALLABLE,
        ERR_PART;

    }
}

