/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import core.InstallerState;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import manifest.InstallManifest;
import repository.ExternalRepositoryException;

public class RepositoryState {
    String m_strLaunchDir = "";
    protected static final String BACKSLASH = "\\";
    protected static final String FORWARD_SLASH = "/";
    private List<InstallManifest> m_listManifest = new ArrayList<InstallManifest>();
    private InstallManifest m_InstallSelectedManifest = null;
    private String m_strInstallSelectedManifestName = "";
    private String IDS_VAR_ID = "_var";

    public RepositoryState(String strRepoName, String strManifest, String strLaunchDir, boolean bSilentInstall, IAProxy iap) throws InstallException, ExternalRepositoryException {
        this.m_strLaunchDir = strLaunchDir + File.separator;
        String strRepoMsg = "";
        try {
            if (InstallerState.repository == null) {
                strRepoMsg = InstallerState.openRepo(iap, strRepoName);
            }
            if (!strRepoMsg.isEmpty()) {
                throw new ExternalRepositoryException(strRepoMsg);
            }
            this.SetManifests(strManifest, strLaunchDir);
        }
        catch (Exception e) {
            if (bSilentInstall) {
                InstallerState.log.error("RepositoryState", e.getLocalizedMessage());
            }
            throw new ExternalRepositoryException(e.getLocalizedMessage());
        }
    }

    private void SetManifests(String strManifest, String strInstallLaunchDir) throws Exception {
        InstallManifest badManifest = null;
        if (strManifest.isEmpty()) {
            for (String strManifestItem : InstallerState.repository.GetLatestManifests()) {
                InstallerState.log.debug("set manifests", strManifestItem);
                InstallManifest iManifest = InstallManifest.decode(InstallerState.repository.getRepositoryFileAsString(strManifestItem));
                String ret = InstallerState.compatibleWithManifest(iManifest);
                if (!ret.isEmpty()) {
                    badManifest = iManifest;
                    InstallerState.log.info("RepositoryState", ret);
                    continue;
                }
                iManifest.setManifestName(strManifestItem);
                this.m_listManifest.add(iManifest);
            }
            Collections.reverse(this.m_listManifest);
            if (this.m_listManifest.size() == 0 && badManifest != null) {
                Exception e = new Exception(InstallerState.getIncompatibleManifestMessage(badManifest));
                throw e;
            }
            if (this.m_listManifest.size() == 1) {
                InstallerState.manifest = this.m_listManifest.get(0);
            }
        } else {
            this.m_InstallSelectedManifest = InstallManifest.decode(this.GetLocalOrRepoManifest(strManifest));
            String ret = InstallerState.compatibleWithManifest(this.m_InstallSelectedManifest);
            if (!ret.isEmpty()) {
                Exception e = new Exception(ret);
                throw e;
            }
            this.m_InstallSelectedManifest.setManifestName(strManifest);
            this.m_listManifest.add(this.m_InstallSelectedManifest);
            InstallerState.manifest = this.m_InstallSelectedManifest;
        }
        if (InstallerState.manifest != null && InstallerState.manifest.getManifestName().contains(this.IDS_VAR_ID)) {
            InstallerState.setBundlerInstall(true);
        }
    }

    private String GetLocalOrRepoManifest(String strManifest) throws ExternalRepositoryException, IOException {
        String strManifestFileAsString = "";
        String strManifestFile = strManifest;
        File fManifest = new File(strManifestFile);
        if (!fManifest.exists()) {
            strManifestFile = this.m_strLaunchDir + strManifest;
            fManifest = new File(strManifestFile);
        }
        if (fManifest.exists()) {
            strManifestFileAsString = this.GetManifestFileAsString(strManifestFile);
        } else {
            strManifestFile = InstallerState.repository.findManifest(strManifest);
            if (!strManifestFile.isEmpty()) {
                strManifestFileAsString = InstallerState.repository.getRepositoryFileAsString(strManifestFile);
            }
        }
        this.m_strInstallSelectedManifestName = strManifestFile;
        return strManifestFileAsString;
    }

    private String GetManifestFileAsString(String strManifest) throws IOException {
        String strReturnManifest = "";
        try {
            FileInputStream is = new FileInputStream(strManifest);
            strReturnManifest = this.ConvertToString(is);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        return strReturnManifest;
    }

    private String ConvertToString(InputStream inputStream) {
        String text = null;
        Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());
        text = scanner.useDelimiter("\\A").next();
        scanner.close();
        return text;
    }

    public InstallManifest GetInstallSelectedManifest() {
        return InstallerState.manifest;
    }

    public void SetSilentInstallManifest(String strCAServerInstall, String strCAClientInstall) {
        if (strCAServerInstall.equals("1")) {
            this.SetInstallSelectedManifest(0);
        } else if (strCAClientInstall.equals("1")) {
            this.SetInstallSelectedManifest(1);
        } else if (strCAServerInstall.isEmpty() && strCAClientInstall.isEmpty()) {
            this.SetInstallSelectedManifest(0);
        }
    }

    public void SetInstallSelectedManifest(int nManifestId) {
        if (this.m_listManifest.size() == 1) {
            InstallerState.setManifest(this.m_listManifest.get(0));
        } else if (nManifestId == 0) {
            for (InstallManifest iManifest : this.m_listManifest) {
                if (iManifest.DoesInstallableExist(InstallerState.INSTALLABLEID.APPTIER)) {
                    InstallerState.setManifest(iManifest);
                } else if (iManifest.DoesInstallableExist(InstallerState.INSTALLABLEID.DATATIER)) {
                    InstallerState.setManifest(iManifest);
                } else {
                    if (!iManifest.DoesInstallableExist(InstallerState.INSTALLABLEID.GATETIER)) continue;
                    InstallerState.setManifest(iManifest);
                }
                break;
            }
        } else if (nManifestId == 1) {
            for (InstallManifest iManifest : this.m_listManifest) {
                if (iManifest.DoesInstallableExist(InstallerState.INSTALLABLEID.FM)) {
                    InstallerState.setManifest(iManifest);
                } else if (iManifest.DoesInstallableExist(InstallerState.INSTALLABLEID.DCUBEMODEL)) {
                    InstallerState.setManifest(iManifest);
                } else if (iManifest.DoesInstallableExist(InstallerState.INSTALLABLEID.DQA)) {
                    InstallerState.setManifest(iManifest);
                } else if (iManifest.DoesInstallableExist(InstallerState.INSTALLABLEID.JUPYTER)) {
                    InstallerState.setManifest(iManifest);
                } else {
                    if (!iManifest.DoesInstallableExist(InstallerState.INSTALLABLEID.SDK)) continue;
                    InstallerState.setManifest(iManifest);
                }
                break;
            }
        }
        if (InstallerState.manifest != null) {
            this.m_strInstallSelectedManifestName = InstallerState.manifest.getManifestName();
        }
        InstallerState.log.debug("RepositoryState::SetInstallSelectedManifest()::m_strInstallSelectedManifestName: ", this.m_strInstallSelectedManifestName);
    }

    public void UpdateInstallSelectedManifestForClient(InstallerState.INSTALLABLEID nClientInstallableId) {
        if (this.m_listManifest.size() == 1) {
            InstallerState.setManifest(this.m_listManifest.get(0));
        } else {
            for (InstallManifest iManifest : this.m_listManifest) {
                if (!iManifest.DoesInstallableExist(nClientInstallableId)) continue;
                InstallerState.setManifest(iManifest);
                break;
            }
        }
        if (InstallerState.manifest != null) {
            this.m_strInstallSelectedManifestName = InstallerState.manifest.getManifestName();
        }
        InstallerState.log.debug("RepositoryState::UpdateInstallSelectedManifestForClient()::m_strInstallSelectedManifestName: ", this.m_strInstallSelectedManifestName);
    }

    public String GetInstallSelectedManifestName() {
        return this.m_strInstallSelectedManifestName;
    }

    public String GetInstallablesAsList() {
        String strInstallablesAsList = "";
        for (InstallManifest iManifest : this.m_listManifest) {
            if (strInstallablesAsList.isEmpty()) {
                strInstallablesAsList = iManifest.getInstallablesAsList();
                continue;
            }
            strInstallablesAsList = strInstallablesAsList + ",";
            strInstallablesAsList = strInstallablesAsList + iManifest.getInstallablesAsList();
        }
        return strInstallablesAsList;
    }
}

