/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateLcmsrvrxml
extends CustomCodeAction {
    public static void updateXML(String filepath, int port, String username, String passwd, String porttype) {
        try {
            Node reg;
            Node nodeAttr;
            NamedNodeMap attr;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(filepath);
            Node httpNode = doc.getElementsByTagName("httpEndpoint").item(0);
            if (porttype == "http") {
                attr = httpNode.getAttributes();
                nodeAttr = attr.getNamedItem("httpPort");
                nodeAttr.setTextContent(String.valueOf(port));
            }
            if (porttype == "https") {
                attr = httpNode.getAttributes();
                nodeAttr = attr.getNamedItem("httpsPort");
                nodeAttr.setTextContent(String.valueOf(port));
            }
            if ((reg = doc.getElementsByTagName("basicRegistry").item(0)) != null) {
                NodeList userNodes;
                boolean userExists = false;
                Element enode = null;
                if (reg.getNodeType() == 1) {
                    enode = (Element)reg;
                }
                if (enode != null && (userNodes = enode.getElementsByTagName("user")) != null) {
                    for (int i = 0; i < userNodes.getLength(); ++i) {
                        Element el;
                        Node userNode = userNodes.item(i);
                        if (userNode.getNodeType() != 1 || !(el = (Element)userNode).getAttribute("name").equals(username)) continue;
                        userExists = true;
                        break;
                    }
                }
                if (!userExists) {
                    NodeList groupNodes;
                    Element user = doc.createElement("user");
                    user.setAttribute("name", username);
                    user.setAttribute("password", passwd);
                    reg.insertBefore(user, reg.getFirstChild());
                    if (enode != null && (groupNodes = enode.getElementsByTagName("group")) != null) {
                        for (int i = 0; i < groupNodes.getLength(); ++i) {
                            Element el;
                            Node groupNode = groupNodes.item(i);
                            if (groupNode.getNodeType() != 1 || !(el = (Element)groupNode).getAttribute("name").equals("admins")) continue;
                            Element user1 = doc.createElement("member");
                            user1.setAttribute("name", username);
                            el.insertBefore(user1, groupNode.getFirstChild());
                            break;
                        }
                    }
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(filepath));
            transformer.transform(source, result);
            System.out.println("Successfully updated the " + filepath);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException sae) {
            sae.printStackTrace();
        }
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void install(InstallerProxy ip) throws InstallException {
        String VAR_SERVER_XML = File.separator + "wlp" + File.separator + "usr" + File.separator + "servers" + File.separator + "lcm" + File.separator + "server.xml";
        String VAR_SECURITY_UTILITY_PATH = File.separator + "wlp" + File.separator + "bin" + File.separator + "securityUtility";
        String VAR_JRE = File.separator + "ibm-jre" + File.separator + "jre";
        String VAR_COMMAND1 = "cmd /c set JAVA_HOME=";
        String VAR_QUOTE = "\"";
        if (!UpdateLcmsrvrxml.isWindowsPlatform()) {
            VAR_COMMAND1 = "setenv JAVA_HOME ";
            VAR_QUOTE = "";
        }
        String filepath = ip.getVariable("$USER_INSTALL_DIR$") + VAR_SERVER_XML;
        int port = (Integer)ip.getVariable("$AVAILABLE_PORT$");
        String user = (String)ip.getVariable("$BISRVR_COGNOSUSER$");
        String passwd = (String)ip.getVariable("$BISRVR_COGNOSUSER_PASSWORD$");
        String wlpbinpath = ip.getVariable("$USER_INSTALL_DIR$") + VAR_SECURITY_UTILITY_PATH;
        String jrepath = ip.getVariable("$USER_INSTALL_DIR$") + VAR_JRE;
        String cmd1 = VAR_COMMAND1 + jrepath + "&&";
        String cmd2 = VAR_QUOTE + wlpbinpath + VAR_QUOTE + " encode " + passwd;
        BufferedReader in = null;
        String encPasswd = "";
        try {
            Process proc = null;
            proc = UpdateLcmsrvrxml.isWindowsPlatform() ? Runtime.getRuntime().exec(cmd1 + cmd2) : Runtime.getRuntime().exec(cmd2);
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                encPasswd = line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UpdateLcmsrvrxml.updateXML(filepath, port, user, encPasswd, "http");
    }

    @Override
    public void uninstall(UninstallerProxy up) throws InstallException {
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().indexOf("win") != -1;
    }
}

