/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import core.CustomCodeActionShim;
import core.InstallerState;
import java.io.File;

public class ValidateCmdLineArguments
extends CustomCodeActionShim {
    public static final String CMD_ARG_REPO = "$REPO$";
    public static final String CMD_ARG_MANIFEST = "$MANIFEST$";
    public static final String CMD_ARG_INSTALLABLE = "$INSTALLABLE$";
    public static final String CMD_ARG_LOGLEVEL = "$LOGLEVEL$";
    public static final String CMD_ARG_LOGFILE = "$LOGFILE$";
    public static final String CMD_ARG_USER_INSTALL_DIR = "$USER_INSTALL_DIR$";
    public static final String CMD_ARG_NOCHECKSUM = "$NOCHECKSUM$";
    public static final String CMD_ARG_PART_OVERRIDE = "$PART_OVERRIDE$";
    public static final String CMD_ARG_MANIFEST_HINTS = "$MANIFEST_HINTS$";
    public static final String CMD_ARG_CACHE_DIR = "$CACHE_DIR$";
    public static final String RESULT_LOGFILE_VAR = "$VALIDATE_INSTALL_DATA_LOGFILE$";
    public static final String RESULT_LOGLEVEL_VAR = "$VALIDATE_INSTALL_DATA_LOGLEVEL$";
    public static final String RESULT_REPO_VAR = "$VALIDATE_INSTALL_DATA_REPO$";
    public static final String RESULT_MANIFEST_VAR = "$VALIDATE_INSTALL_DATA_MANIFEST$";
    public static final String RESULT_INSTALLABLE_VAR = "$VALIDATE_INSTALL_DATA_INSTALLABLE$";
    public static final String RESULT_USER_INSTALL_DIR_VAR = "$VALIDATE_INSTALL_DATA_USER_INSTALL_DIR$";

    @Override
    public void installImpl(IAProxy iap) throws InstallException {
        InstallerState.setLocalizedMessages(iap);
        String value = iap.substitute(CMD_ARG_LOGLEVEL);
        if (!value.isEmpty()) {
            iap.setVariable(RESULT_LOGLEVEL_VAR, InstallerState.setLogLevel(value));
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_LOGLEVEL) + "=" + value);
        }
        if (!(value = iap.substitute(CMD_ARG_LOGFILE)).isEmpty()) {
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_LOGFILE) + "=" + value);
            iap.setVariable(RESULT_LOGFILE_VAR, InstallerState.openLogFile(this.getAbsolutePath(iap, value)));
        }
        if (!(value = iap.substitute(CMD_ARG_MANIFEST_HINTS)).isEmpty()) {
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_MANIFEST_HINTS) + "=" + value);
            InstallerState.setManifestHints(value);
        }
        if (!(value = iap.substitute(CMD_ARG_REPO)).isEmpty()) {
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_REPO) + "=" + value);
            iap.setVariable(RESULT_REPO_VAR, InstallerState.openRepo(iap, value));
        }
        if (!(value = iap.substitute(CMD_ARG_MANIFEST)).isEmpty()) {
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_MANIFEST) + "=" + value);
            iap.setVariable(RESULT_MANIFEST_VAR, InstallerState.openManifest(iap, value));
        }
        if (!(value = iap.substitute(CMD_ARG_INSTALLABLE)).isEmpty()) {
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_INSTALLABLE) + "=" + value);
            iap.setVariable(RESULT_INSTALLABLE_VAR, InstallerState.validateInstallables(iap, value));
        }
        if (!(value = iap.substitute(CMD_ARG_NOCHECKSUM)).isEmpty()) {
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_NOCHECKSUM) + "=" + value);
            InstallerState.setNoChecksum(value);
        }
        if (!(value = iap.substitute(CMD_ARG_PART_OVERRIDE)).isEmpty()) {
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_PART_OVERRIDE) + "=" + value);
            InstallerState.setPartOverrides(value);
        }
        if (!(value = iap.substitute(CMD_ARG_CACHE_DIR)).isEmpty()) {
            InstallerState.log.debug("Validate command line", this.cleanArg(CMD_ARG_CACHE_DIR) + "=" + value);
            InstallerState.setRepositoryCacheDir(this.getAbsolutePath(iap, value));
        }
    }

    private String getAbsolutePath(IAProxy iap, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            String strLaunchDir = iap.substitute("$INSTALLER_LAUNCH_DIR$");
            path = strLaunchDir + File.separator + path;
        }
        return path;
    }

    private String cleanArg(String arg) {
        return arg.replace("$", "");
    }

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void uninstallImpl(IAProxy up) throws InstallException {
    }
}

