/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.InstallerProxy;
import core.Utility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class ValidateResponseFile {
    public static final String VAR_INSTALL_DIR = "USER_INSTALL_DIR";
    public static final String VAR_INSTALLTYPE_READY = "BISRVR_INSTALLTYPE_READY";
    public static final String VAR_INSTALLTYPE_EXPAND = "BISRVR_INSTALLTYPE_EXPAND";
    public static final String VAR_INSTALLTYPE_CUSTOM = "BISRVR_INSTALLTYPE_CUSTOM";
    public static final String VAR_FEATURE_DATA = "BISRVR_FEATURE_DATATIER";
    public static final String VAR_FEATURE_APP = "BISRVR_FEATURE_APPTIER";
    public static final String VAR_FEATURE_GATE = "BISRVR_FEATURE_GATEWAY";
    public static final String VAR_USER = "BISRVR_COGNOSUSER";
    public static final String VAR_USER_PASSWORD = "BISRVR_COGNOSUSER_PASSWORD";
    public static String[] installTypes = new String[]{"BISRVR_INSTALLTYPE_READY", "BISRVR_INSTALLTYPE_CUSTOM"};
    public static String[] installFeatures = new String[]{"BISRVR_FEATURE_DATATIER", "BISRVR_FEATURE_APPTIER", "BISRVR_FEATURE_GATEWAY"};
    public static String[] installFeaturesNoData = new String[]{"BISRVR_FEATURE_APPTIER", "BISRVR_FEATURE_GATEWAY"};
    String fileName = null;
    Properties props = null;

    public ValidateResponseFile(String fileName) {
        this.fileName = fileName;
        this.props = new Properties();
        InputStream inputStr = this.getClass().getResourceAsStream(fileName);
        if (inputStr != null) {
            try {
                this.props.load(inputStr);
            }
            catch (IOException ex) {
                String errorMsg = "Failed to load this file: " + fileName + "\r\n" + ex.getMessage();
                System.out.println(errorMsg);
            }
        }
    }

    public ValidateResponseFile(Properties props) {
        this.props = props;
    }

    public String validate(InstallerProxy ip) {
        if (this.props == null) {
            return null;
        }
        String errorMsg = null;
        errorMsg = this.validatePath(this.props);
        if (errorMsg != null) {
            return errorMsg;
        }
        if (!this.isUpgradeInstall(this.props.getProperty(VAR_INSTALL_DIR))) {
            errorMsg = this.validateInstallType(this.props);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (this.isRTR(this.props)) {
                errorMsg = this.validateRTR(this.props, ip);
            } else if (this.isCustom(this.props)) {
                errorMsg = this.validateCustom(this.props);
            }
        }
        return errorMsg;
    }

    public boolean isUpgradeInstall(String userInstallDir) {
        String cmplstFile = userInstallDir + File.separator + "cmplst.txt";
        return new File(cmplstFile).exists();
    }

    private String validateCustom(Properties props) {
        boolean bUrl = true;
        boolean bNamespace = true;
        boolean bUsername = true;
        boolean bPassword = true;
        String errorMsg = null;
        boolean featureChosen = false;
        for (int i = 0; i < installFeatures.length; ++i) {
            if (!this.propEnabled(props, installFeatures[i])) continue;
            featureChosen = true;
        }
        if (!featureChosen) {
            errorMsg = "For custom first install, you need to set at least one feature to 1. These includes: BISRVR_FEATURE_APPTIER, BISRVR_FEATURE_DATATIER, and BISRVR_FEATURE_GATEWAY";
        }
        return errorMsg;
    }

    private String validateRTR(Properties props, InstallerProxy ip) {
        String errorMsg = null;
        String cognosUser = props.getProperty(VAR_USER);
        String password = props.getProperty(VAR_USER_PASSWORD);
        if (!this.valueSet(cognosUser) || !this.valueSet(password)) {
            return "Missing BISRVR_COGNOSUSER or BISRVR_COGNOSUSER_PASSWORD for ready-to-run install, i.e. when BISRVR_INSTALLTYPE_READY=1";
        }
        if (!Utility.validateUsername(cognosUser)) {
            String strErrorMessage = ip.getValue("PasswordCustomPanel.userrule");
            if (strErrorMessage.equals("")) {
                strErrorMessage = ip.getValue("PasswordCustomPanel.userrule", Locale.ENGLISH);
            }
            return strErrorMessage;
        }
        if (!Utility.validatePassword(password, "((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$]).{15,20})")) {
            String strErrorMessage = ip.getValue("PasswordCustomPanel.pwrule");
            if (strErrorMessage.equals("")) {
                strErrorMessage = ip.getValue("PasswordCustomPanel.pwrule", Locale.ENGLISH);
            }
            return strErrorMessage;
        }
        return errorMsg;
    }

    private boolean valueSet(String variable) {
        return variable != null && !variable.isEmpty();
    }

    private boolean isCustom(Properties props) {
        return this.propEnabled(props, VAR_INSTALLTYPE_CUSTOM);
    }

    private boolean isRTR(Properties props) {
        return this.propEnabled(props, VAR_INSTALLTYPE_READY);
    }

    private boolean propEnabled(Properties props, String installType) {
        return props.containsKey(installType) && props.getProperty(installType).equals("1");
    }

    private String validateInstallType(Properties props) {
        String errorMsg = null;
        boolean bTypeDefined = false;
        if (!this.isWindowsPlatform()) {
            return errorMsg;
        }
        for (int i = 0; i < installTypes.length; ++i) {
            String installTypeVar = installTypes[i];
            if (!props.containsKey(installTypeVar) || !props.getProperty(installTypeVar).equals("1")) continue;
            if (bTypeDefined) {
                errorMsg = "You should have one and only one BISRVR_INSTALLTYPE_* variable set to 1";
            }
            bTypeDefined = true;
        }
        if (!bTypeDefined) {
            errorMsg = "You should have one of the BISRVR_INSTALLTYPE_* variable set to 1. ";
        }
        return errorMsg;
    }

    private String validatePath(Properties props) {
        String errorMsg = null;
        if (!props.containsKey(VAR_INSTALL_DIR)) {
            errorMsg = "Missing install directory. You need to set USER_INSTALL_DIR variable in the silent install properties file";
        } else {
            String installPath = props.getProperty(VAR_INSTALL_DIR);
            if (installPath == null || installPath.isEmpty()) {
                errorMsg = "Missing install directory. You need to set USER_INSTALL_DIR variable in the silent install properties file";
            }
        }
        if (props.contains(VAR_INSTALLTYPE_READY) && props.getProperty(VAR_INSTALLTYPE_READY).equals("1") && !this.isWindowsPlatform()) {
            errorMsg = "BISRVR_INSTALLTYPE_READY should not set to 1 on this platform. It's only supported by windows.";
        }
        return errorMsg;
    }

    private boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().indexOf("win") != -1;
    }
}

