/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import core.InstallerState;
import java.io.File;
import java.util.Properties;

public class ValidateSilentParameters
extends CustomCodeAction {
    public static final String INFORMIXDIR = "informix";
    public static final String ZERO = "0";
    public static final String ONE = "1";
    public static final String BISRVR_INSTALLTYPE_READY = "$BISRVR_INSTALLTYPE_READY$";
    public static final String BISRVR_INSTALLTYPE_CUSTOM = "$BISRVR_INSTALLTYPE_CUSTOM$";
    public static final String USER_INSTALL_DIR = "$USER_INSTALL_DIR$";

    @Override
    public String getInstallStatusMessage() {
        return "Executing command...";
    }

    @Override
    public String getUninstallStatusMessage() {
        return "Executing command..";
    }

    @Override
    public void install(InstallerProxy ip) throws InstallException {
        String strErrorMessage;
        ValidateResponseFile response = null;
        Properties props = new Properties();
        String IA_INSTALL_DIR = ip.substitute(USER_INSTALL_DIR);
        String IA_INSTALLTYPE_READY = ip.substitute(BISRVR_INSTALLTYPE_READY);
        String IA_INSTALLTYPE_CUSTOM = ip.substitute(BISRVR_INSTALLTYPE_CUSTOM);
        String IA_FEATURE_DATA = ip.substitute("$BISRVR_FEATURE_DATATIER$");
        String IA_FEATURE_APP = ip.substitute("$BISRVR_FEATURE_APPTIER$");
        String IA_FEATURE_GATE = ip.substitute("$BISRVR_FEATURE_GATEWAY$");
        props.put("USER_INSTALL_DIR", IA_INSTALL_DIR);
        props.put("BISRVR_INSTALLTYPE_READY", IA_INSTALLTYPE_READY);
        props.put("BISRVR_INSTALLTYPE_CUSTOM", IA_INSTALLTYPE_CUSTOM);
        props.put("BISRVR_FEATURE_DATATIER", IA_FEATURE_DATA);
        props.put("BISRVR_FEATURE_APPTIER", IA_FEATURE_APP);
        props.put("BISRVR_FEATURE_GATEWAY", IA_FEATURE_GATE);
        if (IA_INSTALLTYPE_READY.equals(ONE)) {
            String IA_USER = ip.substitute("$BISRVR_COGNOSUSER$");
            String IA_USER_PASSWORD = ip.substitute("$BISRVR_COGNOSUSER_PASSWORD$");
            props.put("BISRVR_COGNOSUSER", IA_USER);
            props.put("BISRVR_COGNOSUSER_PASSWORD", IA_USER_PASSWORD);
        }
        if ((strErrorMessage = (response = new ValidateResponseFile(props)).validate(ip)) == null && response.isUpgradeInstall(IA_INSTALL_DIR)) {
            this.setInstallationTypesForUpgradeInstall(ip);
        }
        ip.setVariable("$RESPONSE_VALIDATION_ERRORMESSAGE$", strErrorMessage);
        if (strErrorMessage == null) {
            InstallerState.log.debug("ValidateSilentParameters()", "All silent parameters are valid");
        } else {
            InstallerState.log.error("ValidateSilentParameters()", strErrorMessage);
        }
    }

    void setInstallationTypesForUpgradeInstall(InstallerProxy ip) {
        InstallerState.log.debug("ValidateSilentParameters:setInstallationTypesForUpgradeInstalls", "enter");
        String userInstallDir = ip.substitute(USER_INSTALL_DIR);
        String easyInstallType = ip.substitute(BISRVR_INSTALLTYPE_READY);
        String customInstallType = ip.substitute(BISRVR_INSTALLTYPE_CUSTOM);
        if (easyInstallType.isEmpty() && customInstallType.isEmpty()) {
            File informixDir = new File(userInstallDir + File.separator + INFORMIXDIR);
            if (informixDir.isDirectory() && informixDir.exists()) {
                ip.setVariable(BISRVR_INSTALLTYPE_READY, ONE);
                ip.setVariable(BISRVR_INSTALLTYPE_CUSTOM, ZERO);
            } else {
                ip.setVariable(BISRVR_INSTALLTYPE_CUSTOM, ONE);
                ip.setVariable(BISRVR_INSTALLTYPE_READY, ZERO);
            }
            InstallerState.log.debug("ValidateSilentParameters:setInstallationTypesForUpgradeInstalls:", "Silent response install type missing entries are set as follows:");
            InstallerState.log.debug("ValidateSilentParameters:setInstallationTypesForUpgradeInstalls:", "$BISRVR_INSTALLTYPE_READY$=" + ip.substitute(BISRVR_INSTALLTYPE_READY));
            InstallerState.log.debug("ValidateSilentParameters:setInstallationTypesForUpgradeInstalls:", "$BISRVR_INSTALLTYPE_CUSTOM$=" + ip.substitute(BISRVR_INSTALLTYPE_CUSTOM));
        }
        InstallerState.log.debug("ValidateSilentParameters:setInstallationTypesForUpgradeInstalls", "exit");
    }

    @Override
    public void uninstall(UninstallerProxy up) throws InstallException {
    }
}

