/*
 * Decompiled with CFR 0.152.
 */
import com.zerog.ia.api.pub.CustomCodePanel;
import com.zerog.ia.api.pub.CustomCodePanelProxy;
import com.zerog.ia.api.pub.GUIAccess;
import com.zerog.ia.api.pub.ReplayVariableService;
import core.InstallerState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class WelcomeProductSelectionPanel
extends CustomCodePanel {
    private final String IDS_CASRV_BUTTON_NAME = "WelcomeProductSelectionPanel.RadioButton1Name";
    private final String IDS_CASRV_VAR_BUTTON_NAME = "WelcomeProductSelectionPanel.RadioButton1NameVar";
    private static final long serialVersionUID = 1L;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private boolean inited = false;
    private Font m_plainFont;
    private Font m_boldSubTitleFont;
    private Font m_boldSubTitleBigFont;
    private Color m_ColorBlue = new Color(0, 0, 255);
    private JRadioButton m_rdoButtonBIServer = null;
    private JRadioButton m_rdoButtonClientTools = null;
    boolean bRadioDefaultSelected = false;
    private boolean m_bBIServerEnabled = false;
    private boolean m_bClientToolsEnabled = false;
    String strInstallables = "";

    @Override
    public boolean setupUI(CustomCodePanelProxy customCodePanelProxy) {
        if (!this.inited) {
            String strCTDesc;
            String strBIServerDesc;
            String strBIServer;
            this.InitializeProductVariables(customCodePanelProxy);
            ReplayVariableService replay = (ReplayVariableService)customCodePanelProxy.getService(ReplayVariableService.class);
            String fontName = "SansSerif";
            int fontSize = 12;
            this.m_plainFont = new Font("SansSerif", 0, 12);
            int fontBigBlueSize = 20;
            this.m_boldSubTitleBigFont = new Font("SansSerif", 1, 20);
            int fontBigSize = System.getProperty("os.name").contains("Windows") ? 16 : 14;
            this.m_boldSubTitleFont = new Font("SansSerif", 1, fontBigSize);
            this.setLayout(new BorderLayout());
            Panel dataEntryPanel = new Panel();
            this.add((Component)dataEntryPanel, "North");
            dataEntryPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 3, 0, 3);
            gbc.fill = 2;
            String text1 = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.Description");
            if (text1.isEmpty()) {
                text1 = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.Description", Locale.ENGLISH);
            }
            JTextArea topPrompt = new JTextArea(text1);
            topPrompt.setEditable(false);
            topPrompt.setFont(this.m_boldSubTitleFont);
            topPrompt.setOpaque(false);
            String strSubTitle = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.SubTitle");
            if (strSubTitle.isEmpty()) {
                strSubTitle = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.SubTitle", Locale.ENGLISH);
            }
            dataEntryPanel.add((Component)this.makeLabelField(strSubTitle, 20), gbc);
            gbc.gridy = 1;
            dataEntryPanel.add((Component)topPrompt, gbc);
            gbc.gridy = 2;
            String strServerButtonName = "WelcomeProductSelectionPanel.RadioButton1Name";
            if (InstallerState.IsBundlerInstall) {
                strServerButtonName = "WelcomeProductSelectionPanel.RadioButton1NameVar";
            }
            if ((strBIServer = customCodePanelProxy.getValue(strServerButtonName)).isEmpty()) {
                strBIServer = customCodePanelProxy.getValue(strServerButtonName, Locale.ENGLISH);
            }
            if ((strBIServerDesc = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.RadioButton1Desc")).isEmpty()) {
                strBIServerDesc = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.RadioButton1Desc", Locale.ENGLISH);
            }
            dataEntryPanel.add((Component)this.makeRadioButtonField(clientProduct.BISERVER, strBIServer, strBIServerDesc, this.m_bBIServerEnabled), gbc);
            replay.register("$BISRVR_CA_INSTALL$", String.valueOf(this.m_bBIServerEnabled));
            gbc.gridy = 3;
            String strCT = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.RadioButton2Name");
            if (strCT.isEmpty()) {
                strCT = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.RadioButton2Name", Locale.ENGLISH);
            }
            if ((strCTDesc = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.RadioButton2Desc")).isEmpty()) {
                strCTDesc = customCodePanelProxy.getValue("WelcomeProductSelectionPanel.RadioButton2Desc", Locale.ENGLISH);
            }
            dataEntryPanel.add((Component)this.makeRadioButtonField(clientProduct.CLIENTTOOLS, strCT, strCTDesc, this.m_bClientToolsEnabled), gbc);
            replay.register("$BISRVR_CA_TOOLS_INSTALL$", String.valueOf(this.m_bClientToolsEnabled));
            customCodePanelProxy.setVariable("$MANIFEST_INSTALLABLES$", this.strInstallables);
            this.inited = true;
        }
        return true;
    }

    private void InitializeProductVariables(CustomCodePanelProxy customCodePanelProxy) {
        this.strInstallables = CARepositoryState.GetRepositoryState().GetInstallablesAsList();
        if (this.strInstallables.contains("CASRVR_AppTier") || this.strInstallables.contains("CASRVR_DataTier") || this.strInstallables.contains("CASRVR_Gate") || this.strInstallables.contains("CASRVR_EasyInstall")) {
            this.m_bBIServerEnabled = true;
        }
        if (this.strInstallables.contains("CACLIENT_fm") || this.strInstallables.contains("CACLIENT_lcm") || this.strInstallables.contains("CACLIENT_dcubemodel") || this.strInstallables.contains("CACLIENT_dqa") || this.strInstallables.contains("CA_JupyterServer") || this.strInstallables.contains("CA_SDK")) {
            this.m_bClientToolsEnabled = true;
        }
    }

    private Panel makeLabelField(String labelText, int hgap) {
        Panel panel = new Panel(new GridLayout(0, 1));
        JLabel label = new JLabel(labelText, 2);
        label.setFont(this.m_boldSubTitleBigFont);
        label.setForeground(this.m_ColorBlue);
        panel.add(label);
        return panel;
    }

    private Panel makeRadioButtonField(clientProduct nProduct, String strButtonName, String strButtonDescription, boolean bEnabled) {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        switch (nProduct) {
            case BISERVER: {
                this.m_rdoButtonBIServer = this.makeRadioButton(strButtonName, bEnabled);
                panel.add((Component)this.m_rdoButtonBIServer, gbc);
                break;
            }
            case CLIENTTOOLS: {
                this.m_rdoButtonClientTools = this.makeRadioButton(strButtonName, bEnabled);
                panel.add((Component)this.m_rdoButtonClientTools, gbc);
            }
        }
        JTextArea textArea = new JTextArea(strButtonDescription);
        textArea.setFont(this.m_plainFont);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEnabled(bEnabled);
        textArea.setOpaque(false);
        gbc.insets.left = 20;
        gbc.insets.top = 1;
        gbc.gridy = 1;
        panel.add((Component)textArea, gbc);
        return panel;
    }

    private JRadioButton makeRadioButton(String strButtonName, boolean bEnabled) {
        JRadioButton radioButton = new JRadioButton(strButtonName);
        radioButton.setBackground(null);
        radioButton.setEnabled(bEnabled);
        radioButton.setFont(this.m_plainFont);
        if (bEnabled && !this.bRadioDefaultSelected) {
            radioButton.setSelected(true);
            this.bRadioDefaultSelected = true;
        }
        this.buttonGroup.add(radioButton);
        return radioButton;
    }

    @Override
    public boolean okToContinue() {
        if (this.m_rdoButtonBIServer.isSelected()) {
            customCodePanelProxy.setVariable("$BISRVR_CA_INSTALL$", "1");
            customCodePanelProxy.setVariable("$BISRVR_CA_TOOLS_INSTALL$", "0");
            CARepositoryState.GetRepositoryState().SetInstallSelectedManifest(0);
        } else if (this.m_rdoButtonClientTools.isSelected()) {
            customCodePanelProxy.setVariable("$BISRVR_CA_INSTALL$", "0");
            customCodePanelProxy.setVariable("$BISRVR_CA_TOOLS_INSTALL$", "1");
            CARepositoryState.GetRepositoryState().SetInstallSelectedManifest(1);
        } else {
            customCodePanelProxy.setVariable("$BISRVR_CA_INSTALL$", "0");
            customCodePanelProxy.setVariable("$BISRVR_CA_TOOLS_INSTALL$", "0");
        }
        return true;
    }

    @Override
    public void panelIsDisplayed() {
        GUIAccess gui = (GUIAccess)customCodePanelProxy.getService(GUIAccess.class);
        gui.setPreviousButtonEnabled(false);
    }

    public static enum clientProduct {
        BISERVER,
        CLIENTTOOLS;

    }
}

