/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.actions;

import com.zerog.ia.installer.FileAction;
import com.zerog.ia.installer.IAStatus;
import com.zerog.ia.installer.IAStatusLog;
import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.context.FileActionResource;
import com.zerog.ia.installer.exceptions.ListenerUnknownException;
import com.zerog.ia.installer.uninstall.UninstallService;
import com.zerog.ia.installer.util.ClassInfoManager;
import com.zerog.ia.installer.util.MacFileTyper;
import com.zerog.ia.installer.util.ReplayVariableManager;
import com.zerog.ia.installer.util.VariableManager;
import com.zerog.ia.installer.util.magicfolders.MagicFolder;
import com.zerog.resources.ZGBuildOutputStream;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.ZGUtil;
import com.zerog.util.nativelib.macos.MacFile;
import com.zerog.util.nativelib.win32.Win32FontInstaller;
import java.beans.Beans;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstallFile
extends FileAction
implements UninstallService,
Flexeraap3 {
    public static final String DESCRIPTION = IAResourceBundle.getValue("InstallFile.visualname.self");
    public static final String NONE_YET = DESCRIPTION + ": " + IAResourceBundle.getValue("Designer.Customizer.noNameSpecified");
    public static final String LOG_DESCRIPTION = IAResourceBundle.getValue("Installer.installLog.installFile.description");
    private FileActionResource aa = null;
    public transient InputStream sourceInputStream;
    public transient Flexeraaky ab;
    private long ac = -1L;
    private transient VariableManager ad = VariableManager.getInstance();
    public boolean ae = true;

    public static String[] getSerializableProperties() {
        String[] stringArray = new String[9];
        stringArray[0] = "unixPermissions";
        stringArray[1] = "sourceName";
        stringArray[2] = "overrideUnixPermissions";
        stringArray[3] = "sourcePath";
        stringArray[4] = "shouldUninstall";
        stringArray[5] = "destinationName";
        stringArray[6] = "fileSize";
        stringArray[7] = "macBinary";
        stringArray[8] = "targetCheckKind";
        return stringArray;
    }

    public void au(InputStream inputStream) {
        this.sourceInputStream = inputStream;
    }

    public void setNonZipActionResource(Flexeraajv flexeraajv) {
        this.aa = flexeraajv;
    }

    public InputStream getSourceInputStream() {
        return this.sourceInputStream;
    }

    @Override
    public long getSizeSelf() {
        return this.getFileSize();
    }

    public void setFileSize(long l) {
        this.ac = l;
    }

    public long getFileSize() {
        return this.ac;
    }

    @Override
    public void updatePieceSelf() {
        if (this.ad()) {
            this.ac = ZGUtil.getFileSize(this.makeRawSourcePath());
        }
    }

    public void computeInstallTimeFileSize() {
        if (!Beans.isDesignTime()) {
            this.ac = ZGUtil.getFileSize(this.makeZipArchivePath());
        }
    }

    public void superZipTo(ZGBuildOutputStream zGBuildOutputStream, Hashtable hashtable) {
        try {
            super.zipTo(zGBuildOutputStream, hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void zipTo(ZGBuildOutputStream zGBuildOutputStream, Hashtable hashtable) {
        try {
            Class<?> clazz = Class.forName("com.zerog.ia.designer.build.ZipToUtility");
            Class[] classArray = new Class[4];
            classArray[0] = InstallFile.class;
            classArray[1] = Installer.class;
            classArray[2] = ZGBuildOutputStream.class;
            classArray[3] = Hashtable.class;
            Method method = clazz.getMethod("installFileZipTo", classArray);
            method.invoke(null, this, this.getInstaller(), zGBuildOutputStream, hashtable);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Flexeraaei.aa().av(this.getVisualNameSelf(), null, null, "Zipping of an InstallFile has failed: " + throwable.getMessage());
        }
    }

    private FileActionResource b4() throws IOException {
        if (this.aa != null) {
            return this.aa;
        }
        String string = this.makeZipArchivePath(false);
        try {
            return this.getFileActionContext().getFileActionResource(string);
        }
        catch (Exception exception) {
            string = this.makeZipArchivePath(true);
            return this.getFileActionContext().getFileActionResource(string);
        }
    }

    public String[] getReplayVariables() {
        String string = this.getDestinationPath() + this.getVisualName();
        String[] stringArray = new String[1];
        stringArray[0] = "-fileOverwrite " + ZGUtil.encodeExternalProperty(string, '\\');
        return stringArray;
    }

    @Override
    public IAStatus installSelf() throws Exception {
        String string;
        FileActionResource fileActionResource;
        IAStatus iAStatus;
        block25: {
            block26: {
                block24: {
                    block23: {
                        Flexeraavd.aa("installSelf() called: " + this.getVisualName());
                        iAStatus = new IAStatus(this, 95);
                        if (this.getDestinationPath() == null) break block23;
                        if (!this.getDestinationPath().equals("")) break block24;
                    }
                    iAStatus.appendStatus(IAResourceBundle.getValue("Installlog.installfile.nulldestinationpath"), 97);
                    return iAStatus;
                }
                fileActionResource = this.b4();
                Flexeraald flexeraald = this.createTargetCheck();
                flexeraald.af(fileActionResource.getTime());
                string = this.getDestinationPath() + this.getVisualName();
                string = ZGUtil.encodeExternalProperty(string, '\\');
                string = InstallFile.ca(string);
                string = InstallFile.cb(string);
                ReplayVariableManager replayVariableManager = ReplayVariableManager.getInstance();
                replayVariableManager.register("-fileOverwrite_" + string, IAResourceBundle.getValue("Installer.installLog.logs.install"));
                Object object = this.ad.getVariable("-fileOverwrite_" + string);
                String string2 = null;
                if (object != null) {
                    string2 = object.toString();
                }
                if (!flexeraald.aa()) {
                    if (Flexeraarc.ah == 3) {
                        this.ad.setVariable("-fileOverwrite_" + string, IAResourceBundle.getValue("FileAlreadyExists.no"));
                    } else if (Flexeraarc.ah == 2) {
                        this.ad.setVariable("-fileOverwrite_" + string, IAResourceBundle.getValue("FileAlreadyExists.noAll"));
                    }
                    iAStatus.appendStatus(IAResourceBundle.getValue("Installlog.installfile.nulldestinationpath"), 99);
                    return iAStatus;
                }
                if (string2 == null) break block25;
                if (string2.equalsIgnoreCase(IAResourceBundle.getValue("FileAlreadyExists.no"))) break block26;
                if (!string2.equalsIgnoreCase(IAResourceBundle.getValue("FileAlreadyExists.noAll"))) break block25;
            }
            iAStatus.appendStatus(IAResourceBundle.getValue("Installlog.installfile.nulldestinationpath"), 99);
            return iAStatus;
        }
        if (Flexeraarc.ah == 4 || Flexeraarc.ah == 0) {
            this.ad.setVariable("-fileOverwrite_" + string, IAResourceBundle.getValue("FileAlreadyExists.yes"));
        } else if (Flexeraarc.ah == 1) {
            this.ad.setVariable("-fileOverwrite_" + string, IAResourceBundle.getValue("FileAlreadyExists.yesAll"));
        }
        try {
            this.au(fileActionResource.getInputStream());
            String string3 = this.makeDestinationPath();
            boolean bl = false;
            if (!bl) {
                Flexeraavu flexeraavu = new Flexeraavu(ZGUtil.defaultZipDecoding(this.getDestinationPath()));
                this.b9(flexeraavu);
                Flexeraak1 flexeraak1 = Flexeraak2.aa().ab(string3);
                flexeraak1.ad(this.ae);
                string3 = InstallFile.installFile(this.getSourceInputStream(), flexeraak1, this, fileActionResource.getSize()).ar();
                this.b6();
            }
            this.setFileSize(fileActionResource.getSize());
            this.ab(this);
            if (ZGUtil.UNIX) {
                this.b7();
            }
            if (ZGUtil.MACOS || ZGUtil.MACOSX) {
                this.b8();
            }
            this.b5(fileActionResource, string3);
            if (this.isFontFile(string3) && !Win32FontInstaller.aa(string3)) {
                iAStatus.appendStatus(IAResourceBundle.getValue("Installlog.installfile.fontnotinstalled"), 97);
            }
        }
        catch (Exception exception) {
            this.b6();
            iAStatus.appendStatus(exception.toString(), 97);
        }
        catch (ThreadDeath threadDeath) {
            this.b6();
            throw threadDeath;
        }
        iAStatus.setDestinationPath(ZGUtil.defaultZipDecoding(this.getDestinationPath()));
        iAStatus.setDestinationName(ZGUtil.defaultZipDecoding(this.getDestinationName()));
        return iAStatus;
    }

    private void b5(FileActionResource fileActionResource, String string) {
        if (this.getFileActionContext().getFileModificationTimestampBehavior() != 0) {
            if (this.getFileActionContext().getFileModificationTimestampBehavior() == 1) {
                long l = fileActionResource.getTime();
                this.setFileModificationTimestamp(string, l);
            } else {
                this.setFileModificationTimestamp(string, this.getFileActionContext().getFileModificationTimestamp());
            }
        }
    }

    private void b6() {
        InputStream inputStream = this.getSourceInputStream();
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.au(null);
    }

    public static Flexeraak9 installFile(InputStream inputStream, Flexeraak1 flexeraak1, final InstallPiece installPiece, final long l) throws Flexeraak8, IOException {
        flexeraak1.ag(new Flexeraala(){

            @Override
            public void statusChanged(Flexeraak9 flexeraak9) {
                flexeraak9.ab((float)((double)flexeraak9.al() / (double)l));
                if (installPiece != null) {
                    installPiece.processEvent(flexeraak9);
                }
            }
        });
        return flexeraak1.ac(inputStream);
    }

    public static Flexeraak9 installFile(FileActionResource fileActionResource, Flexeraak1 flexeraak1, InstallPiece installPiece) throws Flexeraak8, IOException {
        long l = fileActionResource.getSize();
        InputStream inputStream = fileActionResource.getInputStream();
        return InstallFile.installFile(inputStream, flexeraak1, installPiece, l);
    }

    @Override
    public String getLogDescription() {
        if (!Flexeraaq7.aq() || Flexeraaq7.ac() == 1 || Flexeraaq7.ac() == 3) {
            return this.getLogContext() + this.getDestinationPath() + this.getDestinationName();
        }
        return this.getLogContext() + this.getUninstallPath();
    }

    public String getLogContext() {
        String string = !Flexeraaq7.aq() || Flexeraaq7.ac() == 1 || Flexeraaq7.ac() == 3 ? Flexeraavs.af(LOG_DESCRIPTION, 26) : Flexeraavs.af(IAResourceBundle.getValue("Installer.installLog.uninstallFile.description"), 26);
        return string;
    }

    @Override
    public void addListener(EventListener eventListener) throws ListenerUnknownException {
        if (eventListener instanceof Flexeraaky) {
            this.ab = Flexeraako.ac(this.ab, (Flexeraaky)eventListener);
        } else {
            super.addListener(eventListener);
        }
    }

    @Override
    public void removeListener(EventListener eventListener) throws ListenerUnknownException {
        if (eventListener instanceof Flexeraaky) {
            this.ab = Flexeraako.ad(this.ab, (Flexeraaky)eventListener);
        } else {
            super.removeListener(eventListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void b7() {
        String string = this.makeDestinationPath();
        if (this.getOverrideUnixPermissions()) {
            if (ZGUtil.MACOSX && ZGUtil.isRunningAuthenticator()) {
                Flexeraaw8.aq().as(string, new int[]{0, 1}, new String[]{this.getUnixPermissions(), ZGUtil.getUnixAdminGroupName()});
                return;
            }
            Flexeraaw8.aq().au(string, this.getUnixPermissions(), false, true);
            return;
        }
        if (this.getFileActionContext() != null && this.getFileActionContext().getUnixPermissions() != null) {
            if (!"".equals(this.getFileActionContext().getUnixPermissions()) && !ZGUtil.MACOSX) {
                Flexeraaw8.aq().au(string, this.getFileActionContext().getUnixPermissions(), false, true);
                return;
            }
        }
        if (this.getFileActionContext() != null && this.getFileActionContext().getMacOSXPermissions() != null) {
            if (!"".equals(this.getFileActionContext().getMacOSXPermissions()) && ZGUtil.MACOSX) {
                if (ZGUtil.isRunningAuthenticator()) {
                    Flexeraaw8.aq().as(string, new int[]{0, 1}, new String[]{this.getFileActionContext().getMacOSXPermissions(), ZGUtil.getUnixAdminGroupName()});
                    return;
                }
                Flexeraaw8.aq().aw(string, this.getFileActionContext().getMacOSXPermissions());
                return;
            }
        }
        System.err.println(LOG_DESCRIPTION + " Could not get default permissions from installer");
        if (ZGUtil.MACOSX && ZGUtil.isRunningAuthenticator()) {
            Flexeraaw8.aq().as(string, new int[]{0, 1}, new String[]{this.getFileActionContext().getMacOSXPermissions(), ZGUtil.getUnixAdminGroupName()});
            return;
        }
        Flexeraaw8.aq().au(string, null, false, true);
    }

    private void b8() {
        Flexeraavu flexeraavu = new Flexeraavu(this.getDestinationPath() + this.getDestinationName());
        Flexeraavu.ab(flexeraavu);
        MacFileTyper macFileTyper = null;
        macFileTyper = MacFileTyper.getInstance();
        if (macFileTyper != null) {
            macFileTyper.addFile(flexeraavu);
        }
    }

    public void setRisksReboot(boolean bl) {
        this.ae = bl;
    }

    private void b9(Flexeraavu flexeraavu) {
        if (!flexeraavu.exists()) {
            IAStatus iAStatus = new IAStatus(Flexeraavs.af(IAResourceBundle.getValue("Installer.installLog.installDirectory.description"), 26) + flexeraavu.getAbsolutePath());
            iAStatus.setDestinationPath(flexeraavu.getAbsolutePath());
            if (!flexeraavu.mkdirs()) {
                if (!flexeraavu.canWrite()) {
                    iAStatus.appendStatus(IAResourceBundle.getValue("Installlog.installfile.inadequatepermissions"), 97);
                } else {
                    iAStatus.appendStatus(IAResourceBundle.getValue("Installlog.installfile.failedtocreatedirectory") + ZGUtil.defaultZipDecoding(this.getDestinationPath()), 97);
                }
            }
            IAStatusLog.getInstance().addStatus(iAStatus);
        }
    }

    @Override
    public void processEvent(Flexeraakn flexeraakn) {
        if (this.ab != null) {
            if (flexeraakn instanceof Flexeraakz) {
                this.ab.ae((Flexeraakz)flexeraakn);
            } else if (flexeraakn instanceof Flexeraakx) {
                this.ab.af((Flexeraakx)flexeraakn);
            }
        }
        super.processEvent(flexeraakn);
    }

    public void setW32BoundToExecutable(InstallFile installFile) {
    }

    @Override
    public boolean isInClasspath() {
        return false;
    }

    @Override
    public FileAction rootOfClasspath() {
        if (this.getDestinationName().endsWith(".class")) {
            String string = Flexeraamn.ab((DataInputStream)new DataInputStream(ZGUtil.getInputStream(this.makeSourcePath())));
            return this.getRootOfClasspathHelper(string);
        }
        return null;
    }

    public FileAction getRootOfClasspathHelper(String string) {
        String string2 = this.getDestinationPath().replace('\\', '/') + this.getDestinationName().substring(0, this.getDestinationName().length() - 6);
        if (string2.endsWith(string)) {
            int n = 1;
            int n2 = 0;
            while ((n2 = string.indexOf(47, n2 + 1)) != -1) {
                ++n;
            }
            FileAction fileAction = this;
            while (n-- > 0) {
                fileAction = (FileAction)fileAction.getDestinationAction();
            }
            return fileAction;
        }
        System.err.println(LOG_DESCRIPTION + " File package doesn't match destination path:\n" + "  Path: " + string2 + "\n  Package: " + string);
        return null;
    }

    public static boolean canBeDisplayed() {
        return false;
    }

    public static boolean canBePreAction() {
        return false;
    }

    public static boolean canBePostAction() {
        return false;
    }

    @Override
    public String getUnixPermissions() {
        if (this.am == null) {
            this.am = "664";
        }
        return this.am;
    }

    @Override
    public String getVisualNameSelf() {
        String string;
        block3: {
            block2: {
                string = super.getVisualNameSelf();
                if (string == null) break block2;
                if (!string.trim().equals("")) break block3;
            }
            return NONE_YET;
        }
        return string;
    }

    @Override
    public int getUninstallSequenceNum() {
        return 2040;
    }

    @Override
    public String getUninstallDisplayName(String string) {
        String string2 = this.getUninstallFilePath(string);
        if (string2 != null) {
            return new Flexeraavu(string2).getName();
        }
        return "";
    }

    @Override
    public long getEstimatedTimeToUninstall(String string) {
        return 1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] uninstall(String string) {
        Flexeraavd.aa(LOG_DESCRIPTION + " UNINSTALL: " + string);
        String string2 = this.getUninstallFilePath(string);
        this.setUninstallPath(string2);
        File file = new File(string2);
        IAStatus iAStatus = new IAStatus((Object)this, Flexeraavs.af(IAResourceBundle.getValue("Installer.installLog.uninstallFile.description"), 26) + string2, 95);
        if (file.exists()) {
            if (this.isFontFile(string2) && !Win32FontInstaller.ab(string2)) {
                System.err.println("Could not uninstall font " + string2);
                iAStatus = new IAStatus((Object)this, Flexeraavs.af(IAResourceBundle.getValue("Installer.installLog.uninstallFile.description"), 26) + IAResourceBundle.getValue("Installlog.InstallFile.UninstallFont"), 97);
            }
            if (this.aa(file.getAbsolutePath())) {
                IAStatusLog.getInstance().addStatus(iAStatus);
                return new String[0];
            }
            System.err.println("Could not delete " + string2);
            iAStatus = new IAStatus((Object)this, Flexeraavs.af(IAResourceBundle.getValue("Installer.installLog.uninstallFile.description"), 26) + IAResourceBundle.getValue("Installlog.InstallFile.CouldNotDelete"), 97);
            if (!ZGUtil.MACOS) {
                return new String[]{string2};
            }
            System.err.println("    Mac OS: attempting to move to the trash");
            try {
                MacFile macFile = new MacFile(file);
                macFile.moveToTrash();
            }
            catch (IOException iOException) {
                System.err.println("    - move failed: " + iOException);
                iAStatus = new IAStatus((Object)this, Flexeraavs.af(IAResourceBundle.getValue("Installer.installLog.uninstallFile.description"), 26) + IAResourceBundle.getValue("Installlog.InstallFile.MoveFailed"), 97);
                return new String[]{string2};
            }
        } else {
            iAStatus = new IAStatus((Object)this, IAResourceBundle.getValue("LogSettingsEntry.fileExists"), 98);
        }
        IAStatusLog.getInstance().addStatus(iAStatus);
        return new String[]{string2};
    }

    @Override
    public int getUninstallSortType() {
        return 0;
    }

    @Override
    public Flexeraavn createSortComparisonObject() {
        return null;
    }

    @Override
    public String getUninstallFilePath(String string) {
        return ZGUtil.decode(ZGUtil.removeDoubleSlashes(string), '@');
    }

    public boolean isFontFile(String string) {
        String string2;
        if (ZGUtil.WIN32 && !ZGUtil.getRunningPure() && (string2 = MagicFolder.get(20).getPath()) != null) {
            if (!"".equals(string2) && string.startsWith(string2)) {
                return true;
            }
        }
        return false;
    }

    private static String ca(String string) {
        if (ZGUtil.WIN32) {
            Pattern pattern = Pattern.compile(":");
            Matcher matcher = pattern.matcher(string);
            string = matcher.replaceAll("\\\\:");
        }
        return string;
    }

    private static String cb(String string) {
        if (ZGUtil.WIN32) {
            Pattern pattern = Pattern.compile(" ");
            Matcher matcher = pattern.matcher(string);
            string = matcher.replaceAll("\\\\ ");
        }
        return string;
    }

    static {
        ClassInfoManager.aa(InstallFile.class, DESCRIPTION, "com/zerog/ia/designer/images/actions/file.png");
    }
}

