/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.consoles;

import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.Uninstaller;
import com.zerog.ia.installer.installpanels.ProgressActionPanel;
import com.zerog.util.ZGSys;

public class UninstallRollbackConsoleUI {
    private int percentDone = 0;
    private int progressShown = 0;
    private float rollbackStarted = 0.0f;

    public void executeConsoleAction(Installer installer) {
        Uninstaller.getInstance().uninstall(installer);
    }

    public boolean setup() {
        this.addUninstallListener();
        return true;
    }

    private void addUninstallListener() {
        Uninstaller.getInstance().addUninstallListener(new Flexeraakw(){
            private int aa;

            @Override
            public void categoryStarted(Flexeraakv flexeraakv) {
                this.aa = 0;
                UninstallRollbackConsoleUI.this.showUninstallCategoryStart();
            }

            @Override
            public void categoryPercentDone(Flexeraakv flexeraakv) {
                UninstallRollbackConsoleUI.this.incrementPercentDone(flexeraakv.aa() - this.aa);
                if (flexeraakv.aa() > this.aa) {
                    this.aa = flexeraakv.aa();
                }
            }

            @Override
            public void displayTextChanged(Flexeraakv flexeraakv) {
            }

            @Override
            public void productUninstalled(Flexeraakv flexeraakv) {
                UninstallRollbackConsoleUI.this.showUninstallProgress();
            }

            @Override
            public void exceptionOccurred(Flexeraakv flexeraakv) {
            }

            @Override
            public void uninstallerExited(Flexeraakv flexeraakv) {
                ProgressActionPanel.getInstanceIfInstantiated().progressBar.setValue(0);
                UninstallRollbackConsoleUI.this.showUninstallProgressComplete();
            }
        });
    }

    private void incrementPercentDone(int n) {
        this.percentDone += n;
        while (this.percentDone > this.progressShown) {
            if (this.progressShown % 25 == 0) {
                ZGSys.aa.println("*");
            } else {
                ZGSys.aa.print("*");
            }
            ++this.progressShown;
        }
    }

    private void showUninstallProgressComplete() {
        ZGSys.aa.println(" -]");
    }

    private void showUninstallProgress() {
        ZGSys.aa.println("*");
    }

    private void showUninstallCategoryStart() {
        ZGSys.aa.println("");
        ZGSys.aa.println("...*");
    }

    private void showUninstallProgressStart() {
        ZGSys.aa.println("[- *");
    }
}

