/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.installpanels;

import com.zerog.ia.installer.installpanels.CheckBoxGroup;
import com.zerog.ia.installer.installpanels.ComboBoxGroup;
import com.zerog.ia.installer.installpanels.DirectoryChooserGroup;
import com.zerog.ia.installer.installpanels.FileChooserGroup;
import com.zerog.ia.installer.installpanels.GUIGroupContainer;
import com.zerog.ia.installer.installpanels.GetUserInputPanel;
import com.zerog.ia.installer.installpanels.LabelGroup;
import com.zerog.ia.installer.installpanels.ListGroup;
import com.zerog.ia.installer.installpanels.RadioButtonGroup;
import com.zerog.ia.installer.installpanels.TextFieldGroup;
import com.zerog.ia.installer.util.GUIGroupData;
import java.awt.Frame;

public class GUIGroupContainerFactory {
    public static GUIGroupContainer createGUIGroupContainer(Frame frame, GetUserInputPanel getUserInputPanel, GUIGroupData gUIGroupData) {
        switch (gUIGroupData.getGroupType()) {
            case 1: {
                return new LabelGroup(frame, getUserInputPanel, gUIGroupData);
            }
            case 0: {
                return new TextFieldGroup(frame, getUserInputPanel, gUIGroupData);
            }
            case 2: {
                switch (gUIGroupData.getComponentType()) {
                    case 3: {
                        return new CheckBoxGroup(frame, getUserInputPanel, gUIGroupData);
                    }
                    case 4: {
                        return new RadioButtonGroup(frame, getUserInputPanel, gUIGroupData);
                    }
                    case 5: {
                        return new ComboBoxGroup(frame, getUserInputPanel, gUIGroupData);
                    }
                    case 6: {
                        return new ListGroup(frame, getUserInputPanel, gUIGroupData);
                    }
                }
            }
            case 3: {
                if (gUIGroupData.getComponentType() == 7) {
                    return new DirectoryChooserGroup(frame, getUserInputPanel, gUIGroupData);
                }
                return new FileChooserGroup(frame, getUserInputPanel, gUIGroupData);
            }
        }
        throw new IllegalStateException("Unrecognized GetUserInputPanel Group Type: " + gUIGroupData.getGroupType());
    }
}

