/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.iseries.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPool;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.zerog.util.IAResourceBundle;
import java.beans.Beans;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class i5OSObjectCoord
extends Beans {
    private static final String copyright = "(C) Copyright IBM Corporation 2007.";
    private static boolean installRemote;
    private static boolean usingPools;
    private static AS400ConnectionPool pooli5;
    private static transient AS400 systemi5;
    private static int poolNum;
    private static transient int version;
    private static transient int release;
    private static transient int modification;
    private static transient boolean RAIRAvailable;
    private static transient int vrm;
    private static transient int connectResult;
    private static transient boolean listeningToBuild;
    private static transient Exception connectError;
    private static transient String systemName;
    private static transient String userID;
    private static transient String password;
    private static transient int parms;
    private static transient int iConnectAttempts;
    private static transient int iAttemptsAllowed;
    public static final int NOT_ATTEMPTED = 0;
    public static final int UNSUCCESSFUL = 1;
    public static final int CONNECTED = 2;
    public static final int DISCONNECTED = 3;

    public i5OSObjectCoord() throws Exception {
        i5OSObjectCoord.checkForSignOnProperties();
        i5OSObjectCoord.connectIfNecessary();
    }

    public AS400 i5OSCoordPoolGet(boolean bl) throws ConnectionPoolException {
        if (poolNum > 0) {
            AS400 aS400 = pooli5.getConnection(systemName, userID, password);
            System.out.println("makeConnections() 1 : " + pooli5.getActiveConnectionCount(systemName, userID));
            connectResult = 2;
            --poolNum;
            return aS400;
        }
        return null;
    }

    public void i5OSCoordPoolReturn(AS400 aS400) {
        ++poolNum;
        pooli5.returnConnectionToPool(aS400);
    }

    public i5OSObjectCoord(String[] stringArray, boolean bl, int n, int n2) throws Exception {
        parms = stringArray.length;
        if (parms > 0) {
            systemName = stringArray[0];
        }
        if (parms > 1) {
            userID = stringArray[1];
        }
        if (parms > 2) {
            password = stringArray[2];
        }
        i5OSObjectCoord.checkForSignOnProperties();
        i5OSObjectCoord.connectIfNecessary();
        if (bl) {
            this.setupPool(n, n2);
            System.out.println("makeConnections() pool: " + pooli5.getActiveConnectionCount(stringArray[0], stringArray[1]));
        }
    }

    public boolean isConnectionPoolReady() {
        return pooli5 != null;
    }

    public void validatePoolPrerequisites() throws Exception {
        if (systemName == null) {
            connectResult = 1;
            throw new Exception(IAResourceBundle.getValue("Indeterminate.PoolLoginError"));
        }
    }

    public void setupPool(int n, int n2) throws Exception {
        block3: {
            this.validatePoolPrerequisites();
            poolNum = n2;
            pooli5 = new AS400ConnectionPool();
            pooli5.setMaxConnections(n);
            try {
                pooli5.fill(systemName, userID, password, 2, n2);
                usingPools = true;
            }
            catch (ConnectionPoolException connectionPoolException) {
                if (iConnectAttempts <= iAttemptsAllowed) break block3;
                connectResult = 1;
                String string = connectionPoolException.getLocalizedMessage();
                if (!installRemote) {
                    string = IAResourceBundle.getValue("addNtv") + " " + string;
                }
                throw new Exception(string);
            }
        }
    }

    public i5OSObjectCoord(String[] stringArray) throws Exception {
        parms = stringArray.length;
        if (parms > 0) {
            systemName = stringArray[0];
        }
        if (parms > 1) {
            userID = stringArray[1];
        }
        if (parms > 2) {
            password = stringArray[2];
        }
        i5OSObjectCoord.connectIfNecessary();
    }

    public i5OSObjectCoord(boolean bl) throws Exception {
        if (bl && systemName == null) {
            this.checkForBuildProperties();
        }
        try {
            i5OSObjectCoord.connectIfNecessary();
        }
        catch (Exception exception) {
            i5OSObjectCoord.disconnect();
            throw exception;
        }
    }

    private void checkForBuildProperties() {
        String string = "ia.build.i5os";
        String string2 = System.getProperty(string);
        if (string2 != null) {
            string2 = string2.toUpperCase();
            string2 = string2.replace('\\', '/');
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            if (stringTokenizer.hasMoreElements()) {
                systemName = (String)stringTokenizer.nextElement();
            }
            if (stringTokenizer.hasMoreElements()) {
                userID = (String)stringTokenizer.nextElement();
            }
            if (stringTokenizer.hasMoreElements()) {
                password = (String)stringTokenizer.nextElement();
            }
        }
    }

    private static String getSignonPropertyValue() {
        return System.getProperty("ia.signon.i5os");
    }

    private static void checkForSignOnProperties() {
        String string = i5OSObjectCoord.getSignonPropertyValue();
        if (string != null) {
            string = string.toUpperCase();
            string = string.replace('\\', '/');
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (stringTokenizer.hasMoreElements()) {
                systemName = (String)stringTokenizer.nextElement();
            }
            if (stringTokenizer.hasMoreElements()) {
                userID = (String)stringTokenizer.nextElement();
            }
            if (stringTokenizer.hasMoreElements()) {
                password = (String)stringTokenizer.nextElement();
            }
        }
    }

    private static void connectIfNecessary() throws Exception {
        if (connectResult == 1) {
            throw connectError;
        }
        if (connectResult == 0 || connectResult == 3) {
            i5OSObjectCoord.makeConnection();
        }
    }

    private static boolean isRemote() {
        String string = System.getProperty("os.name");
        installRemote = !string.equals("OS/400");
        return installRemote;
    }

    private static AS400ConnectionPool connectPool(int n) {
        AS400ConnectionPool aS400ConnectionPool = new AS400ConnectionPool();
        aS400ConnectionPool.setMaxConnections(n);
        return aS400ConnectionPool;
    }

    private static void makeConnection() throws Exception {
        try {
            if (!i5OSObjectCoord.isRemote()) {
                systemName = "localhost";
                userID = "*CURRENT";
                password = "*CURRENT";
                systemi5 = new AS400("localhost", "*CURRENT", "*CURRENT");
                systemi5.setGuiAvailable(false);
            } else {
                systemi5 = systemName == null ? new AS400() : (userID == null ? new AS400(systemName) : (password == null ? new AS400(systemName, userID) : new AS400(systemName, userID, password)));
                systemi5.setGuiAvailable(i5OSObjectCoord.getSignonPropertyValue() == null);
            }
            systemi5.setShowCheckboxes(false);
            systemi5.setUseDefaultUser(false);
            systemi5.setUsePasswordCache(false);
            installRemote = !systemi5.isLocal();
            version = systemi5.getVersion();
            release = systemi5.getRelease();
            modification = systemi5.getModification();
            vrm = systemi5.getVRM();
            RAIRAvailable = version >= 5;
            String string = "/tmp/InstallAnywhere";
            IFSFile iFSFile = new IFSFile(systemi5, string);
            if (!iFSFile.exists() || !iFSFile.isDirectory()) {
                iFSFile.mkdirs();
            }
            connectResult = 2;
        }
        catch (UnknownHostException unknownHostException) {
            connectResult = 1;
            throw new Exception(IAResourceBundle.getValue("hostNotFound"));
        }
        catch (AS400SecurityException aS400SecurityException) {
            if (iConnectAttempts > iAttemptsAllowed) {
                connectResult = 1;
                String string = aS400SecurityException.getLocalizedMessage();
                if (!installRemote) {
                    string = IAResourceBundle.getValue("addNtv") + " " + string;
                }
                throw new Exception(string);
            }
        }
        catch (Exception exception) {
            connectResult = 1;
            System.err.println("Exception thrown " + exception.getLocalizedMessage());
            exception.printStackTrace();
            throw new Exception(exception.getLocalizedMessage());
        }
        i5OSObjectCoord.setAllTracing(false);
    }

    private static void setAllTracing(boolean bl) {
        Trace.setTraceDiagnosticOn((boolean)bl);
        Trace.setTraceInformationOn((boolean)bl);
        Trace.setTraceWarningOn((boolean)bl);
        Trace.setTraceErrorOn((boolean)bl);
        Trace.setTraceConversionOn((boolean)bl);
        Trace.setTraceDatastreamOn((boolean)bl);
        Trace.setTraceProxyOn((boolean)bl);
        Trace.setTraceOn((boolean)bl);
    }

    public static AS400 getAS400Object() {
        if (connectResult == 3) {
            while (iConnectAttempts++ < iAttemptsAllowed) {
                try {
                    i5OSObjectCoord.makeConnection();
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                }
            }
        }
        return systemi5;
    }

    public static boolean isInstallRemote() {
        return installRemote;
    }

    public static int getVersion() {
        return version;
    }

    public static int getRelease() {
        return release;
    }

    public static int getModification() {
        return modification;
    }

    public static int getVrm() {
        return vrm;
    }

    public static boolean isRAIRAvailable() {
        return RAIRAvailable;
    }

    public static void disconnect() {
        connectResult = 3;
        if (systemi5 != null) {
            systemi5.disconnectAllServices();
        }
    }

    public static void main(String[] stringArray) {
        try {
            i5OSObjectCoord i5OSObjectCoord2 = new i5OSObjectCoord();
        }
        catch (Exception exception) {
            System.out.println("Hit exception " + exception.getLocalizedMessage());
        }
        System.exit(0);
    }

    public static int getConnectResult() {
        return connectResult;
    }

    public static String getUserId() {
        if (userID != null) {
            return userID;
        }
        if (connectResult == 2) {
            return i5OSObjectCoord.getAS400Object().getUserId();
        }
        i5OSObjectCoord.checkForSignOnProperties();
        return userID;
    }

    static {
        usingPools = false;
        poolNum = 0;
        systemName = null;
        userID = null;
        password = null;
        parms = 0;
        iConnectAttempts = 0;
        iAttemptsAllowed = 0;
    }
}

