/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.lax;

import com.zerog.awt.ZGStandardDialog;
import com.zerog.common.java.util.PropertiesUtil;
import com.zerog.lax.LAXQuotedStreamTokenizer;
import com.zerog.util.DebugOutputConfig;
import java.awt.GraphicsEnvironment;
import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class LAX {
    public static final String LAX_VERSION = "21.0";
    public static final String PROPERTYPREFIX = "lax.";
    public static final String VERSION = "lax.version";
    public static final String APP_NAME = "lax.application.name";
    public static final String MAIN_CLASS = "lax.main.class";
    public static final String MAIN_METHOD = "lax.main.method";
    public static final String CMD_LINE_ARGS = "lax.command.line.args";
    public static final String USER_DIR = "lax.user.dir";
    public static final String INSTALL_DIRECTORY = "lax.root.install.dir";
    public static final String NATIVE_LAUNCHER_INSTALL_DIRECTORY = "lax.dir";
    public static final String LAX_MAIN_CLASS = "lax.nl.java.launcher.main.class";
    public static final String LAX_MAIN_METHOD = "lax.nl.java.launcher.main.method";
    public static final String CLASS_PATH = "lax.class.path";
    public static final String CURRENT_VM = "lax.nl.current.vm";
    public static final String STDIN = "lax.stdin.redirect";
    public static final String STDOUT = "lax.stdout.redirect";
    public static final String STDERR = "lax.stderr.redirect";
    public static final String ENVIRONMENT_VARIABLE_PREFIX = "lax.nl.env.";
    private String[] nativeArgs;
    private Throwable theException;
    private static final String generalAppErrorString = "Unable to Launch Java Application";
    private static final String generalAppFailureString = "This Application has Unexpectedly Quit";
    private static final String alertDialogTitle = "Fatal Application Error";
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final boolean isMacOSX;
    private static final String UIMODE_TMP_FILE = "/tmp/ia_tmp/ia_osx_locale";
    private static final String UIMODE_KEY = "ia.installer.macosx.commandline.args";

    public static PrintStream getOriginalStdOut() {
        return DebugOutputConfig.originalSTDOUT;
    }

    public static PrintStream getOriginalStdErr() {
        return DebugOutputConfig.originalSTDERR;
    }

    public static InputStream getOriginalStdIn() {
        return DebugOutputConfig.originalSTDIN;
    }

    public void addProperties(String[] stringArray) throws IOException {
        block5: {
            File file;
            block4: {
                if (stringArray[0].toUpperCase().endsWith(".LAX")) break block4;
                if (!stringArray[0].toUpperCase().endsWith(".PROPERTIES")) break block5;
            }
            if (!(file = new File(stringArray[0])).exists()) {
                file = new File(file.getName());
            }
            Properties properties = file.exists() ? PropertiesUtil.loadProperties(file) : new Properties();
            PropertiesUtil.mergeIntoProps(System.getProperties(), properties);
        }
    }

    public LAX() throws Throwable {
        this(new String[0]);
    }

    public LAX(String[] stringArray) throws Throwable {
        Object object;
        block20: {
            block19: {
                this.prepareCopyrightAndVersionStringForOSXMenu();
                if (!Beans.isDesignTime() && isMacOSX) {
                    stringArray = this.prepareCommandLineArgumentsStringForOSX(stringArray);
                }
                stringArray = this.convertArguments(stringArray);
                if ((stringArray = LAX.dequoteArguments(stringArray)) != null) {
                    this.nativeArgs = new String[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.nativeArgs[i] = LAX.convertFromEscapedUnicode(stringArray[i]);
                    }
                } else {
                    this.nativeArgs = null;
                }
                if (this.nativeArgs != null && this.nativeArgs.length > 0) {
                    this.addProperties(this.nativeArgs);
                    if (!this.verifyProperty(MAIN_CLASS, this.nativeArgs[0])) {
                        return;
                    }
                    if (!this.verifyProperty(MAIN_METHOD, this.nativeArgs[0])) {
                        return;
                    }
                    if (this.nativeArgs.length > 1) {
                        File file;
                        if (!this.nativeArgs[1].equals("lax_no_temp_file") && (file = new File(this.nativeArgs[1])) != null && file.exists()) {
                            object = new File(this.nativeArgs[1]);
                            Properties properties = PropertiesUtil.loadProperties((File)object);
                            file.delete();
                            PropertiesUtil.mergeIntoProps(System.getProperties(), properties);
                            ((File)object).delete();
                        }
                    }
                } else {
                    DebugOutputConfig.originalSTDOUT.println("Path not supplied to properties file");
                }
                DebugOutputConfig.configStdInStdOutStdErrOnSupportedPlatforms();
                this.configureDebugging();
                if (System.getProperty("LISTPROPS") != null) {
                    PropertiesUtil.listProperties(System.err, System.getProperties());
                }
                if (System.getProperty("lax.java.compiler") == "off") break block19;
                if (System.getProperty("lax.nl.java.compiler") != "off") break block20;
            }
            Compiler.disable();
        }
        Properties properties = System.getProperties();
        properties.put(VERSION, LAX_VERSION);
        System.setProperties(properties);
        object = System.getProperty("lax.nl.env.LAX_DEBUG");
        if (object == null) {
            object = System.getProperty("lax.control-key");
        }
        if (object != null) {
            if (!((String)object).equals("false")) {
                if (!((String)object).trim().equals("")) {
                    System.err.println("LAX Version = 21.0");
                }
            }
        }
    }

    private void prepareCopyrightAndVersionStringForOSXMenu() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        String string = System.getProperty("os.name").toLowerCase();
        if (!string.equals("mac os x")) {
            return;
        }
        Class clazz = this.getClassReferenceIfClassPresentInClassPath("com.zerog.ui.gui.swing.OSXUtility");
        if (clazz == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("version", LAX_VERSION);
        hashMap.put("shortVersion", "InstallAnywhere 2021 Installer");
        hashMap.put("copyright", "Copyright \u00a9 2021 Flexera Software LLC.");
        try {
            Class[] classArray = new Class[1];
            classArray[0] = Map.class;
            Method method = clazz.getMethod("prepareGetInfoDialog", classArray);
            Object object = method.invoke(null, hashMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Class getClassReferenceIfClassPresentInClassPath(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private String[] convertArguments(String[] stringArray) {
        int n;
        String string = "\"";
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("\"") && n < stringArray.length) {
                if (stringArray[n + 1].equals("\"")) {
                    vector.addElement(" ");
                    ++n;
                    continue;
                }
            }
            vector.addElement(stringArray[n]);
        }
        stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        vector.removeAllElements();
        for (n = 0; n < stringArray.length; ++n) {
            if (bl) {
                string2 = string2 + " " + stringArray[n];
            }
            if (stringArray[n].startsWith("\"")) {
                if (!stringArray[n].endsWith("\"")) {
                    string2 = stringArray[n].substring(1, stringArray[n].length());
                    bl = true;
                    continue;
                }
            }
            if (bl) {
                if (stringArray[n].endsWith("\"")) {
                    bl = false;
                    vector.addElement(string2.substring(0, string2.length() - 1));
                    continue;
                }
            }
            if (bl) continue;
            vector.addElement(stringArray[n]);
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    public static String[] dequoteArguments(String[] stringArray) {
        String string = "\"";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() <= 1) continue;
            int n = string2.startsWith("\"") ? 1 : 0;
            int n2 = string2.endsWith("\"") ? string2.length() - 2 : string2.length() - 1;
            stringArray[i] = string2 = string2.substring(n, n2 + 1);
        }
        return stringArray;
    }

    public void launch() {
        Properties properties = System.getProperties();
        Class<?> clazz = null;
        String string = properties.getProperty(MAIN_CLASS);
        Method method = null;
        String string2 = properties.getProperty(MAIN_METHOD);
        String string3 = properties.getProperty(CMD_LINE_ARGS);
        String string4 = "";
        try {
            Object[] objectArray;
            try {
                clazz = Class.forName(string);
            }
            catch (Throwable throwable) {
                this.theException = throwable;
                string4 = "Unable to locate the application's 'main' class. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                DebugOutputConfig.originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(3001);
            }
            try {
                objectArray = new Class[]{new String[0].getClass()};
                method = clazz.getMethod(string2, (Class<?>[])objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.theException = noSuchMethodException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                DebugOutputConfig.originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(3002);
            }
            try {
                objectArray = new Object[]{this.parseArgs(string3)};
                method.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.theException = illegalAccessException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                DebugOutputConfig.originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(3003);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.theException = illegalArgumentException;
                string4 = "The method to invoke is not accessible. The class '" + string + "' must be public and have a 'public static void " + string2 + "(String[])' method. (LAX)";
                DebugOutputConfig.originalSTDERR.println(string4);
                this.showExceptionDialog(generalAppErrorString, string4, true);
                System.exit(3003);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.theException = invocationTargetException.getTargetException();
                string4 = "Invocation of this Java Application has caused an InvocationTargetException. This application will now exit. (LAX)";
                if (this.theException instanceof ExceptionInInitializerError) {
                    System.err.println("theException = ExceptionInInitializerError");
                    string4 = "Invocation of this Java Application has caused an ExceptionInInitializerError. This application will now exit. (LAX)";
                    this.theException = ((ExceptionInInitializerError)this.theException).getException();
                }
                DebugOutputConfig.originalSTDERR.println(string4);
                DebugOutputConfig.originalSTDERR.println("\nStack Trace:");
                this.theException.printStackTrace(DebugOutputConfig.originalSTDERR);
                this.showExceptionDialog(generalAppFailureString, string4, true);
                System.exit(3004);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                this.theException = exceptionInInitializerError.getException();
                while (this.theException instanceof ExceptionInInitializerError) {
                    this.theException = exceptionInInitializerError.getException();
                }
                string4 = "Invocation of this Java Application has caused an ExceptionInInitializerError. This application will now exit. (LAX)";
                DebugOutputConfig.originalSTDERR.println(string4);
                DebugOutputConfig.originalSTDERR.println("\nStack Trace:");
                this.theException.printStackTrace(DebugOutputConfig.originalSTDERR);
                this.showExceptionDialog(generalAppFailureString, string4, true);
                System.exit(3004);
            }
            catch (NullPointerException nullPointerException) {
                this.theException = nullPointerException;
                string4 = "This Java Application has encountered a NullPointerException and will now exit. (LAX)";
                DebugOutputConfig.originalSTDERR.println(string4);
                DebugOutputConfig.originalSTDERR.println("\nStack Trace:");
                nullPointerException.printStackTrace(DebugOutputConfig.originalSTDERR);
                this.showExceptionDialog(generalAppFailureString, string4, true);
                System.exit(3004);
            }
        }
        catch (ThreadDeath threadDeath) {
            System.exit(3000);
        }
        catch (Exception exception) {
            this.theException = exception;
            string4 = "This Java Application has encountered an unexpected exception and will now exit. (LAX)";
            DebugOutputConfig.originalSTDERR.println(string4);
            DebugOutputConfig.originalSTDERR.println("\nStack Trace:");
            exception.printStackTrace(DebugOutputConfig.originalSTDERR);
            this.showExceptionDialog(generalAppFailureString, string4, true);
            System.exit(3000);
        }
        catch (Throwable throwable) {
            this.theException = throwable;
            string4 = "This Java Application has encountered an unexpected error and will now exit. (LAX)";
            DebugOutputConfig.originalSTDERR.println(string4);
            DebugOutputConfig.originalSTDERR.println("\nStack Trace:");
            throwable.printStackTrace(DebugOutputConfig.originalSTDERR);
            this.showExceptionDialog(generalAppFailureString, string4, true);
            System.exit(3000);
        }
    }

    private boolean verifyProperty(String string, String string2) {
        if (System.getProperty(string) == null) {
            String string3 = "The properties files is missing an essential property: " + string + ". Please make sure it exists in the properties file: " + string2;
            DebugOutputConfig.originalSTDERR.println(string3);
            this.showExceptionDialog(generalAppErrorString, string3, false);
            return false;
        }
        return true;
    }

    private String[] parseArgs(String string) {
        if (string == null || string.length() <= 0) {
            return new String[0];
        }
        LAXQuotedStreamTokenizer lAXQuotedStreamTokenizer = new LAXQuotedStreamTokenizer(new StringReader(string));
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            while ((string2 = lAXQuotedStreamTokenizer.getNextToken()) != null) {
                if (lAXQuotedStreamTokenizer.getType() == -10) {
                    vector.addElement(string2);
                    continue;
                }
                if (lAXQuotedStreamTokenizer.getType() == -11) {
                    vector.addElement(string2);
                    continue;
                }
                if (lAXQuotedStreamTokenizer.getType() != -12) continue;
                vector.addElement(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(DebugOutputConfig.originalSTDERR);
        }
        if (vector.size() <= 0) {
            return new String[0];
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            Object e = vector.elementAt(i);
            if (!((String)e).equals("$CMD_LINE_ARGUMENTS$")) continue;
            if (isMacOSX && this.isMacOSXAppBundle()) {
                for (n = this.nativeArgs.length - 1; n > 0; --n) {
                    vector.insertElementAt(this.nativeArgs[n], i);
                }
            } else {
                for (n = this.nativeArgs.length - 1; n > 1; --n) {
                    vector.insertElementAt(this.nativeArgs[n], i);
                }
            }
            vector.removeElement(e);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private void configureDebugging() {
        try {
            boolean bl = Boolean.getBoolean(System.getProperty("lax.debug.all", "false"));
            if (bl) {
                Flexeraavd.aa = Integer.parseInt(System.getProperty("lax.debug.level", "0"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            Flexeraavd.aa = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void showExceptionDialog(String var1_1, String var2_2, boolean var3_3) {
        try {
            if (LAX.osName.indexOf("mac") == -1) ** GOTO lbl-1000
            if (LAX.osName.indexOf("x") != -1) {
                var4_4 = new Flexeraaun("Fatal Application Error", var1_1, var2_2);
            } else lbl-1000:
            // 2 sources

            {
                var4_4 = new ZGStandardDialog("Fatal Application Error", var1_1, var2_2);
            }
            var4_4.setDetailsButtonVisible(var3_3);
            var4_4.setCancelButtonVisible(false);
            var4_4.setVisible(true);
            if (var4_4.getLastButtonPressed() == 3) {
                var5_6 = new Flexeraapb(this.theException);
                var5_6.setVisible(true);
            }
        }
        catch (Throwable var4_5) {
            DebugOutputConfig.originalSTDERR.println(var1_1 + ": " + var2_2);
        }
    }

    public static void serviceMainHook(String[] stringArray) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            final LAX lAX = new LAX(stringArray);
            if (osName.indexOf("win") != -1) {
                if (System.getProperty("lax.nl.win32.service", "false").trim().equalsIgnoreCase("true")) {
                    if (System.getProperty("java.version", "").startsWith("1.3")) {
                        if (!System.getProperty("java.version", "").startsWith("1.3.1")) {
                            Thread thread = new Thread("LaunchAnywhere Main Thread"){

                                @Override
                                public void run() {
                                    lAX.launch();
                                }
                            };
                            thread.setPriority(10);
                            thread.start();
                            return;
                        }
                    }
                }
            }
            lAX.launch();
            return;
        }
        catch (Throwable throwable) {
            String string = "An internal LaunchAnywhere application error has occured and this application cannot proceed. (LAX)";
            System.err.println(string);
            System.err.println("\nStack Trace:");
            throwable.printStackTrace(System.err);
            System.exit(3000);
        }
    }

    public static String convertFromEscapedUnicode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = -1;
        int n3 = 0;
        char c = '\u0000';
        int n4 = 0;
        while (n4 < n) {
            c = string.charAt(n4);
            if (c == '\\') {
                if (++n4 >= n) continue;
                c = string.charAt(n4);
                if (c == 'u') {
                    ++n4;
                    n2 = 0;
                    for (int i = 0; i < 4 && n4 < n; ++n4, ++i) {
                        c = string.charAt(n4);
                        n3 = LAX.getOffset(c);
                        if (n3 == -1) {
                            stringBuffer.append("\\u");
                            while (i > 0) {
                                stringBuffer.append(string.charAt(n4 - i));
                                --i;
                            }
                            n2 = -1;
                            break;
                        }
                        n2 = (n2 << 4) + c - n3;
                    }
                    if (n2 == -1) continue;
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append(c);
                ++n4;
                continue;
            }
            stringBuffer.append(c);
            ++n4;
        }
        return stringBuffer.toString();
    }

    private static int getOffset(int n) {
        if (n >= 48 && n <= 57) {
            return 48;
        }
        if (n >= 65 && n <= 70) {
            return 55;
        }
        if (n >= 97 && n <= 102) {
            return 87;
        }
        return -1;
    }

    private String[] prepareCommandLineArgumentsStringForOSX(String[] stringArray) {
        String string = "";
        Properties properties = new Properties();
        File file = new File(UIMODE_TMP_FILE);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                string = properties.getProperty(UIMODE_KEY);
                if (string != null && !string.isEmpty()) {
                    String[] stringArray2 = string.split("\\s+");
                    int n = stringArray.length + stringArray2.length;
                    String[] stringArray3 = new String[n];
                    System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                    System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
                    return stringArray3;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Unable to find temporary locale file");
            }
            catch (IOException iOException) {
                System.err.println("Unable to read temporary locale file");
            }
        }
        return stringArray;
    }

    private boolean isMacOSXAppBundle() {
        File file = null;
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.lastIndexOf(".app");
            if (n == -1) continue;
            string = string2.substring(0, n + 4);
            break;
        }
        file = new File(string, "Contents/Resources/Java/linking.zip");
        return file.exists();
    }

    /*
     * Unable to fully structure code
     */
    static {
        if (LAX.osName.indexOf("mac") == -1) ** GOTO lbl-1000
        if (LAX.osName.indexOf("x") != -1) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        LAX.isMacOSX = v0;
    }
}

