/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.resources;

import com.zerog.util.ZGUtil;
import java.io.File;
import java.util.Properties;

public class BuildInfo {
    private static final String PREPEND_PROPERTY_NAME = ".BUILD_INFO.";
    private static final String IS_WEB_INSTALLER = ".BUILD_INFO.isWebInstaller";
    private static final String IS_OPTIMIZED = ".BUILD_INFO.isOptimized";
    private static final String PLATFORM = ".BUILD_INFO.Platform";
    private static final String EMPTY_STRING = "";
    private boolean isWebInstaller;
    private boolean isOptimized;
    private String platform;
    private Flexeraavu dirWhereJVMSpecsHaveBeenCopied = null;
    private int platformIdForJVMSpecCreation = -1;

    public Flexeraavu getDirWhereJVMSpecsHaveBeenCopied() {
        return this.dirWhereJVMSpecsHaveBeenCopied;
    }

    public int getPlatformIdForJVMSpecCreation() {
        return this.platformIdForJVMSpecCreation;
    }

    public BuildInfo(boolean bl, boolean bl2) {
        this(bl, bl2, EMPTY_STRING);
    }

    public BuildInfo(boolean bl, boolean bl2, int n, Flexeraavu flexeraavu) {
        this(bl, bl2, EMPTY_STRING);
        this.initInfoForJVMSpec(n, flexeraavu);
    }

    private void initInfoForJVMSpec(int n, Flexeraavu flexeraavu) {
        if (flexeraavu == null) {
            return;
        }
        if (flexeraavu.exists() && flexeraavu.isDirectory()) {
            this.dirWhereJVMSpecsHaveBeenCopied = flexeraavu;
        }
        if (n == 4 || n == 9 || n == 7 || n == 11 || n == 10 || n == 15) {
            this.platformIdForJVMSpecCreation = n;
        }
    }

    public BuildInfo(boolean bl, boolean bl2, String string) {
        this.isWebInstaller = bl;
        this.isOptimized = bl2;
        this.platform = string;
    }

    public BuildInfo(boolean bl, boolean bl2, String string, int n, Flexeraavu flexeraavu) {
        this.isWebInstaller = bl;
        this.isOptimized = bl2;
        this.platform = string;
        this.initInfoForJVMSpec(n, flexeraavu);
    }

    public BuildInfo(Properties properties, String string) {
        this.isWebInstaller = new Boolean(properties.getProperty(string + IS_WEB_INSTALLER));
        this.isOptimized = new Boolean(properties.getProperty(string + IS_OPTIMIZED));
        this.platform = properties.getProperty(string + PLATFORM);
    }

    public boolean getIsWebInstaller() {
        return this.isWebInstaller;
    }

    public boolean getIsOptimized() {
        return this.isOptimized;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Properties addProperties(Properties properties, String string) {
        properties.setProperty(string + IS_WEB_INSTALLER, new Boolean(this.getIsWebInstaller()).toString());
        properties.setProperty(string + IS_OPTIMIZED, new Boolean(this.getIsOptimized()).toString());
        properties.setProperty(string + PLATFORM, this.getPlatform());
        return properties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("   BuildInfo:\n");
        stringBuffer.append("      isWebInstaller: " + this.isWebInstaller + "\n");
        stringBuffer.append("      isOptimized: " + this.isOptimized + "\n");
        stringBuffer.append("      Platform: " + this.platform + "\n");
        stringBuffer.append("   :InstalledMedia");
        return stringBuffer.toString();
    }

    public String locateResourceFiles(String string) {
        File file = null;
        if (this.isWebInstaller) {
            file = !(Flexeraaq7.ac() != 1 && Flexeraaq7.ac() != 3 || Flexeraaq7.aa()) ? new File(string + File.separator + "Resource1.zip") : Flexeraaq5.ab(string, 1L, 1L);
            if (file.exists()) {
                return string;
            }
        } else {
            File file2 = null;
            String string2 = null;
            if (!(Flexeraaq7.ac() != 1 && Flexeraaq7.ac() != 3 || Flexeraaq7.aa())) {
                file2 = new File(string);
                string2 = file2.getPath();
            } else if (ZGUtil.getRunningPure() && Flexeraaq7.aa() && (Flexeraaq7.ac() == 1 || Flexeraaq7.ac() == 3)) {
                file2 = new File(string);
                string2 = file2.getPath();
            } else {
                file2 = Flexeraaq5.ah(new File(string));
                while (!file2.getName().equalsIgnoreCase("InstData")) {
                    Flexeraac4.ac("could not find 'InstData' in base path", file2.getParent());
                    file2 = new File(file2.getParent());
                }
                string2 = new File(new File(file2.getParent()).getParent()).getPath();
            }
            Flexeraac4.ab("CDRom Installer base path not found!", new File(string2).exists());
            return string2;
        }
        Flexeraac4.ad("BuildInfo: unable to locate the Resource1.zip file for this installer");
        Flexeraac4.ad("Unable to locate resource.zip files successfully");
        return null;
    }
}

