/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.nativelib.win32;

public class Win32Exception
extends Exception {
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_INVALID_FUNCTION = 1;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_PATH_NOT_FOUND = 3;
    public static final int ERROR_TOO_MANY_OPEN_FILES = 4;
    public static final int ERROR_ACCESS_IS_DENIED = 5;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_ARENA_TRASHED = 7;
    public static final int ERROR_NOT_ENOUGH_MEMORY = 8;
    public static final int ERROR_INVALID_BLOCK = 9;
    public static final int ERROR_BAD_ENVIRONMENT = 10;
    public static final int ERROR_BAD_FORMAT = 11;
    public static final int ERROR_INVALID_ACCESS = 12;
    public static final int ERROR_INVALID_DATA = 13;
    public static final int ERROR_OUTOFMEMORY = 14;
    public static final int ERROR_INVALID_DRIVE = 15;
    public static final int ERROR_CURRENT_DIRECTORY = 16;
    public static final int ERROR_NOT_SAME_DEVICE = 17;
    public static final int ERROR_NO_MORE_FILES = 18;
    public static final int ERROR_WRITE_PROTECT = 19;
    public static final int ERROR_BAD_UNIT = 20;
    public static final int ERROR_NOT_READY = 21;
    public static final int ERROR_BAD_COMMAND = 22;
    public static final int ERROR_CRC = 23;
    public static final int ERROR_NOT_DOS_DISK = 26;
    public static final int ERROR_SHARING_VIOLATION = 32;
    public static final int ERROR_HANDLE_DISK_FULL = 39;
    public static final int ERROR_REM_NOT_LIST = 51;
    public static final int ERROR_NETWORK_ACCESS_DENIED = 65;
    public static final int ERROR_FILE_EXISTS = 80;
    public static final int ERROR_INVALID_PASSWORD = 86;
    public static final int ERROR_DRIVE_LOCKED = 108;
    public static final int ERROR_BUFFER_OVERFLOW = 111;
    public static final int ERROR_DISK_FULL = 112;
    public static final int ERROR_INVALID_NAME = 123;
    public static final int ERROR_BAD_PATHNAME = 161;
    public static final int ERROR_ALREADY_EXISTS = 183;
    public static final int ERROR_BAD_EXE_FORMAT = 193;
    public static final int ERROR_FILENAME_EXCED_RANGE = 206;
    public static final int ERROR_MORE_DATA = 234;
    public static final int ERROR_DIRECTORY = 267;
    public static final int ERROR_OLD_WIN_VERSION = 1150;
    public static final int ERROR_RMODE_APP = 1153;
    public static final int ERROR_INVALID_DLL = 1154;
    public static final int ERROR_DLL_NOT_FOUND = 1157;
    private int errorCode;

    public Win32Exception(String string) {
        super(Win32Exception.generateDetail(Integer.decode(string)));
        this.errorCode = Integer.decode(string);
    }

    public Win32Exception(int n) {
        super(Win32Exception.generateDetail(n));
        this.errorCode = n;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static String getErrorName(int n) {
        switch (n) {
            case 0: {
                return "ERROR_SUCCESS";
            }
            case 1: {
                return "ERROR_INVALID_FUNCTION";
            }
            case 2: {
                return "ERROR_FILE_NOT_FOUND";
            }
            case 3: {
                return "ERROR_PATH_NOT_FOUND";
            }
            case 4: {
                return "ERROR_TOO_MANY_OPEN_FILES";
            }
            case 5: {
                return "ERROR_ACCESS_IS_DENIED";
            }
            case 6: {
                return "ERROR_INVALID_HANDLE";
            }
            case 7: {
                return "ERROR_ARENA_TRASHED";
            }
            case 8: {
                return "ERROR_NOT_ENOUGH_MEMORY";
            }
            case 9: {
                return "ERROR_INVALID_BLOCK";
            }
            case 10: {
                return "ERROR_BAD_ENVIRONMENT";
            }
            case 11: {
                return "ERROR_BAD_FORMAT";
            }
            case 12: {
                return "ERROR_INVALID_ACCESS";
            }
            case 13: {
                return "ERROR_INVALID_DATA";
            }
            case 14: {
                return "ERROR_OUTOFMEMORY";
            }
            case 15: {
                return "ERROR_INVALID_DRIVE";
            }
            case 16: {
                return "ERROR_CURRENT_DIRECTORY";
            }
            case 17: {
                return "ERROR_NOT_SAME_DEVICE";
            }
            case 18: {
                return "ERROR_NO_MORE_FILES";
            }
            case 19: {
                return "ERROR_WRITE_PROTECT";
            }
            case 20: {
                return "ERROR_BAD_UNIT";
            }
            case 21: {
                return "ERROR_NOT_READY";
            }
            case 22: {
                return "ERROR_BAD_COMMAND";
            }
            case 23: {
                return "ERROR_CRC";
            }
            case 26: {
                return "ERROR_NOT_DOS_DISK";
            }
            case 32: {
                return "ERROR_SHARING_VIOLATION";
            }
            case 39: {
                return "ERROR_HANDLE_DISK_FULL";
            }
            case 51: {
                return "ERROR_REM_NOT_LIST";
            }
            case 65: {
                return "ERROR_NETWORK_ACCESS_DENIED";
            }
            case 80: {
                return "ERROR_FILE_EXISTS";
            }
            case 86: {
                return "ERROR_INVALID_PASSWORD";
            }
            case 108: {
                return "ERROR_DRIVE_LOCKED";
            }
            case 111: {
                return "ERROR_BUFFER_OVERFLOW";
            }
            case 112: {
                return "ERROR_DISK_FULL";
            }
            case 123: {
                return "ERROR_INVALID_NAME";
            }
            case 161: {
                return "ERROR_BAD_PATHNAME";
            }
            case 183: {
                return "ERROR_ALREADY_EXISTS";
            }
            case 193: {
                return "ERROR_BAD_EXE_FORMAT";
            }
            case 206: {
                return "ERROR_FILENAME_EXCED_RANGE";
            }
            case 267: {
                return "ERROR_DIRECTORY";
            }
            case 1150: {
                return "ERROR_OLD_WIN_VERSION";
            }
            case 1153: {
                return "ERROR_RMODE_APP";
            }
            case 1154: {
                return "ERROR_INVALID_DLL";
            }
            case 1157: {
                return "ERROR_DLL_NOT_FOUND";
            }
        }
        return null;
    }

    private static String generateDetail(int n) {
        String string = "Win32 error:  " + n;
        String string2 = Win32Exception.getErrorName(n);
        if (string2 != null) {
            string = string + " " + Win32Exception.getErrorName(n);
        }
        return string;
    }
}

