/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.vmpackcreation;

import com.zerog.util.vmpackcreation.JVMPack;
import com.zerog.util.vmpackcreation.JVMPackCreatorImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class UnixJVMPackCreatorImpl
extends JVMPackCreatorImpl {
    private JVMPack jvmPack;
    private long totalSizeOfFilesToTar = 0L;
    private long totalSizeProcessed = 0L;

    public UnixJVMPackCreatorImpl(JVMPack jVMPack) {
        this.jvmPack = jVMPack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createJVMPack() {
        File file = null;
        File file2 = null;
        File file3 = null;
        if (this.jvmPack != null) {
            try {
                Properties properties = this.createVMProperties(this.jvmPack);
                boolean bl = this.writeJVMPropertiesToFile(properties, this.getNameOfVMProperties(), this.jvmPack.getLocationToSaveVMPack());
                if (bl) {
                    File file4;
                    this.adjustSourcePathForVMPackIfJDKWasSupplied(this.jvmPack);
                    this.notifyObservers(new Integer("0"));
                    file = this.createVMDotTar(this.jvmPack, this.jvmPack.getSourceLocationOfVMPack());
                    file2 = this.createVMDotTarDotZ(this.jvmPack, file);
                    file3 = new File(this.jvmPack.getLocationToSaveVMPack(), this.getNameOfVMProperties());
                    this.notifyObservers(new Integer("70"));
                    String string = this.jvmPack.getLocationToSaveVMPack() + File.separator + this.jvmPack.getNameOfVMPack();
                    if (!string.endsWith(".vm")) {
                        string = string + ".vm";
                    }
                    if (!(file4 = new File(string)).exists()) {
                        file4.createNewFile();
                    }
                    this.createFinalVMPack(file4, file2, file3);
                    this.notifyObservers(new Integer("100"));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                file.delete();
                file2.delete();
                file3.delete();
            }
        }
    }

    private File createVMDotTar(JVMPack jVMPack, String string) throws IOException {
        if (new File(string).exists()) {
            if (new File(string + File.separator + "bin" + File.separator + "java").exists()) {
                String string2 = this.jvmPack.getLocationToSaveVMPack() + File.separator + "vm.tar";
                File file = new File(string2);
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.totalSizeOfFilesToTar = this.determineTotalNumberOfFilesToTar(new File(this.jvmPack.getSourceLocationOfVMPack()));
                TarOutputStream tarOutputStream = new TarOutputStream((OutputStream)new FileOutputStream(file));
                tarOutputStream.setLongFileMode(1);
                this.addFilesInDirToTarStream(tarOutputStream, new File(this.jvmPack.getSourceLocationOfVMPack()), true, new File(this.jvmPack.getSourceLocationOfVMPack()).getParent());
                tarOutputStream.flush();
                tarOutputStream.finish();
                tarOutputStream.close();
                return file;
            }
        }
        return null;
    }

    private void addFilesInDirToTarStream(TarOutputStream tarOutputStream, File file, boolean bl, String string) throws IOException {
        byte[] byArray = new byte[1024];
        TarEntry tarEntry = null;
        if (file.isFile()) {
            Object object;
            String string2 = file.getName();
            if (bl && (object = this.relativizePath(string, file.getAbsolutePath())) != null) {
                string2 = object;
            }
            if (this.jvmPack.getOperatingSystem() != 1) {
                string2 = string2.replaceAll("\\\\", "////");
            }
            if (!string2.substring(0, string2.indexOf(47)).equals("jre")) {
                string2 = string2.replaceAll(string2.substring(0, string2.indexOf(47)), "jre");
            }
            tarEntry = new TarEntry(string2);
            tarEntry.setSize(file.length());
            tarOutputStream.putNextEntry(tarEntry);
            object = new FileInputStream(file);
            int n = 0;
            while ((n = ((FileInputStream)object).read(byArray)) > 0) {
                tarOutputStream.write(byArray, 0, n);
            }
            tarOutputStream.closeEntry();
            ((FileInputStream)object).close();
            if (bl) {
                this.totalSizeProcessed += file.length();
                int n2 = (int)(this.totalSizeProcessed * 50L / this.totalSizeOfFilesToTar);
                this.notifyObservers(new Integer(n2));
            }
        } else {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.addFilesInDirToTarStream(tarOutputStream, fileArray[i], bl, string);
            }
        }
    }

    private String relativizePath(String string, String string2) {
        if (string2.length() < string.length()) {
            return null;
        }
        if (!string2.startsWith(string)) {
            return null;
        }
        String string3 = string2.substring(string.length());
        if (string3.startsWith(File.separator)) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    private long determineTotalNumberOfFilesToTar(File file) {
        long l = 0L;
        if (file.isFile()) {
            l += file.length();
        } else {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                l += this.determineTotalNumberOfFilesToTar(fileArray[i]);
            }
        }
        return l;
    }

    private File createVMDotTarDotZ(JVMPack jVMPack, File file) throws FileNotFoundException, IOException {
        int n;
        String string = this.jvmPack.getLocationToSaveVMPack() + File.separatorChar + "vm.tar.Z";
        File file2 = new File(string);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file2));
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray)) > 0) {
            gZIPOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        gZIPOutputStream.finish();
        gZIPOutputStream.close();
        this.notifyObservers(new Integer("60"));
        return file2;
    }

    private void createFinalVMPack(File file, File file2, File file3) {
        File[] fileArray = new File[]{file2, file3};
        int n = 10240;
        try {
            byte[] byArray = new byte[n];
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, new Manifest());
            for (int i = 0; i < fileArray.length; ++i) {
                int n2;
                if (fileArray[i] == null || !fileArray[i].exists() || fileArray[i].isDirectory()) continue;
                JarEntry jarEntry = new JarEntry(fileArray[i].getName());
                jarEntry.setTime(fileArray[i].lastModified());
                jarOutputStream.putNextEntry(jarEntry);
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                while ((n2 = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                    jarOutputStream.write(byArray, 0, n2);
                }
                fileInputStream.close();
            }
            jarOutputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public String getVMExePath() {
        return "bin/java";
    }

    @Override
    public String getVMPlatformFlavor(JVMPack jVMPack) {
        String string = "Windows";
        if (jVMPack.getOperatingSystem() == 2) {
            string = "AIX";
        } else if (jVMPack.getOperatingSystem() == 5) {
            string = "Solaris";
        } else if (jVMPack.getOperatingSystem() == 3) {
            string = "Linux";
        } else if (jVMPack.getOperatingSystem() == 4) {
            string = "HP-UX";
        }
        return string;
    }

    @Override
    public String getVMPlatformName() {
        return "unix";
    }
}

