/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.LogLevel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.time.LocalDateTime;

public abstract class AbstractLogger {
    protected static final String INFO_PREFIX = "[%s %s INFO] ";
    protected static final String WARNING_PREFIX = "[%s %s WARNING] ";
    protected static final String ERROR_PREFIX = "[%s %s ERROR] ";
    protected static final String DEBUG_PREFIX = "[%s %s DEBUG] ";
    protected static final String TRACE_PREFIX = "[%s %s TRACE] ";
    protected static final String LOG_PREFIX = "[%s %s] ";
    private static String installerVersion = null;
    protected LogLevel level = LogLevel.NONE;

    protected AbstractLogger(LogLevel level) {
        this.level = level;
    }

    public void setLevel(LogLevel level) {
        this.level = level;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    protected abstract void logImpl(LogLevel var1, String var2, String var3, String var4, String var5);

    public void info(String action, String msg) {
        this.info(action, msg, null);
    }

    public void info(String action, String msg, String remedialText) {
        if (LogLevel.INFO.code <= this.level.code) {
            this.logImpl(LogLevel.INFO, action, this.getLogPrefix(INFO_PREFIX), this.cleanMsg(msg), remedialText);
        }
    }

    public void warning(String action, String msg) {
        this.warning(action, msg, null);
    }

    public void warning(String action, String msg, String remedialText) {
        if (LogLevel.WARNING.code <= this.level.code) {
            this.logImpl(LogLevel.WARNING, action, this.getLogPrefix(WARNING_PREFIX), this.cleanMsg(msg), remedialText);
        }
    }

    public void error(String action, String msg) {
        this.error(action, msg, null);
    }

    public void error(String action, String msg, String remedialText) {
        if (LogLevel.ERROR.code <= this.level.code) {
            this.logImpl(LogLevel.ERROR, action, this.getLogPrefix(ERROR_PREFIX), this.cleanMsg(msg), remedialText);
        }
    }

    public void debug(String action, String msg) {
        this.debug(action, msg, null);
    }

    public void debug(String action, String msg, String remedialText) {
        if (LogLevel.DEBUG.code <= this.level.code) {
            this.logImpl(LogLevel.DEBUG, action, this.getLogPrefix(DEBUG_PREFIX), this.cleanMsg(msg), remedialText);
        }
    }

    public void enter(Object c) {
        if (LogLevel.TRACE.code <= this.level.code) {
            this.logImpl(LogLevel.TRACE, this.traceMethod(c), this.getLogPrefix(TRACE_PREFIX), "enter", null);
        }
    }

    public void exit(Object c) {
        if (LogLevel.TRACE.code <= this.level.code) {
            this.logImpl(LogLevel.TRACE, this.traceMethod(c), this.getLogPrefix(TRACE_PREFIX), "exit", null);
        }
    }

    public void trace(Object c, String msg) {
        if (LogLevel.TRACE.code <= this.level.code) {
            this.logImpl(LogLevel.TRACE, this.traceMethod(c), this.getLogPrefix(TRACE_PREFIX), msg, null);
        }
    }

    public void log(String action, String msg) {
        this.log(action, msg, null);
    }

    public void log(String action, String msg, String remedialText) {
        this.logImpl(LogLevel.ALL, action, this.getLogPrefix(LOG_PREFIX), this.cleanMsg(msg), remedialText);
    }

    private String cleanMsg(String msg) {
        if (msg != null) {
            msg = msg.replaceAll("http://.*@", "http://****@").replaceAll("https://.*@", "https://****@");
        }
        return msg;
    }

    private String traceMethod(Object c) {
        StackTraceElement ste = Thread.currentThread().getStackTrace()[4];
        return c.getClass().getName() + "." + ste.getMethodName();
    }

    private String getLogPrefix(String format) {
        if (installerVersion == null) {
            this.getInstallerVersion();
        }
        return String.format(format, installerVersion, LocalDateTime.now().toString());
    }

    private synchronized void getInstallerVersion() {
        if (installerVersion == null) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("installerVersion.txt")));
                installerVersion = r.readLine();
                r.close();
            }
            catch (Exception e) {
                installerVersion = "unknown";
            }
        }
    }
}

