/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import core.InstallerState;

public abstract class CustomCodeActionShim
extends CustomCodeAction {
    @Override
    public void install(InstallerProxy ip) throws InstallException {
        InstallerState.log.enter(this);
        try {
            this.installImpl(ip);
        }
        catch (Throwable t) {
            InstallerState.log.error(this.getClass().getName() + ".install", t.toString());
            throw t;
        }
        InstallerState.log.exit(this);
    }

    @Override
    public void uninstall(UninstallerProxy up) throws InstallException {
        InstallerState.log.enter(this);
        try {
            this.uninstallImpl(up);
        }
        catch (Throwable t) {
            InstallerState.log.error(this.getClass().getName() + ".uninstall", t.toString());
            throw t;
        }
        InstallerState.log.exit(this);
    }

    protected abstract void installImpl(IAProxy var1) throws InstallException;

    protected abstract void uninstallImpl(IAProxy var1) throws InstallException;
}

