/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.IAProxy;
import core.AbstractLogger;
import core.LogLevel;

public class IAProxyLogger
extends AbstractLogger {
    private final CustomError ce;

    public IAProxyLogger(LogLevel level, IAProxy iap) {
        super(level);
        this.ce = (CustomError)iap.getService(CustomError.class);
    }

    @Override
    protected void logImpl(LogLevel level, String action, String prefix, String msg, String remedialText) {
        if (this.ce != null && msg != null) {
            switch (level) {
                case ERROR: {
                    this.ce.appendError(msg, 97);
                    break;
                }
                case WARNING: {
                    this.ce.appendError(msg, 98);
                    break;
                }
                default: {
                    this.ce.appendMessage(msg);
                }
            }
            if (action != null) {
                this.ce.setLogDescription(action);
            }
            if (remedialText != null) {
                this.ce.setRemedialText(remedialText);
            }
            this.ce.log();
        }
    }
}

