/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.zerog.ia.api.pub.IAProxy;
import core.AbstractLogger;
import core.LogLevel;
import core.MultiLogger;
import core.NullLogger;
import core.PrintWriterLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import manifest.InstallManifest;
import manifest.PartOverride;
import repository.AbstractExternalRepository;
import repository.ExternalRepositoryException;
import repository.ManifestHint;

public final class InstallerState {
    public static AbstractLogger log = new NullLogger();
    public static AbstractExternalRepository repository = null;
    public static InstallManifest manifest = null;
    public static String[] installableNames = null;
    public static File userInstallDir = null;
    public static boolean noChecksum = false;
    public static List<PartOverride> partOverrides = null;
    public static List<ManifestHint> manifestHints = null;
    public static File cacheDir = null;
    public static boolean IsBundlerInstall = false;
    private static final String compatibleManifestSchemaVersion = "1.0,2.0.0";
    public static final String REPO_INITIALIZED = "$REPO_INITIALIZED$";
    public static final String MANIFEST_INITIALIZED = "$MANIFEST_INITIALIZED$";
    public static final String INSTALLABLES_INITIALIZED = "$INSTALLABLES_INITIALIZED$";
    public static final String USER_INSTALL_DIR_INITIALIZED = "$USER_INSTALL_DIR_INITIALIZED$";
    private static final String EMPTY_STRING = "";
    public static final String INSTALLABLE_CASRV_APPTIER = "CASRVR_AppTier";
    public static final String INSTALLABLE_CASRV_DATATIER = "CASRVR_DataTier";
    public static final String INSTALLABLE_CASRV_GATETIER = "CASRVR_Gate";
    public static final String INSTALLABLE_APACHE_SERVER = "ApachedsServer";
    public static final String INSTALLABLE_CASRV_EASY_INSTALL = "CASRVR_EasyInstall";
    public static final String INSTALLABLE_CLIENT_FM = "CACLIENT_fm";
    public static final String INSTALLABLE_CLIENT_DCUBEMODEL = "CACLIENT_dcubemodel";
    public static final String INSTALLABLE_CLIENT_DQA = "CACLIENT_dqa";
    public static final String INSTALLABLE_CLIENT_LCM = "CACLIENT_lcm";
    public static final String INSTALLABLE_JUPYTER = "CA_JupyterServer";
    public static final String INSTALLABLE_SDK = "CA_SDK";
    public static final String INSTALLTYPE_EASY = "Easy";
    public static final String INSTALLTYPE_CUSTOM = "Custom";
    public static final String CHOSEN_FEATURE_APPTIER = "FTR_APPTIER";
    public static final String CHOSEN_FEATURE_DATATIER = "FTR_DATATIER";
    public static final String CHOSEN_FEATURE_GATETIER = "FTR_GATETIER";
    public static final String CHOSEN_FEATURE_FMTIER = "FTR_FM";
    public static final String CHOSEN_FEATURE_DCUBETIER = "FTR_DCUBE";
    public static final String CHOSEN_FEATURE_DQA = "FTR_DQA";
    public static final String CHOSEN_FEATURE_LCM = "FTR_LCM";
    public static final String CHOSEN_FEATURE_JUPYTER = "FTR_JUPYTER";
    public static final String CHOSEN_FEATURE_SDK = "FTR_SDK";
    public static final String BACKUP_DIR = "install_backup";
    public static final String UNINSTALL_DIR = "uninstall";
    public static final String CONFIGURATION_DIR = "configuration";
    public static final String CONFIGURATION_METADATA_DIR = "metadata" + File.separator + "xml";
    public static final String RENDITION_DAT = "rendition.dat";
    public static final String CMPLIST_NAME = "cmplst.txt";
    public static final String INSTALLMETADATA_NAME = "metadata_install.xml";
    public static boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    public static final String IDS_HTTP = "http";
    public static boolean bTestMode = false;
    public static String IDS_IA_EXTRACTIONDIR_VARIABLE = "$prop.user.dir$";
    public static String LOCALIZED_INSTALLER_EXPECT_MANIFEST = "This installer expects manifests with version";
    public static String LOCALIZED_CURRENT_MANIFEST_VERSION = "The current manifest version is";
    public static String LOCALIZED_REPOSITORY_NOMANIFEST = "No manifests in repository.";
    public static String LOCALIZED_REPOSITORY_REPOURL = "At least one repository URL must be supplied.";
    public static String LOCALIZED_REPOSITORY_INVALIDREPOSPEC = "Invalid repository specification: ";
    public static String LOCALIZED_REPOSITORY_WRITEFILE = "Cannot write to file: ";
    public static String LOCALIZED_MANIFEST_NOVERSION = "No manifest_version found";
    public static String LOCALIZED_INSTALLERSTATE_LOGFILEFAIL = "Failed to open log file:";
    public static String LOCALIZED_INSTALLERSTATE_LOGLEVELFAIL = "Failed to set log level to:";
    public static String LOCALIZED_INSTALLERSTATE_OPENREPOFAIL = "Failed to open repository:";
    public static String LOCALIZED_INSTALLERSTATE_MANIFESTMISSING = "A repository containing the manifest must be specified.";
    public static String LOCALIZED_INSTALLERSTATE_INSTALLABLEMISSING = "A manifest containing the installables must be specified.";
    public static String LOCALIZED_INSTALLERSTATE_INSTALLABLENOTFOUND = "Unable to find Installable:";
    public static String LOCALIZED_INSTALLERSTATE_MANIFESTREADFAIL = "Failed to read manifest file.";
    public static String LOCALIZED_CAUPGRADEUTILITY_DELETEFAIL = "Unable to remove file/folder:";
    public static String LOCALIZED_PART_CREATEFAIL = "Couldn't create dir:";
    public static String LOCALIZED_PART_CHECKSUMFAIL = "File copy error, checksum mismatch.";
    public static String LOCALIZED_EXTERNALREPOSITORYFILE_NOTEXISTS = "does not exist.";
    public static String LOCALIZED_EXTERNALREPOSITORYFILE_INVALIDDIR = "is not a valid directory";
    public static String LOCALIZED_EXTERNALREPOSITORYGROUP_LOADFILEFAIL = "Cannot load file:";
    public static String LOCALIZED_EXTERNALREPOSITORYGROUP_VALIDATEURLFAIL = "validateURL should not be called for group.";
    public static String LOCALIZED_EXTERNALREPOSITORYZIP_NOTAFILE = "is not a file.";
    public static String LOCALIZED_EXTERNALREPOSITORYZIP_NOTAZIPFILE = "is not a zip file.";
    public static String LOCALIZED_EXTERNALREPOSITORYZIP_ARCHIVEFILEERROR = "Cannot read archive entry %1s from repository file %2s";
    public static String LOCALIZED_INITIALIZECHOSENFEATUREVARIABLE_EMPTYERROR = "The install cannot continue because it was unable to find the entries C8RS, C8CM, C8GATE inside the component list file:";
    public static String LOCALIZED_INITIALIZECHOSENFEATUREVARIABLE_POSSIBLESOLUTION = "Please try launching the install one more time. Pointing it to a location where a valid cmplst.txt file exists.";
    public static String LOCALIZED_GET_REPO_LICENSE_ERROR = "Unable to retrieve license for product: %1s from manifest: %2s";
    public static String LOCALIZED_WRITING_MANIFEST_ERROR = "Unable to write manifest file: ";

    public static String openLogFile(String filename) {
        log.log("open log file", filename);
        String rc = EMPTY_STRING;
        try {
            MultiLogger m = new MultiLogger();
            LogLevel level = log.getLevel();
            m.loggers.add(new PrintWriterLogger(level, filename));
            m.loggers.add(log);
            m.setLevel(level);
            log = m;
        }
        catch (Exception e) {
            rc = LOCALIZED_INSTALLERSTATE_LOGFILEFAIL + filename;
            log.error("openlogfile", rc + " " + e.getMessage());
        }
        return rc;
    }

    public static String setLogLevel(String level) {
        log.log("set log level", level);
        String rc = EMPTY_STRING;
        LogLevel ll = LogLevel.fromString(level);
        if (ll != null) {
            log.setLevel(ll);
        } else {
            rc = LOCALIZED_INSTALLERSTATE_LOGLEVELFAIL + level;
            log.log("set log level", rc);
        }
        return rc;
    }

    public static String openRepo(IAProxy iap, String repospec) {
        try {
            if (!repospec.startsWith(IDS_HTTP)) {
                File fRepo = new File(repospec);
                if (!fRepo.exists()) {
                    fRepo = new File(iap.substitute("$INSTALLER_LAUNCH_DIR$") + File.separator + repospec);
                }
                if (fRepo.exists()) {
                    repospec = fRepo.getCanonicalPath();
                }
            }
            repository = AbstractExternalRepository.factory(repospec);
            iap.setVariable(REPO_INITIALIZED, true);
        }
        catch (IOException | ExternalRepositoryException e) {
            return LOCALIZED_INSTALLERSTATE_OPENREPOFAIL + " " + e.getMessage();
        }
        return EMPTY_STRING;
    }

    public static String openManifest(IAProxy iap, String strManifest) {
        File manifestFile = new File(strManifest);
        try {
            if (!manifestFile.exists()) {
                manifestFile = new File(iap.substitute("$INSTALLER_LAUNCH_DIR$") + File.separator + strManifest);
            }
            if (manifestFile.exists()) {
                log.debug("Open manifest file", strManifest);
                manifest = InstallManifest.decode(new String(Files.readAllBytes(manifestFile.toPath())));
                iap.setVariable(MANIFEST_INITIALIZED, true);
            } else {
                log.debug("Open manifest file from repository", strManifest);
                if (repository == null) {
                    return LOCALIZED_INSTALLERSTATE_MANIFESTMISSING;
                }
                String manifestFileName = repository.findManifest(strManifest);
                String manifestText = repository.getRepositoryFileAsString(manifestFileName);
                manifest = InstallManifest.decode(manifestText);
                iap.setVariable(MANIFEST_INITIALIZED, true);
            }
        }
        catch (Exception e) {
            return "Failed to read manifest file: " + strManifest + " " + e.getMessage();
        }
        return InstallerState.compatibleWithManifest(manifest);
    }

    public static String compatibleWithManifest(InstallManifest manifest) {
        String ret = EMPTY_STRING;
        if (manifest != null && !manifest.isCompatible(compatibleManifestSchemaVersion)) {
            ret = InstallerState.getIncompatibleManifestMessage(manifest);
        }
        return ret;
    }

    public static String getIncompatibleManifestMessage(InstallManifest manifest) {
        StringBuffer msg = new StringBuffer();
        msg.append(LOCALIZED_INSTALLER_EXPECT_MANIFEST + " " + compatibleManifestSchemaVersion + ". ");
        msg.append(LOCALIZED_CURRENT_MANIFEST_VERSION + " " + manifest.getManifestSchemaVersion() + ".");
        return msg.toString();
    }

    public static String getCompatibleManifestSchemaVersion() {
        return compatibleManifestSchemaVersion;
    }

    public static void setManifest(InstallManifest iManifest) {
        manifest = iManifest;
    }

    public static String validateInstallables(IAProxy iap, String strInstallables) {
        if (manifest == null) {
            return LOCALIZED_INSTALLERSTATE_INSTALLABLEMISSING;
        }
        try {
            for (String installableName : installableNames = strInstallables.split(",")) {
                if (manifest.getInstallable(installableName) != null) continue;
                return LOCALIZED_INSTALLERSTATE_INSTALLABLENOTFOUND + installableName;
            }
            iap.setVariable(INSTALLABLES_INITIALIZED, true);
        }
        catch (Exception e) {
            return LOCALIZED_INSTALLERSTATE_MANIFESTREADFAIL + e.getMessage();
        }
        return EMPTY_STRING;
    }

    public static String setUserInstallDir(IAProxy iap, String installDir) {
        try {
            File ih = new File(installDir);
            boolean rc = !ih.exists() ? ih.mkdirs() : ih.isDirectory();
            if (rc) {
                userInstallDir = ih;
                iap.setVariable(USER_INSTALL_DIR_INITIALIZED, true);
                return EMPTY_STRING;
            }
        }
        catch (Exception e) {
            boolean rc = false;
        }
        return "Unable to set install location to " + installDir;
    }

    public static void setNoChecksum(String value) {
        noChecksum = Boolean.valueOf(value);
        log.debug("noChecksum set to", String.valueOf(noChecksum));
    }

    public static void setBundlerInstall(boolean value) {
        IsBundlerInstall = value;
        log.debug("bundlerInstall set to", String.valueOf(IsBundlerInstall));
    }

    public static void setPartOverrides(String value) {
        partOverrides = new ArrayList<PartOverride>();
        for (String po : value.split(",")) {
            partOverrides.add(new PartOverride(po));
        }
    }

    public static void setManifestHints(String value) {
        manifestHints = new ArrayList<ManifestHint>();
        for (String spec : value.split(",")) {
            manifestHints.add(new ManifestHint(spec));
        }
    }

    public static void setRepositoryCacheDir(String value) {
        cacheDir = new File(value);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        if (!cacheDir.isDirectory()) {
            cacheDir = null;
            log.debug("repository cache specification invalid.", "Ignoring it.");
        } else {
            log.debug("repository cache set to", cacheDir.getAbsolutePath());
        }
    }

    public static void setLocalizedMessages(IAProxy iap) {
        if (bTestMode) {
            return;
        }
        if (!iap.getValue("InstallerState.expectedmanifestversion").isEmpty()) {
            LOCALIZED_INSTALLER_EXPECT_MANIFEST = iap.getValue("InstallerState.expectedmanifestversion");
        }
        if (!iap.getValue("InstallerState.currentmanifestversion").isEmpty()) {
            LOCALIZED_CURRENT_MANIFEST_VERSION = iap.getValue("InstallerState.currentmanifestversion");
        }
        if (!iap.getValue("AbstractExternalRepository.nomanifest").isEmpty()) {
            LOCALIZED_REPOSITORY_NOMANIFEST = iap.getValue("AbstractExternalRepository.nomanifest");
        }
        if (!iap.getValue("AbstractExternalRepository.repourl").isEmpty()) {
            LOCALIZED_REPOSITORY_REPOURL = iap.getValue("AbstractExternalRepository.repourl");
        }
        if (!iap.getValue("AbstractExternalRepository.invalidrepospec").isEmpty()) {
            LOCALIZED_REPOSITORY_INVALIDREPOSPEC = iap.getValue("AbstractExternalRepository.invalidrepospec");
        }
        if (!iap.getValue("AbstractExternalRepository.writefile").isEmpty()) {
            LOCALIZED_REPOSITORY_WRITEFILE = iap.getValue("AbstractExternalRepository.writefile");
        }
        if (!iap.getValue("InstallManifest.noversion").isEmpty()) {
            LOCALIZED_MANIFEST_NOVERSION = iap.getValue("InstallManifest.noversion");
        }
        if (!iap.getValue("InstallerState.logfilefail").isEmpty()) {
            LOCALIZED_INSTALLERSTATE_LOGFILEFAIL = iap.getValue("InstallerState.logfilefail");
        }
        if (!iap.getValue("InstallerState.loglevelfail").isEmpty()) {
            LOCALIZED_INSTALLERSTATE_LOGLEVELFAIL = iap.getValue("InstallerState.loglevelfail");
        }
        if (!iap.getValue("InstallerState.openrepofail").isEmpty()) {
            LOCALIZED_INSTALLERSTATE_OPENREPOFAIL = iap.getValue("InstallerState.openrepofail");
        }
        if (!iap.getValue("InstallerState.manifestmissing").isEmpty()) {
            LOCALIZED_INSTALLERSTATE_MANIFESTMISSING = iap.getValue("InstallerState.manifestmissing");
        }
        if (!iap.getValue("InstallerState.installablemissing").isEmpty()) {
            LOCALIZED_INSTALLERSTATE_INSTALLABLEMISSING = iap.getValue("InstallerState.installablemissing");
        }
        if (!iap.getValue("InstallerState.installablenotfound").isEmpty()) {
            LOCALIZED_INSTALLERSTATE_INSTALLABLENOTFOUND = iap.getValue("InstallerState.installablenotfound");
        }
        if (!iap.getValue("InstallerState.manifestreadfail").isEmpty()) {
            LOCALIZED_INSTALLERSTATE_MANIFESTREADFAIL = iap.getValue("InstallerState.manifestreadfail");
        }
        if (!iap.getValue("caupgradeutility.deletefail").isEmpty()) {
            LOCALIZED_CAUPGRADEUTILITY_DELETEFAIL = iap.getValue("caupgradeutility.deletefail");
        }
        if (!iap.getValue("part.createfail").isEmpty()) {
            LOCALIZED_PART_CREATEFAIL = iap.getValue("part.createfail");
        }
        if (!iap.getValue("externalrepositoryfile.notexists").isEmpty()) {
            LOCALIZED_EXTERNALREPOSITORYFILE_NOTEXISTS = iap.getValue("externalrepositoryfile.notexists");
        }
        if (!iap.getValue("externalrepositoryfile.invaliddir").isEmpty()) {
            LOCALIZED_EXTERNALREPOSITORYFILE_INVALIDDIR = iap.getValue("externalrepositoryfile.invaliddir");
        }
        if (!iap.getValue("externalrepositorygroup.loadfilefail").isEmpty()) {
            LOCALIZED_EXTERNALREPOSITORYGROUP_LOADFILEFAIL = iap.getValue("externalrepositorygroup.loadfilefail");
        }
        if (!iap.getValue("externalrepositorygroup.validateurlfail").isEmpty()) {
            LOCALIZED_EXTERNALREPOSITORYGROUP_VALIDATEURLFAIL = iap.getValue("externalrepositorygroup.validateurlfail");
        }
        if (!iap.getValue("externalrepositoryzip.notafile").isEmpty()) {
            LOCALIZED_EXTERNALREPOSITORYZIP_NOTAFILE = iap.getValue("externalrepositoryzip.notafile");
        }
        if (!iap.getValue("externalrepositoryzip.notazipfile").isEmpty()) {
            LOCALIZED_EXTERNALREPOSITORYZIP_NOTAZIPFILE = iap.getValue("externalrepositoryzip.notazipfile");
        }
        if (!iap.getValue("externalrepositoryzip.archivefileerror").isEmpty()) {
            LOCALIZED_EXTERNALREPOSITORYZIP_ARCHIVEFILEERROR = iap.getValue("externalrepositoryzip.archivefileerror");
        }
        if (!iap.getValue("InitializeChosenFeatureVariable.emptyerror").isEmpty()) {
            LOCALIZED_INITIALIZECHOSENFEATUREVARIABLE_EMPTYERROR = iap.getValue("InitializeChosenFeatureVariable.emptyerror");
        }
        if (!iap.getValue("InitializeChosenFeatureVariable.possiblesolution").isEmpty()) {
            LOCALIZED_INITIALIZECHOSENFEATUREVARIABLE_POSSIBLESOLUTION = iap.getValue("InitializeChosenFeatureVariable.possiblesolution");
        }
        if (!iap.getValue("CARepoLicense.getLicenseError").isEmpty()) {
            LOCALIZED_GET_REPO_LICENSE_ERROR = iap.getValue("CARepoLicense.getLicenseError");
        }
        if (!iap.getValue("InstallFromRepo.writeManifestFileError").isEmpty()) {
            LOCALIZED_WRITING_MANIFEST_ERROR = iap.getValue("InstallFromRepo.writeManifestFileError");
        }
    }

    public static void reset() {
        log = new NullLogger();
        repository = null;
        manifest = null;
        installableNames = null;
        userInstallDir = null;
        bTestMode = true;
    }

    public static enum INSTALLABLEID {
        APPTIER,
        DATATIER,
        GATETIER,
        EASYINSTALL,
        FM,
        LCM,
        DCUBEMODEL,
        DQA,
        JUPYTER,
        SDK;

    }
}

