/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.AbstractLogger;
import core.LogLevel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;

public class PrintWriterLogger
extends AbstractLogger {
    private PrintWriter writer;

    public PrintWriterLogger(LogLevel level, String filename) throws FileNotFoundException {
        super(level);
        File dir = new File(filename).getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        this.writer = new PrintWriter(filename);
    }

    @Override
    protected void logImpl(LogLevel level, String action, String prefix, String msg, String remedialText) {
        if (this.writer != null && msg != null) {
            StringBuffer text = new StringBuffer();
            text.append(prefix);
            if (action != null) {
                text.append(action);
                text.append(": ");
            }
            text.append(msg);
            if (remedialText != null) {
                text.append(" ");
                text.append(remedialText);
            }
            this.writer.println(text.toString());
            this.writer.flush();
        }
    }
}

