/*
 * Decompiled with CFR 0.152.
 */
package core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utility {
    public static final String USERNAME_PATTERN = "[a-zA-Z]{1}([a-zA-Z0-9]|[._]){4,19}$";
    public static final String PASSWORD_PATTERN = "((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$]).{15,20})";
    public static final String PASSWORD_PATTERN_LCM = "((?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%]).{15,20})";
    public static final String MANIFEST_VERSION_EXPRESSION = "\\d+(\\.\\d+\\.\\d+\\-\\d+)+";
    public static final String MANIFEST_NAME_ARTIFACTORY = "<a[^>]*>(.*?)</a>";

    public static boolean validateUsername(String userName) {
        Pattern pattern = Pattern.compile(USERNAME_PATTERN);
        Matcher matcher = pattern.matcher(userName);
        return matcher.matches();
    }

    public static boolean validatePassword(String password, String passwordPattern) {
        Pattern pattern = Pattern.compile(passwordPattern);
        Matcher matcher = pattern.matcher(password);
        return matcher.matches();
    }

    public static String getValueByPattern(String expression, String baseString, int groupNumber) {
        String value = "";
        Pattern p = Pattern.compile(expression);
        Matcher m = p.matcher(baseString);
        if (m.find()) {
            value = m.group(groupNumber);
        }
        return value;
    }
}

