/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.ejalbert;

import com.zerog.ia.installer.util.mrj.MRJUtilsHelper;
import com.zerog.util.ZGUtil;
import edu.stanford.cs.ejalbert.LaunchUnixBrowser;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;

public class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Object linkage;
    private static final int MRJ_2_2 = 1;
    private static final int MRJ_3_0 = 3;
    private static final int MRJ_3_1 = 4;
    private static final int MRJ_10_8_JRE7_ONWARDS = 7;
    private static final int WINDOWS_NT = 5;
    private static final int WINDOWS_9x = 6;
    private static final int OTHER = -1;
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END_1 = ")'";
    private static final String NETSCAPE_OPEN_PARAMETER_END_2 = ", new-window)'";
    private static String errorMessage;

    private BrowserLauncher() {
    }

    private static boolean loadClasses() {
        switch (jvm) {
            case 3: {
                try {
                    Class<?> linker = Class.forName("com.apple.mrj.jdirect.Linker");
                    Constructor<?> constructor = linker.getConstructor(Class.class);
                    linkage = constructor.newInstance(BrowserLauncher.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (InvocationTargetException ite) {
                    errorMessage = ite.getMessage();
                    return false;
                }
                catch (InstantiationException ie) {
                    errorMessage = ie.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
                catch (Throwable t) {
                    errorMessage = t.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 1: {
                browser = "MRJFileUtils.openURL()";
                break;
            }
            case 3: {
                browser = "JDirect Invocation";
                break;
            }
            case 4: {
                browser = "MRJFileUtils.openURL()";
                break;
            }
            case 7: {
                browser = "MRJUtilsHelper.openURL()";
                break;
            }
            case 5: {
                browser = "cmd.exe";
                break;
            }
            case 6: {
                browser = "command.com";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    public static void openURL(String url) throws IOException {
        if (ZGUtil.MACOSX) {
            url = BrowserLauncher.escapeSpaces(url);
        }
        System.err.println("\nBrowserLauncher.openURL(" + url + ")\n");
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        Object browser = BrowserLauncher.locateBrowser();
        if (browser == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        BrowserLauncher.openURL(url, browser);
    }

    private static String escapeSpaces(String originalURL) {
        String newURL = originalURL;
        StringTokenizer st = new StringTokenizer(originalURL);
        if (st.hasMoreTokens()) {
            newURL = st.nextToken();
            while (st.hasMoreTokens()) {
                newURL = newURL + "%20" + st.nextToken();
            }
        }
        return newURL;
    }

    private static void openURL(String url, Object browser) throws IOException {
        block1 : switch (jvm) {
            case 1: 
            case 4: 
            case 7: {
                try {
                    MRJUtilsHelper.openURL(url);
                    break;
                }
                catch (Exception e) {
                    throw new IOException("Unable to launch default browser using: " + browser);
                }
            }
            case 3: {
                int[] instance = new int[1];
                int result = BrowserLauncher.ICStart(instance, 0);
                if (result == 0) {
                    int[] selectionEnd;
                    int[] selectionStart = new int[]{0};
                    byte[] urlBytes = url.getBytes();
                    result = BrowserLauncher.ICLaunchURL(instance[0], new byte[]{0}, urlBytes, urlBytes.length, selectionStart, selectionEnd = new int[]{urlBytes.length});
                    if (result == 0) {
                        BrowserLauncher.ICStop(instance);
                        break;
                    }
                    throw new IOException("Unable to launch URL: " + result);
                }
                throw new IOException("Unable to create an Internet Config instance: " + result);
            }
            case 5: 
            case 6: {
                if (!url.startsWith("\"")) {
                    url = '\"' + url + '\"';
                }
                String[] winArgs = null;
                winArgs = jvm == 5 ? new String[]{(String)browser, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, url} : new String[]{(String)browser, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, url};
                if (ZGUtil.execCommandLine(winArgs, true, "BrowserLaunch (Win32): ", false, true)) break;
                throw new IOException("BrowserLauncher(Win32): unable to open default browser");
            }
            case -1: {
                String[] browsers = new String[]{"netscape", "mozilla", "firefox", "mozilla-firefox", "konqueror", "opera"};
                for (int i = 0; i < browsers.length; ++i) {
                    LaunchUnixBrowser launcher = new LaunchUnixBrowser(browsers[i], url);
                    launcher.run();
                    if (launcher.getReturnCode() == 0) break block1;
                }
                break;
            }
            default: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
            }
        }
    }

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);

    static {
        block13: {
            loadedWithoutErrors = true;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                if (ZGUtil.isUseJava7AndAboveOracleVMOnMacOSX()) {
                    jvm = 7;
                } else {
                    String mrjVersion = System.getProperty("mrj.version");
                    String majorMRJVersion = mrjVersion.substring(0, 3);
                    try {
                        double version = Double.valueOf(majorMRJVersion);
                        if (version >= 2.2) {
                            if (version >= 2.2 && version < 3.0) {
                                jvm = 1;
                            } else if (version == 3.0) {
                                jvm = 3;
                            } else if (version >= 3.1) {
                                jvm = 4;
                            }
                            break block13;
                        }
                        loadedWithoutErrors = false;
                        errorMessage = "Unsupported MRJ version: " + version;
                    }
                    catch (NumberFormatException nfe) {
                        loadedWithoutErrors = false;
                        errorMessage = "Invalid MRJ version: " + mrjVersion;
                    }
                }
            } else {
                jvm = osName.startsWith("Windows") ? 5 : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }
}

