/*
 * Decompiled with CFR 0.152.
 */
package manifest;

import core.Utility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.Year;
import java.util.HashSet;
import java.util.Locale;
import manifest.InstallManifest;
import manifest.Installable;
import manifest.Part;

public class CmpList {
    private static final String CMPLST_ENTRY_VERSION_FORMAT = "%s_version=%s";
    private static final String[] CMPLST_COPYRIGHT = new String[]{"; Licensed Materials - Property of IBM Business Analytics", "; (C) Copyright IBM Corp. 2004, " + Year.now().toString(), "; US Government Users Restricted Rights - Use, duplication or", "; disclosure restricted by GSA ADP Schedule Contract with IBM Corp"};
    private static final String PRODUCT_VERSION = "Product_version=%s";
    private static final String OPERATING_SYSTEM = "Operating System: %s";
    private static final String OS_ARCHITECTURE = "Operating System Architecture: %s";
    private static final String OS_VERSION = "Operating System Version: %s";
    private static final String MANIFEST = "Manifest=%s";
    private static final String KIT_VERSION = "kit_version=%s";
    private static final String INSTALLTYPE = "install_type=%s";
    private static final String SELECTEDFEATURES = "selected_features=%s";
    private static final String INSTALLER = "Installer=%s";
    public static final String BACKSLASH = "\\";
    public static final String FORWARD_SLASH = "/";
    public static final String gate_dash = "gate-";
    public static final String GATE = "GATE";

    public static void write(InstallManifest manifest, String filename, String installType, String chosenFeature, String installExecutable) throws FileNotFoundException {
        CmpList.writeCmplst(manifest, filename, installType, chosenFeature, installExecutable);
    }

    public static void writeCmplst(InstallManifest manifest, String filename, String installType, String chosenFeature, String installExecutable) throws FileNotFoundException {
        try (PrintWriter out = new PrintWriter(filename);){
            String manifestName;
            for (String s : CMPLST_COPYRIGHT) {
                out.println(s);
            }
            out.println();
            out.printf(OPERATING_SYSTEM, System.getProperty("os.name"));
            out.println();
            out.printf(OS_ARCHITECTURE, System.getProperty("os.arch"));
            out.println();
            out.printf(OS_VERSION, System.getProperty("os.version"));
            out.println();
            String kitVersion = manifest.getManifestName();
            if (kitVersion != null) {
                out.printf(KIT_VERSION, Utility.getValueByPattern("\\d+(\\.\\d+\\.\\d+\\-\\d+)+", kitVersion, 0));
                out.println();
            }
            if ((manifestName = manifest.getManifestName()) != null) {
                manifestName = manifestName.replace(BACKSLASH, FORWARD_SLASH);
                manifestName = manifestName.substring(manifestName.lastIndexOf(FORWARD_SLASH) + 1);
                out.printf(MANIFEST, manifestName);
                out.println();
            }
            String installExecutableFilename = CmpList.getFileNameFromPath(installExecutable);
            out.printf(INSTALLER, installExecutableFilename);
            out.println();
            out.println();
            out.printf(PRODUCT_VERSION, manifest.getProductVersion());
            out.println();
            out.printf(INSTALLTYPE, installType);
            out.println();
            out.printf(SELECTEDFEATURES, chosenFeature);
            out.println();
            HashSet<String> listedParts = new HashSet<String>();
            block20: for (Installable itemInstallable : manifest.getInstallables()) {
                if (!itemInstallable.isSelectedForInstallation()) continue;
                for (Part itemPart : itemInstallable.getParts()) {
                    String id2;
                    String cmplstCompName = itemPart.getName();
                    String classifier = itemPart.getClassifier();
                    if (manifest.getManifestSchemaVersion().equals("1.0") && cmplstCompName.equalsIgnoreCase("xqe") && !chosenFeature.contains("FTR_APPTIER") && classifier != null) {
                        cmplstCompName = cmplstCompName + classifier;
                    } else if (classifier != null && classifier.contains(gate_dash)) {
                        cmplstCompName = cmplstCompName + GATE;
                    }
                    if (chosenFeature.contains("FTR_DATATIER") && cmplstCompName.equalsIgnoreCase("security-install") && classifier != null) {
                        cmplstCompName = cmplstCompName + classifier;
                    }
                    if (listedParts.contains(id2 = cmplstCompName + itemPart.getVersion())) continue;
                    listedParts.add(id2);
                    out.printf(CMPLST_ENTRY_VERSION_FORMAT, cmplstCompName.toUpperCase(Locale.US), itemPart.getVersion());
                    out.println();
                }
                switch (itemInstallable.getName()) {
                    case "CASRVR_AppTier": {
                        out.printf(CMPLST_ENTRY_VERSION_FORMAT, "C8RS", manifest.getProductVersion());
                        out.println();
                        out.printf(CMPLST_ENTRY_VERSION_FORMAT, "C8BISRVRRS", manifest.getProductVersion());
                        out.println();
                        continue block20;
                    }
                    case "CASRVR_DataTier": {
                        out.printf(CMPLST_ENTRY_VERSION_FORMAT, "C8CM", manifest.getProductVersion());
                        out.println();
                        continue block20;
                    }
                    case "CASRVR_Gate": {
                        out.printf(CMPLST_ENTRY_VERSION_FORMAT, "C8GATE", manifest.getProductVersion());
                        out.println();
                        out.printf(CMPLST_ENTRY_VERSION_FORMAT, "GATEWAY", manifest.getProductVersion());
                        out.println();
                        continue block20;
                    }
                }
            }
        }
    }

    public static void writeCmplst2(InstallManifest manifest, String filename, String installType, String chosenFeature, String installExecutable) throws FileNotFoundException {
        try (PrintWriter out = new PrintWriter(filename);){
            for (String s : CMPLST_COPYRIGHT) {
                out.println(s);
            }
            out.println();
            out.printf(OPERATING_SYSTEM, System.getProperty("os.name"));
            out.println();
            out.printf(OS_ARCHITECTURE, System.getProperty("os.arch"));
            out.println();
            out.printf(OS_VERSION, System.getProperty("os.version"));
            out.println();
            String manifestName = manifest.getManifestName();
            if (manifestName != null) {
                manifestName = manifestName.replace(BACKSLASH, FORWARD_SLASH);
                manifestName = manifestName.substring(manifestName.lastIndexOf(FORWARD_SLASH) + 1);
                out.printf(MANIFEST, manifestName);
                out.println();
            }
            out.printf(INSTALLER, installExecutable);
            out.println();
            out.printf(SELECTEDFEATURES, chosenFeature);
            out.println();
            out.println();
            out.printf(PRODUCT_VERSION, manifest.getProductVersion());
            out.println();
            out.printf(INSTALLTYPE, installType);
            out.println();
            HashSet listedParts = new HashSet();
            for (Installable itemInstallable : manifest.getInstallables()) {
                if (!itemInstallable.isSelectedForInstallation()) continue;
                for (Part itemPart : itemInstallable.getParts()) {
                    if (listedParts.contains(itemPart.getRepositoryPath())) continue;
                    out.printf(itemPart.getRepositoryPath(), new Object[0]);
                    out.println();
                }
            }
        }
    }

    public static String getFileNameFromPath(String value) {
        String fileName = value;
        if (!fileName.isEmpty()) {
            File file = new File(fileName);
            fileName = file.getName();
        }
        return fileName;
    }
}

