/*
 * Decompiled with CFR 0.152.
 */
package manifest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import core.InstallerState;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import manifest.Installable;
import manifest.ManifestException;
import manifest.Part;
import manifest.PartOverride;

public class InstallManifest
implements Comparable<InstallManifest> {
    private static final String MANIFEST_KEY = "\"manifestVersion\"";
    private String manifestVersion;
    private String productVersion;
    private transient String strName;
    Installable[] installables;

    public String encode() throws ManifestException {
        Gson gson = new GsonBuilder().create();
        return gson.toJson(this);
    }

    public static InstallManifest decode(String json) throws ManifestException {
        Gson gson = new GsonBuilder().create();
        return gson.fromJson(json, InstallManifest.class);
    }

    public void applyOverrides(List<PartOverride> overrides) {
        if (overrides != null) {
            for (PartOverride override : overrides) {
                for (Installable i : this.installables) {
                    for (Part part : i.getParts()) {
                        part.applyOverride(override);
                    }
                }
            }
        }
    }

    public boolean isCompatible(String compatibilityLevel) {
        boolean bCompatible = false;
        String[] strList = compatibilityLevel.split(",");
        for (int i = 0; i < strList.length && !(bCompatible = InstallManifest.isCompatible(strList[i], this.getManifestSchemaVersion())); ++i) {
        }
        return bCompatible;
    }

    public static boolean isCompatible(String compatibilityLevel, String manifestSchemaVersion) {
        String[] manifestlevel;
        int shortest;
        String[] minLevel = compatibilityLevel.split("\\.|-");
        int n = shortest = minLevel.length < (manifestlevel = manifestSchemaVersion.split("\\.|-")).length ? minLevel.length : manifestlevel.length;
        if (shortest == 0) {
            return false;
        }
        if (!minLevel[0].equalsIgnoreCase(manifestlevel[0])) {
            return false;
        }
        for (int i = 1; i < shortest; ++i) {
            try {
                int iCompatible = Integer.valueOf(minLevel[i]);
                int iManifest = Integer.valueOf(manifestlevel[i]);
                if (iManifest >= iCompatible) continue;
                return false;
            }
            catch (Exception e) {
                if (manifestlevel[i].compareToIgnoreCase(minLevel[i]) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String getManifestSchemaVersion(String json) throws ManifestException {
        int mvs = json.indexOf(MANIFEST_KEY);
        if (mvs == -1) {
            throw new ManifestException(InstallerState.LOCALIZED_MANIFEST_NOVERSION);
        }
        mvs = json.indexOf("\"", mvs + MANIFEST_KEY.length()) + 1;
        int mve = json.indexOf("\"", mvs);
        return json.substring(mvs, mve);
    }

    public String getManifestSchemaVersion() {
        return this.manifestVersion;
    }

    public void setManifestSchemaVersion(String manifestSchemaVersion) {
        this.manifestVersion = manifestSchemaVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getManifestName() {
        return this.strName;
    }

    public void setManifestName(String manifestName) {
        this.strName = manifestName;
    }

    public Installable[] getInstallables() {
        return this.installables;
    }

    public void setInstallables(Installable[] installables) {
        this.installables = installables;
    }

    public String getInstallablesAsList() {
        String strInstallablesList = "";
        for (Installable item : this.installables) {
            strInstallablesList = strInstallablesList.isEmpty() ? item.getName() : strInstallablesList + "," + item.getName();
        }
        return strInstallablesList;
    }

    public Installable getInstallable(String strInstallableName) {
        for (Installable item : this.installables) {
            if (item.getName().compareTo(strInstallableName) != 0) continue;
            return item;
        }
        return null;
    }

    public Installable getInstallableByProductName(String strProductName) {
        for (Installable item : this.installables) {
            if (!item.getName().contains(strProductName)) continue;
            return item;
        }
        return null;
    }

    public long getSelectedInstallablesSize() {
        HashSet<String> installedParts = new HashSet<String>();
        long total = 0L;
        for (Installable installItem : this.getInstallables()) {
            if (!installItem.isSelectedForInstallation()) continue;
            for (Part partItem : installItem.getParts()) {
                String id2;
                String compName = partItem.getName();
                if (partItem.getClassifier() != null) {
                    compName = compName + partItem.getClassifier();
                }
                if (installedParts.contains(id2 = compName + partItem.getVersion())) continue;
                installedParts.add(id2);
                total += partItem.getSize();
            }
        }
        return total;
    }

    public boolean DoesInstallableExist(InstallerState.INSTALLABLEID nInstallableID) {
        boolean bRet = false;
        String strInstallableName = "";
        switch (nInstallableID) {
            case APPTIER: {
                strInstallableName = "CASRVR_AppTier";
                break;
            }
            case DATATIER: {
                strInstallableName = "CASRVR_DataTier";
                break;
            }
            case GATETIER: {
                strInstallableName = "CASRVR_Gate";
                break;
            }
            case EASYINSTALL: {
                strInstallableName = "CASRVR_EasyInstall";
                break;
            }
            case FM: {
                strInstallableName = "CACLIENT_fm";
                break;
            }
            case LCM: {
                strInstallableName = "CACLIENT_lcm";
                break;
            }
            case DCUBEMODEL: {
                strInstallableName = "CACLIENT_dcubemodel";
                break;
            }
            case DQA: {
                strInstallableName = "CACLIENT_dqa";
                break;
            }
            case JUPYTER: {
                strInstallableName = "CA_JupyterServer";
                break;
            }
            case SDK: {
                strInstallableName = "CA_SDK";
            }
        }
        for (Installable item : this.installables) {
            if (!strInstallableName.contains(item.getName())) continue;
            return true;
        }
        return bRet;
    }

    public void ResetInstallableInstallSelectedStatus() {
        for (Installable item : this.installables) {
            item.setSelectedForInstallation(false);
        }
    }

    public static void prettyPrintJsonObjToFile(String outputFileName, Object jsonObj) throws FileNotFoundException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (PrintWriter out = new PrintWriter(outputFileName);){
            out.println(gson.toJson(jsonObj));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.installables);
        result = 31 * result + (this.manifestVersion == null ? 0 : this.manifestVersion.hashCode());
        result = 31 * result + (this.productVersion == null ? 0 : this.productVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstallManifest)) {
            return false;
        }
        InstallManifest other = (InstallManifest)obj;
        if (!Arrays.equals(this.installables, other.installables)) {
            return false;
        }
        if (this.manifestVersion == null ? other.manifestVersion != null : !this.manifestVersion.equals(other.manifestVersion)) {
            return false;
        }
        return !(this.productVersion == null ? other.productVersion != null : !this.productVersion.equals(other.productVersion));
    }

    @Override
    public int compareTo(InstallManifest o) {
        return 0;
    }
}

