/*
 * Decompiled with CFR 0.152.
 */
package manifest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.Year;
import manifest.InstallManifest;

public class InstallMetadata {
    private static final String CMPLST_ENTRY_VERSION_FORMAT = "%s_version=%s";
    private static final String[] INSTALLMETADATA_COPYRIGHT = new String[]{"<!--  Licensed Materials - Property of IBM Business Analytics", " (C) Copyright IBM Corp. 2004, " + Year.now().toString(), " US Government Users Restricted Rights - Use, duplication or", " disclosure restricted by GSA ADP Schedule Contract with IBM Corp-->"};
    private static final String XML_ROOTELEMENT_START = "<InstallService label=\"Install Service\">\n\t<parameters>";
    private static final String XML_ROOTELEMENT_END = "\n\t</parameters>\n</InstallService>";
    private static final String PRODUCT_VERSION = "\t\t<parameter name=\"productVersion\" type=\"string\" default=\"%s\"/>";
    private static final String MANIFEST = "\t\t<parameter name=\"manifestVersion\" type=\"string\" default=\"%s\"/>";
    private static final String ENABLEMANIFEST = "\t\t<parameter name=\"enableManifest\" type=\"boolean\" default=\"true\"/>";
    public static final String BACKSLASH = "\\";
    public static final String FORWARD_SLASH = "/";

    public static void write(InstallManifest manifest, String destDir, String filename) throws FileNotFoundException {
        File destPath = new File(destDir);
        if (!destPath.exists()) {
            destPath.mkdirs();
        }
        try (PrintWriter out = new PrintWriter(destDir + File.separator + filename);){
            for (String s : INSTALLMETADATA_COPYRIGHT) {
                out.println(s);
            }
            out.printf(XML_ROOTELEMENT_START, new Object[0]);
            out.println();
            out.printf(PRODUCT_VERSION, manifest.getProductVersion());
            out.println();
            String manifestName = manifest.getManifestName();
            if (manifestName != null) {
                manifestName = manifestName.replace(BACKSLASH, FORWARD_SLASH);
                manifestName = manifestName.substring(manifestName.lastIndexOf(FORWARD_SLASH) + 1);
                out.printf(MANIFEST, manifestName);
                out.println();
            }
            out.printf(ENABLEMANIFEST, new Object[0]);
            out.printf(XML_ROOTELEMENT_END, new Object[0]);
            out.println();
        }
    }
}

