/*
 * Decompiled with CFR 0.152.
 */
package manifest;

import core.InstallerState;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import manifest.PartOverride;
import manifest.UnsupportedArchiveException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import repository.AbstractExternalRepository;
import repository.ExternalRepositoryAuthorizationException;
import repository.ExternalRepositoryException;
import repository.RepositoryInputStream;

public class Part {
    public static final int RETRY_INTERVAL = 2000;
    private static final int RETRY_COUNT = 3;
    public static final String EXT_TAR_GZ = ".tar.gz";
    public static final String EXT_TGZ = ".tgz";
    public static final String EXT_ZIP = ".zip";
    private static List<String> supportedArchiveExtension = Arrays.asList(".tar.gz", ".tgz", ".zip");
    String name;
    String version;
    String repositoryPath;
    long size;
    String checksum;
    String installpath = "./";
    String classifier = null;
    boolean unpack = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getGroup() {
        int end = this.repositoryPath.length();
        for (int i = 0; i < 3 && end != -1; ++i) {
            end = this.repositoryPath.lastIndexOf(47, end - 1);
        }
        String group = null;
        if (end != -1) {
            group = this.repositoryPath.substring(0, end).replace('/', '.');
        }
        return group;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getInstallpath() {
        return this.installpath;
    }

    public void setInstallpath(String installpath) {
        this.installpath = installpath;
    }

    public boolean isUnpack() {
        return this.unpack;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public void applyOverride(PartOverride override) {
        if (override.name.equals(this.name) && (override.group == null || override.group.equals(this.getGroup())) && (override.classifier == null || override.classifier.equals(this.classifier))) {
            System.out.println("applyOverride " + override.toString());
            InstallerState.log.debug("applyOverride", override.toString());
            if (override.version != null) {
                this.repositoryPath = this.repositoryPath.replace(this.version, override.version);
                this.version = override.version;
                this.size = 0L;
                this.checksum = null;
            }
            if (override.repositoryPath != null) {
                this.repositoryPath = override.repositoryPath;
                this.size = 0L;
                this.checksum = null;
            }
            if (override.installPath != null) {
                this.installpath = override.installPath;
            }
        }
    }

    public void install(AbstractExternalRepository aeRepo, String userInstallDir, String installablePath) throws ExternalRepositoryException, IOException, UnsupportedArchiveException {
        String destDir = userInstallDir + File.separator + installablePath + File.separator + this.installpath;
        int retries = 0;
        while (true) {
            try {
                this.install(aeRepo, destDir);
                return;
            }
            catch (ExternalRepositoryAuthorizationException a) {
                throw a;
            }
            catch (IOException | ExternalRepositoryException e) {
                if (retries < 3) {
                    InstallerState.log.debug("Install Part", "Error installing " + this.getName() + ". Attempt: " + String.valueOf(++retries) + "\nException Message:\n" + e.getMessage() + "\n");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void install(AbstractExternalRepository aeRepo, String destDir) throws ExternalRepositoryException, IOException, UnsupportedArchiveException {
        RepositoryInputStream is = null;
        try {
            File f = new File(this.repositoryPath);
            is = f.isAbsolute() ? new RepositoryInputStream(new FileInputStream(f)) : aeRepo.getRepositoryFileAsStream(this.repositoryPath);
            if (!this.unpack) {
                String fileName = this.repositoryPath.substring(this.repositoryPath.lastIndexOf(47) + 1);
                Part.extractFile(is, destDir + File.separator + fileName);
            } else if (this.repositoryPath.endsWith(EXT_TAR_GZ) || this.repositoryPath.endsWith(EXT_TGZ)) {
                Part.unpackTGZ(is, destDir);
            } else if (this.repositoryPath.endsWith(EXT_ZIP)) {
                Part.unpackZIP(is, destDir);
            } else {
                String message = "The archive file format of " + this.repositoryPath + " is unsupported.";
                throw new UnsupportedArchiveException(message);
            }
            is.close();
            if (this.getSize() != 0L && is.getByteCount() != this.getSize()) {
                String message = "size mismatch for " + this.repositoryPath + ", expected: " + this.getSize() + " read: " + is.getByteCount();
                InstallerState.log.error("install part", message);
            }
            if (!InstallerState.noChecksum && this.getChecksum() != null) {
                String computedChecksum = is.getChecksum();
                if (!this.getChecksum().equalsIgnoreCase(computedChecksum)) {
                    String message = "checksum mismatch for " + this.repositoryPath + ", expected: " + this.getChecksum() + " computed: " + computedChecksum;
                    InstallerState.log.error("install part", message);
                    throw new ExternalRepositoryException(message);
                }
            }
        }
        catch (IOException e) {
            if (is != null) {
                is.close();
                is = null;
            }
            InstallerState.log.debug("Part.install() error:", e.getMessage());
            throw e;
        }
    }

    public static void unpackTGZ(InputStream is, String destDir) throws IOException {
        GzipCompressorInputStream gzipIn = new GzipCompressorInputStream(is);
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream(gzipIn);){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                if (entry.getName().startsWith("vers/")) continue;
                String filePath = destDir + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    Part.extractFile(tarIn, filePath);
                    continue;
                }
                Part.createDir(filePath);
            }
        }
        catch (IOException e) {
            InstallerState.log.debug("Part.unpackTGZ() error:", e.getMessage());
            throw e;
        }
    }

    public static void unpackZIP(InputStream is, String destDir) throws IOException {
        ZipInputStream zipIn = null;
        try {
            ZipEntry entry;
            zipIn = new ZipInputStream(is);
            while ((entry = zipIn.getNextEntry()) != null) {
                if (!entry.getName().startsWith("vers/")) {
                    String filePath = destDir + File.separator + entry.getName();
                    if (!entry.isDirectory()) {
                        Part.extractFile(zipIn, filePath);
                    } else {
                        Part.createDir(filePath);
                    }
                }
                zipIn.closeEntry();
            }
        }
        catch (IOException e) {
            InstallerState.log.debug("Part.unpackZIP() error:", e.getMessage());
            throw e;
        }
    }

    public static void createDir(String destPath) {
        File targetPath = new File(destPath);
        targetPath.mkdirs();
    }

    public static void extractFile(InputStream is, String destFilePath) throws IOException {
        try {
            File targetFile = new File(destFilePath);
            File parent = targetFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IllegalStateException(InstallerState.LOCALIZED_PART_CREATEFAIL + parent);
            }
            InstallerState.log.debug("Extracting file", targetFile.getCanonicalPath());
            Path path = Paths.get(destFilePath, new String[0]);
            Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            InstallerState.log.debug("Part.extractFile() error:", e.getMessage());
            throw e;
        }
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public static boolean archiveFormatSupported(String archiveExtenstionWithDot) {
        boolean bSuported = false;
        if (supportedArchiveExtension.contains(archiveExtenstionWithDot)) {
            bSuported = true;
        }
        return bSuported;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.installpath == null ? 0 : this.installpath.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.repositoryPath == null ? 0 : this.repositoryPath.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.unpack ? 1231 : 1237);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Part)) {
            return false;
        }
        Part other = (Part)obj;
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.installpath == null ? other.installpath != null : !this.installpath.equals(other.installpath)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.repositoryPath == null ? other.repositoryPath != null : !this.repositoryPath.equals(other.repositoryPath)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.unpack != other.unpack) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

