/*
 * Decompiled with CFR 0.152.
 */
package repository;

import core.InstallerState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import repository.CachingInputStream;
import repository.ExternalRepositoryException;
import repository.ExternalRepositoryFile;
import repository.ExternalRepositoryGroup;
import repository.ExternalRepositoryHTTP;
import repository.ExternalRepositoryNexus3;
import repository.ExternalRepositoryUnsupportedException;
import repository.ExternalRepositoryZipFile;
import repository.FileInfo;
import repository.RepositoryInputStream;

public abstract class AbstractExternalRepository {
    protected static final String EXT_JSON = ".json";
    protected static final String BACKSLASH = "\\";
    protected static final String FORWARD_SLASH = "/";
    public static final String MANIFESTS_DIR = "manifest/";
    private final String IDS_CLIENT_MANIFEST = "caclient";
    private final String IDS_SERVER_MANIFEST = "server";
    private final String IDS_SRV_MANIFEST = "casrv";
    private final String IDS_WINDOWS = "win";
    private final String IDS_LINUXI386 = "linuxi386";
    private final String IDS_LINUXPPC = "linuxppc";
    private final String IDS_LINUXPLE = "linuxple";
    private final String IDS_LINUXZ = "zlinux";
    private final String IDS_AIX = "aix";
    protected URL baseURL;
    protected String baseURLFile;
    protected final List<String> manifestPaths = new ArrayList<String>();
    protected final List<String> listLatestManifest = new ArrayList<String>();
    protected String strCurrentPlaform = "";
    private Map<String, List<String>> listDirCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> mapManifest = new HashMap<String, List<String>>();

    protected AbstractExternalRepository() {
    }

    protected AbstractExternalRepository(URL url) throws ExternalRepositoryException {
        this.open(url);
    }

    protected void open(URL url) throws ExternalRepositoryException {
        InstallerState.log.debug(this.getClass().getName() + " open", url.toString());
        if (!this.isSupported(url)) {
            throw new ExternalRepositoryUnsupportedException(url.toString());
        }
        this.SetCurrentPlatform();
        this.baseURL = this.validateURL(url);
        this.baseURLFile = this.getFileFromURL(this.baseURL);
        this.validateRepository();
        this.SetLatestManifests();
    }

    private void SetLatestManifests() {
        for (Map.Entry<String, List<String>> entry : this.mapManifest.entrySet()) {
            List<String> listManifest = entry.getValue();
            Collections.sort(listManifest);
            this.listLatestManifest.add(listManifest.get(listManifest.size() - 1));
        }
    }

    public List<String> GetLatestManifests() {
        return this.listLatestManifest;
    }

    public static AbstractExternalRepository factory(URL ... urls) throws ExternalRepositoryException {
        InstallerState.log.debug("Repository factory.", Arrays.toString(urls));
        switch (urls.length) {
            case 0: {
                throw new ExternalRepositoryException(InstallerState.LOCALIZED_REPOSITORY_REPOURL);
            }
            case 1: {
                return AbstractExternalRepository.createRepository(urls[0]);
            }
        }
        return new ExternalRepositoryGroup(urls);
    }

    public static AbstractExternalRepository factory(String specification) throws ExternalRepositoryException {
        InstallerState.log.debug("Repository factory (string)", specification);
        String[] parts = specification.split(",");
        URL[] urls = new URL[parts.length];
        try {
            for (int i = 0; i < parts.length; ++i) {
                urls[i] = parts[i].indexOf("://") != -1 ? new URL(parts[i]) : new File(parts[i]).toURL();
            }
            return AbstractExternalRepository.factory(urls);
        }
        catch (MalformedURLException e) {
            InstallerState.log.error("factory", "Invalid repository specification " + specification);
            throw new ExternalRepositoryException(InstallerState.LOCALIZED_REPOSITORY_INVALIDREPOSPEC + e.getMessage());
        }
    }

    protected static AbstractExternalRepository createRepository(URL url) throws ExternalRepositoryException {
        Class[] repositoryClasses;
        InstallerState.log.debug("Create repository ", url.toString());
        for (Class c : repositoryClasses = new Class[]{ExternalRepositoryNexus3.class, ExternalRepositoryHTTP.class, ExternalRepositoryZipFile.class, ExternalRepositoryFile.class}) {
            try {
                AbstractExternalRepository repo = (AbstractExternalRepository)c.newInstance();
                if (!repo.isSupported(url)) continue;
                repo.open(url);
                InstallerState.log.debug("Create repository", "Repository type " + repo.getClass().getName());
                return repo;
            }
            catch (Exception e) {
                InstallerState.log.debug("Create repository", e.getLocalizedMessage() + ".", "Verify that this is a valid repository.");
                throw new ExternalRepositoryException(e.getLocalizedMessage());
            }
        }
        throw new ExternalRepositoryUnsupportedException(url.toString());
    }

    protected void validateRepository() throws ExternalRepositoryException {
        for (String manifestType : this.listDir(MANIFESTS_DIR)) {
            if (!manifestType.endsWith(FORWARD_SLASH)) continue;
            for (String manifestVersion : this.listVersionDir(manifestType)) {
                if (!manifestVersion.endsWith(FORWARD_SLASH)) continue;
                for (String manifestFile : this.listDir(manifestVersion)) {
                    if (!manifestFile.endsWith(EXT_JSON)) continue;
                    InstallerState.log.debug("found manifest in repository", manifestFile);
                    this.manifestPaths.add(manifestFile);
                    this.UpdateManifestMap(manifestFile);
                }
            }
        }
        if (this.manifestPaths.isEmpty()) {
            InstallerState.log.debug("Validate Repository ", "No manifests in repository.", "You must use a repository with at least one manifest.");
            throw new ExternalRepositoryException(InstallerState.LOCALIZED_REPOSITORY_NOMANIFEST);
        }
    }

    protected List<String> listVersionDir(String manifestType) throws ExternalRepositoryException {
        List<String> versionItems = this.listDir(manifestType);
        Collections.sort(versionItems, Collections.reverseOrder());
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        for (String version : versionItems) {
            if (i++ >= 2) break;
            items.add(version);
        }
        return items;
    }

    private void UpdateManifestMap(String manifestFile) {
        String[] strFolders = manifestFile.split(FORWARD_SLASH);
        String strkey = strFolders[1].toLowerCase();
        if (this.IsCurrentPlatformManifest(manifestFile)) {
            List<String> listManifest = new ArrayList<String>();
            if (this.mapManifest.get(strkey) != null) {
                listManifest = this.mapManifest.get(strkey);
            }
            listManifest.add(manifestFile);
            this.mapManifest.put(strkey, listManifest);
        }
    }

    private boolean IsCurrentPlatformManifest(String strManifest) {
        File file = new File(strManifest);
        String strManifestFileName = file.getName().toLowerCase();
        return strManifestFileName.contains(this.GetCurrentPlatform());
    }

    public List<String> getManifestPaths() {
        return this.manifestPaths;
    }

    public String findManifest(String strManifestName) throws ExternalRepositoryException {
        InstallerState.log.debug("find manifest", strManifestName);
        strManifestName = strManifestName.replace(BACKSLASH, FORWARD_SLASH);
        String rc = null;
        for (String strManifest : this.manifestPaths) {
            if (!strManifest.endsWith(strManifestName)) continue;
            rc = strManifest;
        }
        if (rc == null) {
            rc = this.locateManifest(strManifestName);
        }
        if (rc != null) {
            InstallerState.log.debug("found manifest", rc);
        } else {
            InstallerState.log.debug("unable to locate manifest ", strManifestName);
        }
        return rc;
    }

    public String getRepositoryFileAsString(String repositoryFile) throws ExternalRepositoryException {
        RepositoryInputStream is = this.getRepositoryFileAsStream(repositoryFile);
        String text = null;
        try (Scanner scanner = new Scanner((InputStream)is, StandardCharsets.UTF_8.name());){
            text = scanner.useDelimiter("\\A").next();
        }
        catch (Exception e) {
            throw new ExternalRepositoryException(e.getMessage());
        }
        return text;
    }

    public boolean getRepositoryFile(String repositoryFile, File localFile, boolean overwrite) throws ExternalRepositoryException {
        boolean rc = false;
        RepositoryInputStream is = this.getRepositoryFileAsStream(repositoryFile);
        try {
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            rc = overwrite ? Files.copy(is, localFile.toPath(), StandardCopyOption.REPLACE_EXISTING) != 0L : Files.copy(is, localFile.toPath(), new CopyOption[0]) != 0L;
        }
        catch (IOException e) {
            InstallerState.log.error("Get Repository File", "Cannot write to file " + repositoryFile, "Verify that the target directory is writable and the disk is not full.");
            throw new ExternalRepositoryException(InstallerState.LOCALIZED_REPOSITORY_WRITEFILE + repositoryFile);
        }
        return rc;
    }

    public String normalizeRepositoryPath(String path) {
        String result = path.replace(BACKSLASH, FORWARD_SLASH);
        if (result.startsWith(this.baseURL.toString())) {
            result = result.substring(this.baseURL.toString().length());
        } else if (result.startsWith(this.baseURLFile)) {
            result = result.substring(this.baseURLFile.length());
        }
        if (result.startsWith(FORWARD_SLASH)) {
            result = result.substring(1);
        }
        return result;
    }

    protected String getFileFromURL(URL url) {
        return url.getFile();
    }

    public URL getUrl() {
        return this.baseURL;
    }

    protected URL makeURLADirectory(URL url) throws ExternalRepositoryException {
        if (!url.toString().endsWith(FORWARD_SLASH)) {
            try {
                return new URL(url.toString() + FORWARD_SLASH);
            }
            catch (MalformedURLException e) {
                throw new ExternalRepositoryException(e.getLocalizedMessage());
            }
        }
        return url;
    }

    public List<String> listDir(String folder) throws ExternalRepositoryException {
        if (!this.listDirCache.containsKey(folder)) {
            this.listDirCache.put(folder, this.listDirImpl(folder));
        }
        return this.listDirCache.get(folder);
    }

    protected abstract boolean isSupported(URL var1);

    protected abstract URL validateURL(URL var1) throws ExternalRepositoryException;

    public abstract List<String> listDirImpl(String var1) throws ExternalRepositoryException;

    public Map<String, FileInfo> listDirWithFileInfo(String folder) throws ExternalRepositoryException {
        return null;
    }

    public RepositoryInputStream getRepositoryFileAsStream(String repositoryFile) throws ExternalRepositoryException {
        InputStream source;
        if (InstallerState.cacheDir != null && !repositoryFile.endsWith(FORWARD_SLASH)) {
            try {
                source = CachingInputStream.getCachedStream(InstallerState.cacheDir, repositoryFile);
            }
            catch (IOException e) {
                source = null;
            }
            if (source == null) {
                source = new CachingInputStream(this.getRepositoryFileAsStreamImpl(repositoryFile), InstallerState.cacheDir, repositoryFile);
            }
        } else {
            source = this.getRepositoryFileAsStreamImpl(repositoryFile);
        }
        return new RepositoryInputStream(source);
    }

    public abstract InputStream getRepositoryFileAsStreamImpl(String var1) throws ExternalRepositoryException;

    public void close() {
    }

    public abstract long getRepositoryFileSize(String var1);

    private void SetCurrentPlatform() {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        os = os.toLowerCase();
        arch = arch.toLowerCase();
        if (os.indexOf("win") != -1) {
            this.strCurrentPlaform = "win";
        } else if (os.indexOf("linux") != -1 && (arch.indexOf("amd64") != -1 || arch.indexOf("x86") != -1)) {
            this.strCurrentPlaform = "linuxi386";
        } else if (os.indexOf("linux") != -1 && arch.indexOf("ppc64le") != -1) {
            this.strCurrentPlaform = "linuxple";
        } else if (os.indexOf("linux") != -1 && arch.indexOf("ppc64") != -1) {
            this.strCurrentPlaform = "linuxppc";
        } else if (os.indexOf("linux") != -1 && arch.indexOf("s390x") != -1) {
            this.strCurrentPlaform = "zlinux";
        } else if (os.indexOf("aix") != -1) {
            this.strCurrentPlaform = "aix";
        }
        InstallerState.log.debug("detected platform", this.strCurrentPlaform);
    }

    private CharSequence GetCurrentPlatform() {
        return this.strCurrentPlaform;
    }

    public String locateManifest(String manifest) throws ExternalRepositoryException {
        String ret = null;
        if (manifest.contains(FORWARD_SLASH) && this.artifactExists(manifest)) {
            ret = manifest;
        } else {
            String fullPath = this.reconstructManifestPath(manifest);
            if (fullPath != null && this.artifactExists(fullPath)) {
                ret = fullPath;
            }
        }
        return ret;
    }

    public String reconstructManifestPath(String manifestName) {
        String[] arr = manifestName.split("-");
        if (arr.length != 5) {
            return null;
        }
        String fullPathedManifest = MANIFESTS_DIR + arr[0] + "-" + arr[1] + FORWARD_SLASH + arr[2] + "-" + arr[3] + FORWARD_SLASH + manifestName;
        return fullPathedManifest;
    }

    public boolean artifactExists(String fullPath) throws ExternalRepositoryException {
        boolean ret = false;
        int i = fullPath.lastIndexOf(FORWARD_SLASH);
        int length = fullPath.length();
        if (i != 0 && i != length - 1) {
            String parent = fullPath.substring(0, i);
            String file = fullPath.substring(i + 1, length);
            Map<String, FileInfo> nameFileInfoMap = this.listDirWithFileInfo(parent);
            ret = nameFileInfoMap.containsKey(file);
        }
        return ret;
    }
}

