/*
 * Decompiled with CFR 0.152.
 */
package repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import repository.ExternalRepositoryException;

public class CachingInputStream
extends InputStream {
    private final InputStream is;
    private final OutputStream os;
    private final File cacheFile;

    public static InputStream getCachedStream(File cacheDir, String repositoryPath) throws IOException {
        File f = CachingInputStream.makeCacheFile(cacheDir, repositoryPath);
        return f.exists() ? new FileInputStream(f) : null;
    }

    public CachingInputStream(InputStream source, File cacheDir, String repositoryPath) throws ExternalRepositoryException {
        this.cacheFile = CachingInputStream.makeCacheFile(cacheDir, repositoryPath);
        try {
            if (!this.cacheFile.getParentFile().exists()) {
                this.cacheFile.getParentFile().mkdirs();
            }
            this.is = source;
            this.os = new FileOutputStream(this.cacheFile);
        }
        catch (FileNotFoundException e) {
            throw new ExternalRepositoryException(e.getMessage());
        }
    }

    private static File makeCacheFile(File cacheDir, String repositoryPath) {
        return new File(cacheDir, repositoryPath);
    }

    @Override
    public int read() throws IOException {
        int b = this.is.read();
        if (b != -1) {
            this.os.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rc = this.is.read(b, off, len);
        if (rc != -1) {
            this.os.write(b, off, rc);
        }
        return rc;
    }

    @Override
    public void close() throws IOException {
        this.os.flush();
        this.os.close();
    }

    public File getCacheFile() {
        return this.cacheFile;
    }
}

