/*
 * Decompiled with CFR 0.152.
 */
package repository;

import core.InstallerState;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import repository.AbstractExternalRepository;
import repository.ExternalRepositoryException;

public class ExternalRepositoryFile
extends AbstractExternalRepository {
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");

    ExternalRepositoryFile() {
    }

    ExternalRepositoryFile(URL repositoryBaseURL) throws ExternalRepositoryException {
        super(repositoryBaseURL);
    }

    @Override
    protected boolean isSupported(URL url) {
        return url.getProtocol().equals("file");
    }

    @Override
    protected URL validateURL(URL url) throws ExternalRepositoryException {
        if (!new File(this.getLocalFileFromURL(url = this.makeURLADirectory(url))).exists()) {
            throw new ExternalRepositoryException(url.toString() + " " + InstallerState.LOCALIZED_EXTERNALREPOSITORYFILE_NOTEXISTS);
        }
        if (!new File(this.getLocalFileFromURL(url)).isDirectory()) {
            throw new ExternalRepositoryException(url.toString() + " " + InstallerState.LOCALIZED_EXTERNALREPOSITORYFILE_INVALIDDIR);
        }
        return url;
    }

    @Override
    public List<String> listDirImpl(String folder) throws ExternalRepositoryException {
        ArrayList<String> items = new ArrayList<String>();
        File dir = new File(this.getLocalFileFromURL(this.baseURL), this.localizeRepositoryPath(folder));
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                String item = this.normalizeRepositoryPath(file.toString());
                if (file.isDirectory()) {
                    item = item + "/";
                }
                items.add(item);
            }
        }
        return items;
    }

    @Override
    public InputStream getRepositoryFileAsStreamImpl(String repositoryFile) throws ExternalRepositoryException {
        try {
            return new FileInputStream(new File(this.getLocalFileFromURL(this.baseURL), this.localizeRepositoryPath(repositoryFile)));
        }
        catch (IOException e) {
            throw new ExternalRepositoryException(e.getMessage());
        }
    }

    protected String getLocalFileFromURL(URL url) {
        String result = this.getFileFromURL(url).replace("/", File.separator);
        return result;
    }

    @Override
    protected String getFileFromURL(URL url) {
        String result = url.getFile();
        if (isWindows && result.indexOf(58) == 2) {
            result = result.substring(1);
        }
        return result;
    }

    protected String localizeRepositoryPath(String path) {
        return this.normalizeRepositoryPath(path).replace("/", File.separator);
    }

    @Override
    public long getRepositoryFileSize(String repositoryFile) {
        long rc = -1L;
        File f = new File(this.getLocalFileFromURL(this.baseURL), this.localizeRepositoryPath(repositoryFile));
        if (f.exists()) {
            rc = f.length();
        }
        return rc;
    }
}

