/*
 * Decompiled with CFR 0.152.
 */
package repository;

import core.InstallerState;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import repository.AbstractExternalRepository;
import repository.ExternalRepositoryException;

public class ExternalRepositoryGroup
extends AbstractExternalRepository {
    private final List<AbstractExternalRepository> repositories = new ArrayList<AbstractExternalRepository>();

    protected ExternalRepositoryGroup(URL ... urls) throws ExternalRepositoryException {
        for (URL url : urls) {
            this.repositories.add(ExternalRepositoryGroup.createRepository(url));
        }
    }

    @Override
    protected boolean isSupported(URL url) {
        return true;
    }

    @Override
    public void validateRepository() throws ExternalRepositoryException {
    }

    @Override
    public List<String> getManifestPaths() {
        ArrayList<String> results = new ArrayList<String>();
        for (AbstractExternalRepository repository : this.repositories) {
            for (String item : repository.getManifestPaths()) {
                if (results.contains(item)) continue;
                results.add(item);
            }
        }
        return results;
    }

    @Override
    public List<String> listDirImpl(String folder) throws ExternalRepositoryException {
        ArrayList<String> results = new ArrayList<String>();
        for (AbstractExternalRepository repository : this.repositories) {
            for (String item : repository.listDir(folder)) {
                if (results.contains(item)) continue;
                results.add(item);
            }
        }
        return results;
    }

    @Override
    public InputStream getRepositoryFileAsStreamImpl(String repositoryFile) throws ExternalRepositoryException {
        for (AbstractExternalRepository repository : this.repositories) {
            try {
                return repository.getRepositoryFileAsStreamImpl(repositoryFile);
            }
            catch (Exception exception) {
            }
        }
        throw new ExternalRepositoryException(InstallerState.LOCALIZED_EXTERNALREPOSITORYGROUP_LOADFILEFAIL + repositoryFile.toString());
    }

    @Override
    protected URL validateURL(URL url) throws ExternalRepositoryException {
        throw new ExternalRepositoryException(InstallerState.LOCALIZED_EXTERNALREPOSITORYGROUP_VALIDATEURLFAIL);
    }

    @Override
    public long getRepositoryFileSize(String repositoryFile) {
        long rc = -1L;
        for (AbstractExternalRepository repository : this.repositories) {
            try {
                rc = repository.getRepositoryFileSize(repositoryFile);
                if (rc <= 0L) continue;
                return rc;
            }
            catch (Exception exception) {
            }
        }
        return rc;
    }

    @Override
    public void close() {
        for (AbstractExternalRepository repository : this.repositories) {
            try {
                repository.close();
            }
            catch (Exception exception) {}
        }
    }
}

