/*
 * Decompiled with CFR 0.152.
 */
package repository;

import core.InstallerState;
import core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import repository.AbstractExternalRepository;
import repository.ExternalRepositoryAuthorizationException;
import repository.ExternalRepositoryException;
import repository.FileInfo;
import repository.Netrc;

public class ExternalRepositoryHTTP
extends AbstractExternalRepository {
    private static final String NBSP_ClEANER = "\\u00A0";
    private String basicAuth;
    private Map<String, Map<String, FileInfo>> lisDirWithFileInfoCache = new HashMap<String, Map<String, FileInfo>>();
    private static Map<String, String> serverHeaderFieldCache = new HashMap<String, String>();

    ExternalRepositoryHTTP() {
    }

    ExternalRepositoryHTTP(URL repositoryBaseURL) throws ExternalRepositoryException {
        super(repositoryBaseURL);
    }

    @Override
    protected boolean isSupported(URL url) {
        return url.getProtocol().startsWith("http");
    }

    @Override
    protected URL validateURL(URL url) throws ExternalRepositoryException {
        block8: {
            url = this.makeURLADirectory(url);
            try {
                String userInfo = url.getUserInfo();
                if (userInfo != null) {
                    throw new ExternalRepositoryException("User info is not supported in the repository URL. Use a netrc file or the ANALYTICS_INSTALLER_USER and ANALYTICS_INSTALLER_PASSWORD environment variables instead.");
                }
                try {
                    this.getStreamFromURL(url).close();
                }
                catch (Exception e) {
                    if (this.basicAuth == null) {
                        Netrc netrc = new Netrc();
                        if (netrc.readCredentials(url.getHost())) {
                            InstallerState.log.debug("validateURL", "Using credentials from netrc file.");
                            this.setBasicAuth(netrc.getUser() + ":" + netrc.getPassword());
                            this.getStreamFromURL(url).close();
                        }
                        break block8;
                    }
                    throw e;
                }
            }
            catch (ExternalRepositoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalRepositoryException(e.getMessage());
            }
        }
        return url;
    }

    private void setBasicAuth(String userInfo) throws Exception {
        String auth = URLDecoder.decode(userInfo, "utf-8");
        this.basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])auth.getBytes());
    }

    @Override
    public List<String> listDirImpl(String folder) throws ExternalRepositoryException {
        String html;
        Document doc;
        Element table;
        InstallerState.log.debug("list", folder);
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        Elements links = (table = (doc = Jsoup.parse(html = this.getRepositoryFileAsString(folder), "UTF-8")).select("table").first()) != null ? table.select("a[href]") : doc.select("a[href]");
        ArrayList<String> items = new ArrayList<String>();
        for (Element link : links) {
            String text;
            String href = this.cleanItem(link.attr("href"));
            if (!href.equals(text = this.cleanItem(link.text())) || text.contains("..") || text.startsWith("maven-metadata.xml")) continue;
            if (link.attr("href").endsWith("/") || link.text().endsWith("/")) {
                text = text + "/";
            }
            items.add(folder + text);
        }
        return items;
    }

    @Override
    public Map<String, FileInfo> listDirWithFileInfo(String folder) throws ExternalRepositoryException {
        InstallerState.log.debug("listLeafDirWithFileInfo", folder);
        if (!this.lisDirWithFileInfoCache.containsKey(folder)) {
            String html;
            Document doc;
            Element table;
            HashMap<String, FileInfo> nameFileInfoMap = new HashMap<String, FileInfo>();
            if (!folder.endsWith("/")) {
                folder = folder + "/";
            }
            Elements rows = (table = (doc = Jsoup.parse(html = this.getRepositoryFileAsString(folder), "UTF-8")).select("table").first()) != null ? table.select("tr") : doc.select("a");
            ArrayList<String> items = new ArrayList<String>();
            for (int row = 0; row < rows.size(); ++row) {
                items.add(((Element)rows.get(row)).toString());
            }
            String manifestName = "";
            for (String item : items) {
                manifestName = Utility.getValueByPattern("<a[^>]*>(.*?)</a>", item, 1);
                if (manifestName == null || manifestName.isEmpty() || !manifestName.endsWith(".json")) continue;
                FileInfo fileInfo = new FileInfo();
                fileInfo.setName(manifestName);
                fileInfo.setFile(false);
                nameFileInfoMap.put(manifestName, fileInfo);
            }
            this.lisDirWithFileInfoCache.put(folder, nameFileInfoMap);
        }
        return this.lisDirWithFileInfoCache.get(folder);
    }

    private String cleanItem(String text) {
        int i;
        String result = text.replaceAll(NBSP_ClEANER, "");
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        if ((i = result.lastIndexOf("/")) != 1) {
            result = result.substring(i + 1);
        }
        return result;
    }

    @Override
    public InputStream getRepositoryFileAsStreamImpl(String repositoryFile) throws ExternalRepositoryException {
        try {
            URL url = new URL(this.baseURL + this.normalizeRepositoryPath(repositoryFile));
            return this.getStreamFromURL(url);
        }
        catch (ExternalRepositoryException r) {
            throw r;
        }
        catch (Exception e) {
            throw new ExternalRepositoryException(e.getMessage());
        }
    }

    public InputStream getStreamFromURL(URL url) throws ExternalRepositoryException {
        URLConnection uc;
        try {
            uc = url.openConnection();
        }
        catch (Exception e) {
            InstallerState.log.error("getStreamFromURL", url + " " + e.getLocalizedMessage(), "Please verify the url and connectivity.");
            throw new ExternalRepositoryException(e.getLocalizedMessage());
        }
        if (this.basicAuth != null) {
            uc.setRequestProperty("Authorization", this.basicAuth);
        }
        try {
            return uc.getInputStream();
        }
        catch (IOException e) {
            int rc;
            try {
                rc = ((HttpURLConnection)uc).getResponseCode();
            }
            catch (Exception erc) {
                rc = 0;
            }
            InstallerState.log.debug("openInputStream", String.valueOf(rc) + " " + e.getLocalizedMessage(), "Please verify the url and connectivity.");
            if (rc == 401) {
                throw new ExternalRepositoryAuthorizationException(e.getLocalizedMessage(), rc);
            }
            throw new ExternalRepositoryException(e.getLocalizedMessage(), rc);
        }
    }

    public static String getServerHeaderField(URL url) throws IOException {
        String server = serverHeaderFieldCache.get(url.toString());
        if (server == null) {
            server = url.openConnection().getHeaderField("Server");
            serverHeaderFieldCache.put(url.toString(), server);
        }
        return server;
    }

    @Override
    public long getRepositoryFileSize(String repositoryFile) {
        long rc = -1L;
        try {
            URL url = new URL(this.baseURL + this.normalizeRepositoryPath(repositoryFile));
            URLConnection uc = url.openConnection();
            if (this.basicAuth != null) {
                uc.setRequestProperty("Authorization", this.basicAuth);
            }
            uc.setRequestProperty("Connection", "Close");
            ((HttpURLConnection)uc).setRequestMethod("HEAD");
            rc = ((HttpURLConnection)uc).getResponseCode();
            rc = rc == 200L ? uc.getContentLengthLong() : -1L;
            ((HttpURLConnection)uc).disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }
}

