/*
 * Decompiled with CFR 0.152.
 */
package repository;

import core.InstallerState;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import repository.ExternalRepositoryException;
import repository.ExternalRepositoryHTTP;
import repository.ManifestHint;

public class ExternalRepositoryNexus3
extends ExternalRepositoryHTTP {
    private static final String NEXUS_REPOSITORY = "/repository/";
    private static final String NEXUS_BROWSE = "/service/rest/repository/browse/";
    private static final String MANIFEST_ROOT = "manifest/";
    private static final String MANIFEST_FOLDER_MATCHER = "^manifest\\/$";
    private static final String MANIFEST_TYPE_MATCHER = "^manifest\\/[^\\/]*\\/$";
    private static final String MANIFEST_TYPE_VERSION_MATCHER = "^manifest\\/[^\\/]*\\/[^\\/]*\\/$";
    private static final String MAVEN_METADATA = "maven-metadata.xml";
    private static final String DASH = "-";
    private static final String EXT_SHA1 = ".sha1";

    ExternalRepositoryNexus3() {
    }

    ExternalRepositoryNexus3(URL repositoryBaseURL) throws ExternalRepositoryException {
        super(repositoryBaseURL);
    }

    @Override
    protected boolean isSupported(URL url) {
        boolean rc = super.isSupported(url);
        try {
            String server = ExternalRepositoryNexus3.getServerHeaderField(url);
            boolean bl = rc = rc && server.contains("Nexus/3");
            if (!rc) {
                InstallerState.log.debug("isSupported", "This REPO is a " + server + ", which is not supported. Only Nexus/3 REPO is suported.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public List<String> listDirImpl(String folder) throws ExternalRepositoryException {
        List<String> items = InstallerState.manifestHints == null ? super.listDirImpl(folder) : this.listDirWithHints(folder);
        return items;
    }

    public List<String> listDirWithHints(String folder) throws ExternalRepositoryException {
        List<String> items;
        block9: {
            block11: {
                block10: {
                    try {
                        items = super.listDirImpl(folder);
                    }
                    catch (ExternalRepositoryException e) {
                        items = new ArrayList<String>();
                    }
                    if (InstallerState.manifestHints == null) break block9;
                    if (!folder.matches(MANIFEST_FOLDER_MATCHER)) break block10;
                    for (ManifestHint hint : InstallerState.manifestHints) {
                        String item = folder + hint.name + "/";
                        if (items.contains(item)) continue;
                        items.add(item);
                    }
                    break block9;
                }
                if (!folder.matches(MANIFEST_TYPE_MATCHER)) break block11;
                try {
                    String xml = this.getRepositoryFileAsString(folder + MAVEN_METADATA);
                    Document doc = Jsoup.parse(xml, "UTF-8");
                    for (Element link : doc.getElementsByTag("version")) {
                        String item = folder + link.text() + "/";
                        if (items.contains(item)) continue;
                        items.add(item);
                    }
                }
                catch (ExternalRepositoryException externalRepositoryException) {}
                break block9;
            }
            if (!folder.matches(MANIFEST_TYPE_VERSION_MATCHER)) break block9;
            for (ManifestHint hint : InstallerState.manifestHints) {
                if (!folder.contains("/" + hint.name + "/")) continue;
                String version = folder.split("/")[2];
                String item = folder + hint.name + DASH + version + DASH + hint.classifier + ".json";
                if (items.contains(item)) continue;
                try {
                    String sha1 = this.getRepositoryFileAsString(item + EXT_SHA1);
                    if (sha1.isEmpty()) continue;
                    items.add(item);
                }
                catch (ExternalRepositoryException externalRepositoryException) {}
            }
        }
        return items;
    }

    @Override
    public InputStream getStreamFromURL(URL url) throws ExternalRepositoryException {
        try {
            String text = url.toString();
            if (text.endsWith("/")) {
                text = text.replace(NEXUS_REPOSITORY, NEXUS_BROWSE);
                url = new URL(text);
            }
            return super.getStreamFromURL(url);
        }
        catch (MalformedURLException e) {
            throw new ExternalRepositoryException(e.getMessage());
        }
    }
}

