/*
 * Decompiled with CFR 0.152.
 */
package repository;

import core.InstallerState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import repository.ExternalRepositoryException;
import repository.ExternalRepositoryFile;

public class ExternalRepositoryZipFile
extends ExternalRepositoryFile {
    protected static final String ZIP_EXT = ".zip";
    ZipFile archive;
    File archiveFile;

    ExternalRepositoryZipFile() {
    }

    ExternalRepositoryZipFile(URL url) throws ExternalRepositoryException {
        super(url);
    }

    @Override
    protected boolean isSupported(URL url) {
        return super.isSupported(url) && url.toString().endsWith(ZIP_EXT);
    }

    @Override
    protected URL validateURL(URL url) throws ExternalRepositoryException {
        this.archiveFile = new File(this.getLocalFileFromURL(url));
        if (!this.archiveFile.exists()) {
            throw new ExternalRepositoryException(url + " " + InstallerState.LOCALIZED_EXTERNALREPOSITORYFILE_NOTEXISTS);
        }
        if (!this.archiveFile.isFile()) {
            throw new ExternalRepositoryException(url + " " + InstallerState.LOCALIZED_EXTERNALREPOSITORYZIP_NOTAFILE);
        }
        try {
            this.archive = new ZipFile(this.archiveFile);
        }
        catch (IOException e) {
            throw new ExternalRepositoryException(url + " " + InstallerState.LOCALIZED_EXTERNALREPOSITORYZIP_NOTAZIPFILE);
        }
        return url;
    }

    @Override
    public List<String> listDirImpl(String folder) throws ExternalRepositoryException {
        ArrayList<String> items = new ArrayList<String>();
        Enumeration<ZipArchiveEntry> entries = this.archive.getEntries();
        while (entries.hasMoreElements()) {
            String item;
            ZipArchiveEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(item = this.normalizeRepositoryPath(entry.getName())).startsWith(folder)) continue;
            int end = item.indexOf("/", folder.length());
            if (end == -1) {
                items.add(item);
                continue;
            }
            String subdir = item.substring(0, end + 1);
            if (items.contains(subdir)) continue;
            items.add(subdir);
        }
        return items;
    }

    @Override
    public InputStream getRepositoryFileAsStreamImpl(String repositoryFile) throws ExternalRepositoryException {
        ZipArchiveEntry entry = this.archive.getEntry(repositoryFile);
        InputStream is = null;
        try {
            is = this.archive.getInputStream(entry);
            if (is == null) {
                throw new Throwable();
            }
        }
        catch (Throwable e) {
            String strMsg = String.format(InstallerState.LOCALIZED_EXTERNALREPOSITORYZIP_ARCHIVEFILEERROR, repositoryFile, this.baseURLFile);
            throw new ExternalRepositoryException(strMsg);
        }
        return is;
    }

    @Override
    public void close() {
        ZipFile.closeQuietly(this.archive);
    }

    @Override
    public long getRepositoryFileSize(String repositoryFile) {
        ZipArchiveEntry entry = this.archive.getEntry(repositoryFile);
        return entry != null ? entry.getSize() : -1L;
    }
}

