/*
 * Decompiled with CFR 0.152.
 */
package repository;

import java.io.File;
import java.nio.file.Files;

public class Netrc {
    public static final String USER_ENV = "ANALYTICS_INSTALLER_USER";
    public static final String PASSWORD_ENV = "ANALYTICS_INSTALLER_PASSWORD";
    private static final String MACHINE = "machine ";
    private static final String DEFAULT = "default";
    private static final String LOGIN = "login";
    private static final String PASSWORD = "password";
    private static final String SPACE = " ";
    private String netrc;
    private String user = null;
    private String password = null;

    public Netrc(File home) {
        this.readNetrc(home);
    }

    public Netrc() {
        this.readNetrc(null);
    }

    public boolean readCredentials(String host) {
        boolean rc = false;
        try {
            this.parseCredentials(host);
            if (this.user == null) {
                this.user = System.getenv(USER_ENV);
                this.password = System.getenv(PASSWORD_ENV);
            }
            rc = this.user != null && this.password != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rc;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private void parseCredentials(String host) throws Exception {
        this.user = null;
        this.password = null;
        if (this.netrc != null) {
            int end;
            int start = this.netrc.indexOf(MACHINE + host);
            if (start == -1) {
                start = this.netrc.indexOf(DEFAULT);
            }
            if (start != -1 && (start = this.netrc.indexOf(LOGIN, start)) != -1 && (end = this.netrc.indexOf(SPACE, start = start + LOGIN.length() + 1)) != -1) {
                this.user = this.netrc.substring(start, end);
                start = end + PASSWORD.length() + 2;
                this.password = (end = this.netrc.indexOf(SPACE, start)) == -1 ? this.netrc.substring(start) : this.netrc.substring(start, end);
            }
        }
    }

    private void readNetrc(File home) {
        if (home == null && !(home = new File(System.getProperty("user.home"))).isDirectory() && System.getenv("HOME") != null) {
            home = new File(System.getenv("HOME"));
        }
        if (home.isDirectory()) {
            File netrcfile = new File(home, ".netrc");
            if (!netrcfile.isFile()) {
                netrcfile = new File(home, "_netrc");
            }
            if (netrcfile.isFile()) {
                try {
                    this.netrc = new String(Files.readAllBytes(netrcfile.toPath()));
                    this.netrc = this.netrc.replaceAll("\\s+", SPACE);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.netrc = null;
    }
}

