/*
 * Decompiled with CFR 0.152.
 */
package repository;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import repository.ExternalRepositoryException;

public class RepositoryInputStream
extends InputStream {
    private final InputStream is;
    private final MessageDigest sha1;
    private long byteCount = 0L;
    private int rc;

    public RepositoryInputStream(InputStream source) throws ExternalRepositoryException {
        try {
            this.sha1 = MessageDigest.getInstance("sha1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExternalRepositoryException(e.getMessage());
        }
        this.is = source;
    }

    @Override
    public int read() throws IOException {
        this.rc = this.is.read();
        if (this.rc != -1) {
            ++this.byteCount;
            this.sha1.update((byte)this.rc);
        }
        return this.rc;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.rc = this.is.read(b, off, len);
        if (this.rc != -1) {
            this.byteCount += (long)this.rc;
            this.sha1.update(b, off, this.rc);
        }
        return this.rc;
    }

    @Override
    public void close() throws IOException {
        if (this.byteCount > 0L && this.rc != -1) {
            byte[] buffer = new byte[512];
            while (this.read(buffer, 0, 512) != -1) {
            }
        }
    }

    public String getChecksum() {
        return DatatypeConverter.printHexBinary((byte[])this.sha1.digest());
    }

    public long getByteCount() {
        return this.byteCount;
    }
}

