/*
 * IBM Confidential
 * OCO Source Materials
 * IBM Cognos Products: XQE
 * (C) Copyright IBM Corp. 2009, 2015
 * The source code for this program is not published or otherwise divested of its trade secrets,
 * irrespective of what has been deposited with the U.S. Copyright Office.
 */
package udf.samples;

import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;

import com.cognos.xqe.util.LocaleConverter;

/**
 * Conversion functions.
 */
public class Format {

	/**
	 * Colon character.
	 */
	private static final String COLON = " : ";

	/**
	 * Number for testing.
	 */
	private static final double NUMBER = 123.45;

	/**
	 * Format number as currency using US locale.
	 * @param value - numeric value
	 * @return formatted string
	 */
	public static String formatCurrency(Number value) {
		NumberFormat n = NumberFormat.getCurrencyInstance(Locale.US);
		String result = n.format(value.doubleValue());
		return result;
	}

	/**
	 * Format number as currency using locale identified by language and country.
	 * @param value - numeric value
	 * @param language - 2-letter language code
	 * @param country - 2-letter country code
	 * @return formatted string
	 */
	public static String formatCurrency(Number value, String language, String country) {
		NumberFormat n = NumberFormat.getCurrencyInstance(new Locale(language, country));
		String result = n.format(value.doubleValue());
		return result;
	}

	/**
	 * Test.
	 * @param args - command line arguments
	 */
	public static void main(String[] args) {
		Locale[] locales = NumberFormat.getAvailableLocales();
		for (Locale locale : locales) {
			NumberFormat n = NumberFormat.getInstance(locale);
			Currency c = n.getCurrency();
			System.out.print(locale.getDisplayCountry() + COLON + locale.getDisplayLanguage() + COLON + locale.getCountry()
					+ COLON + LocaleConverter.getLanguage(locale) + COLON + c.toString() + COLON);
			System.out.println(formatCurrency(NUMBER, LocaleConverter.getLanguage(locale), locale.getCountry()));
		}
	}
}
