/*
 * IBM Confidential
 * OCO Source Materials
 * IBM Cognos Products: XQE
 * (C) Copyright IBM Corp. 2009, 2015
 * The source code for this program is not published or otherwise divested of its trade secrets, 
 * irrespective of what has been deposited with the U.S. Copyright Office.
 */
package udf.samples;

import java.io.Serializable;

/**
 * Multiply aggregate.
 */
public class Multiply {

    /**
     * Initialize.
     * @return state object
     */
    public static State initialize() {
    	return new State();
    }
    
    /**
     * Iterate.
     * @param value - value
     */    
	public static void iterate(State aggrState, Number value) {
		aggrState.iterate(value);
	}
    
    /**
     * Remove.
     * @param value - value
     */    
	public static void remove(State aggrState, Number value) {
		aggrState.remove(value);
	}
	
    /**
     * Get result.
     * @return result value
     */
    public static Double getResult(State aggrState) {
    	return aggrState.getValue();
    }
	
    /**
     * Terminate.
     * @return result value
     */
    public static void terminate(State aggrState) {
    }
    
    /**
     * State class.
     */
    private static final class State implements Serializable {
    	/**
		 * Serialization UID.
		 */
		private static final long serialVersionUID = 1624134928286868643L;

		/**
    	 * Accumulator.
    	 */
    	private double accumulator;
    	
    	/**
    	 * Number of non-null values.
    	 */
    	private int count;
    	
        /**
         * Constructor.
         */
        public State() {
        	accumulator = 1.0;
        }
        
        /**
         * Iterate.
         * @param value - value
         */    
    	public void iterate(Number value) {
    		if (value == null) {
    			return;
    		}
    		
    		count++;
    		accumulator *= value.doubleValue();
    	}

        /**
         * Iterate.
         * @param value - value
         */    
    	public void remove(Number value) {
    		if (value == null) {
    			return;
    		}
    		
    		count--;
    		accumulator /= value.doubleValue();
    	}
 
    	/**
    	 * Get current value.
    	 * @return current value
    	 */
    	public Double getValue() {
           	if (count == 0) {
        		return null;
        	}
        	
         	return accumulator;
    	}
    }
}
