/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf.builtin;

import com.cognos.xqe.function.udf.sdk.Table;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Launch {
    public static void executeBatchFile(String batFile, Number wait, ResultSet[] resultSets) throws IOException, InterruptedException {
        resultSets[0] = new LaunchTable(batFile, wait);
    }

    public void release() {
    }

    private static class LaunchTable
    extends Table {
        private boolean eod = false;
        private Integer[] result = new Integer[1];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LaunchTable(String batFile, Number wait) throws IOException, InterruptedException {
            int status;
            File f = new File(batFile);
            if (!f.exists()) {
                throw new FileNotFoundException(batFile);
            }
            String[] command = new String[]{"cmd", "/c", batFile};
            ProcessBuilder procBuilder = new ProcessBuilder(command);
            Process process = procBuilder.start();
            if (wait.shortValue() == 1 && (status = process.waitFor()) != 0) {
                InputStream eStream = process.getErrorStream();
                StringWriter writer = new StringWriter();
                char[] buffer = new char[1024];
                try {
                    int n;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(eStream, "UTF-8"));
                    while ((n = reader.read(buffer)) >= 0) {
                        ((Writer)writer).write(buffer, 0, n);
                    }
                }
                finally {
                    eStream.close();
                }
                String errMsg = ((Object)writer).toString();
                if (errMsg.length() == 0) {
                    return;
                }
                throw new RuntimeException(String.format("Error %d: %s", status, ((Object)writer).toString()));
            }
        }

        public boolean next() {
            if (this.eod) {
                return false;
            }
            this.eod = true;
            this.result[0] = 0;
            return true;
        }

        public int getInt(int index) {
            return this.result[index - 1];
        }

        public boolean wasNull() throws SQLException {
            return false;
        }

        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            throw new SQLException("Method not supported by DQM JDBC Driver");
        }

        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            throw new SQLException("Method not supported by DQM JDBC Driver");
        }
    }
}

