/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf.builtin;

import com.cognos.xqe.function.udf.sdk.Table;
import com.cognos.xqe.function.xml.XMLErrorHandler;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class Logs {
    public static void getLogs(ResultSet[] resultSets) {
        resultSets[0] = new LogsTable();
    }

    private static class LogsTable
    extends Table {
        private static final String LOGS_PATH = "../logs/XQE/";
        private static final Map<String, Object> SERIALIZER_PARAMETERS = new HashMap<String, Object>();
        private SessionContext session;
        private CursorFactory factory;
        private ErrorHandler eHandler;
        private StaticContext staticCxt;
        private Executable qExpr;
        private static final String eventXPath = "/log/event";
        private static String[] columnXPath;
        private Executable[] xPathExpr = new Executable[columnXPath.length];
        private String[] objects = new String[columnXPath.length];
        private int index = 0;
        private String[] fileList;
        private Cursor result;
        private boolean eod = true;
        private DynamicContext dynamicCxt;

        public LogsTable() {
            File extDir = new File(LOGS_PATH);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("xqelog-") && name.endsWith(".xml");
                }
            };
            this.fileList = extDir.list(filter);
            this.session = new SessionContext(((Object)((Object)this)).getClass().getClassLoader());
            this.eHandler = new XMLErrorHandler();
            this.staticCxt = new BasicStaticContext(this.session.getTypeRegistry());
            this.factory = this.session.getSimpleDataFactory();
            this.staticCxt.setBaseURI(System.getProperty("user.dir"));
            this.staticCxt.setErrorHandler(this.eHandler);
            this.staticCxt.setLanguageTypeAndVersion(4);
            Preparer queryPreparer = this.session.getPreparer(new RequestInfo(Cursor.RANDOM_ACCESS, null, "XPath2StreamingSubset"));
            this.qExpr = queryPreparer.prepare(eventXPath, this.staticCxt, -1);
            this.staticCxt.setLanguageTypeAndVersion(3);
            Preparer preparer = this.session.getPreparer(RequestInfo.XPath2);
            this.xPathExpr = new Executable[columnXPath.length];
            for (int i = 0; i < columnXPath.length; ++i) {
                this.xPathExpr[i] = preparer.prepare(columnXPath[i], this.staticCxt, -1);
            }
            this.dynamicCxt = new BasicMutableDynamicContext(this.session);
            this.dynamicCxt.setErrorHandler(this.eHandler);
        }

        public boolean next() {
            while (this.eod) {
                if (this.index == this.fileList.length) {
                    return false;
                }
                if (this.result != null) {
                    this.result.release();
                }
                this.eod = false;
                String fileName = LOGS_PATH + this.fileList[this.index];
                try {
                    FileInputStream is = new FileInputStream(fileName);
                    ++this.index;
                    RequestInfo info = new RequestInfo(Cursor.Profile.MINIMAL_SKIP_STREAMING_NAVIGATION, new String[]{"STREAMING_XPATH"});
                    Cursor contextDoc = this.factory.getSessionContext().document((Source)new StreamSource(is), info);
                    this.result = this.qExpr.execute(contextDoc, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
                }
                catch (FileNotFoundException e) {
                    this.eod = true;
                }
                catch (XCIDynamicErrorException e) {
                    this.eod = true;
                }
            }
            Cursor xPathCursor = this.result.fork(true);
            xPathCursor.toSelf();
            for (int i = 0; i < this.xPathExpr.length; ++i) {
                Cursor cursor = this.xPathExpr[i].execute(xPathCursor, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
                if (cursor == null) {
                    this.objects[i] = null;
                    continue;
                }
                VolatileCData cData = cursor.serialize(SERIALIZER_PARAMETERS);
                this.objects[i] = cData.toString();
                cursor.release();
            }
            xPathCursor.release();
            this.eod = !this.result.toNext();
            return true;
        }

        public String getString(int columnNo) {
            return this.objects[columnNo - 1];
        }

        public Object getObject(int columnNo) {
            return this.objects[columnNo - 1];
        }

        public Timestamp getTimestamp(int columnNo) {
            if (this.objects[columnNo - 1] == null) {
                return null;
            }
            return Timestamp.valueOf(this.objects[columnNo - 1]);
        }

        public boolean wasNull() throws SQLException {
            return false;
        }

        public void close() throws SQLException {
            if (this.result != null) {
                this.result.release();
            }
        }

        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            throw new SQLException("Method not supported by DQM JDBC Driver");
        }

        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            throw new SQLException("Method not supported by DQM JDBC Driver");
        }

        static {
            SERIALIZER_PARAMETERS.put("omit-xml-declaration", Boolean.TRUE);
            columnXPath = new String[]{"event/@component/string()", "event/@group/string()", "event/@level/string()", "event/@thread/string()", "event/@requestId/string()", "event/@timestamp/string()", "event/text()"};
        }
    }
}

