/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf.builtin;

import com.cognos.xqe.function.udf.sdk.Table;
import com.cognos.xqe.metrics.MetricsManager;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Metrics {
    private static final String[] counterNames = new String[]{"NumberOfReceivedRequests", "NumberOfSuccessfulRequests", "NumberOfFailedRequests", "XqeQueriesPlanned", "XqeSuccessfulQueriesPlanned", "XqeFailedQueriesPlanned", "XqeQueriesExecuted", "XqeSuccessfulQueriesExecuted", "XqeFailedQueriesExecuted", "ServiceTimeAllRequests", "ServiceTimeSuccessfulRequests", "ServiceTimeFailedRequests", "XqeQueriesPlannedTime", "XqeSuccessfulQueriesPlannedTime", "XqeFailedQueriesPlannedTime", "XqeQueriesExecutedTime", "XqeSuccessfulQueriesExecutedTime", "XqeFailedQueriesExecutedTime", "ResponseTimeHighWaterMark", "ResponseTimeLowWaterMark"};
    private static Object[] metrics;
    private static long timestamp;
    private static final long ONE_MINUTE = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getMetrics(ResultSet[] resultSets) {
        String[] stringArray = counterNames;
        synchronized (counterNames) {
            long currentTime = System.currentTimeMillis();
            if (metrics == null || currentTime - timestamp > 60000L) {
                metrics = MetricsManager.getSnapshot((String[])counterNames);
                timestamp = System.currentTimeMillis();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            resultSets[0] = new MetricsTable(metrics);
            return;
        }
    }

    private static class MetricsTable
    extends Table {
        private static final int NCOLUMNS = 5;
        private int index = 0;
        private String[][] columnNames = new String[][]{{"Overall", "All", "Received Requests"}, {"Overall", "Passed", "Successful Requests"}, {"Overall", "Failed", "Failed Requests"}, {"Planning", "All", "Queries Planned"}, {"Planning", "Passed", "Successful Queries Planned"}, {"Planning", "Failed", "Failed Queries Planned"}, {"Execution", "All", "Queries Executed"}, {"Execution", "Passed", "Successful Queries Executed"}, {"Execution", "Failed", "Failed Queries Executed"}, {"Overall", "All", "Service Time"}, {"Overall", "Passed", "Successful Service Time"}, {"Overall", "Failed", "Failed Service Time"}, {"Planning", "All", "Queries Planned Time"}, {"Planning", "Passed", "Successful Queries Planning Time"}, {"Planning", "Failed", "Failed Queries Planning Time"}, {"Execution", "All", "Queries Executed Time"}, {"Execution", "Passed", "Successful Queries Executed Time"}, {"Execution", "Failed", "Failed Queries Executed Time"}, {"Response Time", "Maximum", "Maximum Response Time", "Maximum"}, {"Response Time", "Minumum", "Minumum Response Time"}};
        private Object[] counterValues;
        private Object[] objects = new Object[5];

        public MetricsTable(Object[] values) {
            this.counterValues = values;
        }

        public boolean next() {
            if (this.index == counterNames.length) {
                return false;
            }
            this.objects[0] = this.index + 1;
            this.objects[1] = this.columnNames[this.index][0];
            this.objects[2] = this.columnNames[this.index][1];
            this.objects[3] = this.columnNames[this.index][2];
            this.objects[4] = this.counterValues[this.index];
            ++this.index;
            return true;
        }

        public Object getObject(int index) {
            return this.objects[index - 1];
        }

        public String getString(int index) {
            return (String)this.objects[index - 1];
        }

        public int getInt(int index) {
            return (Integer)this.objects[index - 1];
        }

        public long getLong(int index) {
            return (Long)this.objects[index - 1];
        }

        public boolean wasNull() throws SQLException {
            return false;
        }

        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            throw new SQLException("Method not supported by DQM JDBC Driver");
        }

        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            throw new SQLException("Method not supported by DQM JDBC Driver");
        }
    }
}

