/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.function.udf.builtin;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.PeriodType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.PeriodValue;
import java.sql.SQLException;

public class Temporal {
    private static final String INVALID_PERIOD = "Input period has an end time that is not greater than its start time";

    public static Integer contains(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2Start) <= 0 && p1End.compareTo((Object)p2End) >= 0) {
            return 1;
        }
        return 0;
    }

    public static Integer contains(PeriodValue p1, PeriodValue p2) throws SQLException {
        Boolean result = p1.contains(p2);
        if (result != null) {
            if (result.booleanValue()) {
                return 1;
            }
            return 0;
        }
        return null;
    }

    public static Integer equals(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2Start) == 0 && p1End.compareTo((Object)p2End) == 0) {
            return 1;
        }
        return 0;
    }

    public static Integer equals(PeriodValue p1, PeriodValue p2) throws SQLException {
        Boolean result = p1.equals(p2);
        if (result != null) {
            if (result.booleanValue()) {
                return 1;
            }
            return 0;
        }
        return null;
    }

    public static DateTimeValue intersectStart(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2End) < 0 && p2Start.compareTo((Object)p1End) < 0 || p2Start.compareTo((Object)p1End) < 0 && p1Start.compareTo((Object)p2End) < 0) {
            if (p1Start.compareTo((Object)p2Start) < 0) {
                return p2Start;
            }
            return p1Start;
        }
        return null;
    }

    public static DateTimeValue intersectStart(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.intersectStart(p2);
    }

    public static DateTimeValue intersectEnd(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2End) < 0 && p2Start.compareTo((Object)p1End) < 0 || p2Start.compareTo((Object)p1End) < 0 && p1Start.compareTo((Object)p2End) < 0) {
            if (p1End.compareTo((Object)p2End) < 0) {
                return p1End;
            }
            return p2End;
        }
        return null;
    }

    public static DateTimeValue intersectEnd(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.intersectEnd(p2);
    }

    public static PeriodValue intersect(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.intersect(p2);
    }

    public static DateTimeValue lDiffStart(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2Start) < 0) {
            return p1Start;
        }
        return null;
    }

    public static DateTimeValue lDiffStart(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.lDiffStart(p2);
    }

    public static DateTimeValue lDiffEnd(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2Start) < 0) {
            return p2Start;
        }
        return null;
    }

    public static DateTimeValue lDiffEnd(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.lDiffEnd(p2);
    }

    public static PeriodValue lDiff(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.lDiff(p2);
    }

    public static DateTimeValue rDiffStart(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1End.compareTo((Object)p2End) < 0) {
            return p2End;
        }
        return null;
    }

    public static DateTimeValue rDiffStart(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.rDiffStart(p2);
    }

    public static DateTimeValue rDiffEnd(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1End.compareTo((Object)p2End) < 0) {
            return p1End;
        }
        return null;
    }

    public static DateTimeValue rDiffEnd(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.rDiffEnd(p2);
    }

    public static PeriodValue rDiff(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.rDiff(p2);
    }

    public static DateTimeValue unionStart(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2Start) <= 0 && p1End.compareTo((Object)p2Start) >= 0) {
            return p1Start;
        }
        if (p2Start.compareTo((Object)p1Start) <= 0 && p2End.compareTo((Object)p1Start) >= 0) {
            return p2Start;
        }
        return null;
    }

    public static DateTimeValue unionStart(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.unionStart(p2);
    }

    public static DateTimeValue unionEnd(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1End.compareTo((Object)p2End) >= 0 && p1Start.compareTo((Object)p2End) <= 0) {
            return p1Start;
        }
        if (p2End.compareTo((Object)p1End) >= 0 && p2Start.compareTo((Object)p1End) <= 0) {
            return p2Start;
        }
        return null;
    }

    public static DateTimeValue unionEnd(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.unionEnd(p2);
    }

    public static Integer meets(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1End.compareTo((Object)p2Start) == 0) {
            return 1;
        }
        return 0;
    }

    public static Integer meets(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.meets(p2);
    }

    public static Integer precedes(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1End.compareTo((Object)p2Start) <= 0) {
            return 1;
        }
        return 0;
    }

    public static Integer precedes(PeriodValue p1, PeriodValue p2) throws SQLException {
        Boolean result = p1.precedes(p2);
        if (result != null) {
            if (result.booleanValue()) {
                return 1;
            }
            return 0;
        }
        return null;
    }

    public static Integer succeeds(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2End) >= 0) {
            return 1;
        }
        return 0;
    }

    public static Integer succeeds(PeriodValue p1, PeriodValue p2) throws SQLException {
        Boolean result = p1.succeeds(p2);
        if (result != null) {
            if (result.booleanValue()) {
                return 1;
            }
            return 0;
        }
        return null;
    }

    public static Integer overlaps(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2End) < 0 && p2Start.compareTo((Object)p1End) < 0) {
            return 1;
        }
        return 0;
    }

    public static Integer overlaps(PeriodValue p1, PeriodValue p2) throws SQLException {
        Boolean result = p1.overlaps(p2);
        if (result != null) {
            if (result.booleanValue()) {
                return 1;
            }
            return 0;
        }
        return null;
    }

    public static Integer within(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1End.compareTo((Object)p1Start) <= 0 || p2End.compareTo((Object)p2Start) <= 0) {
            throw new SQLException(INVALID_PERIOD, "2FI00");
        }
        if (p1Start.compareTo((Object)p2Start) >= 0 && p1End.compareTo((Object)p2End) <= 0) {
            return 1;
        }
        return 0;
    }

    public static Integer within(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.within(p2);
    }

    public static PeriodValue normalize(DateTimeValue p1Start, DateTimeValue p1End, DateTimeValue p2Start, DateTimeValue p2End) throws SQLException {
        if (p1Start.isNull() || p1End.isNull() || p2Start.isNull() || p2End.isNull()) {
            return null;
        }
        if (p1Start.compareTo((Object)p2Start) >= 0 && p1Start.compareTo((Object)p2End) <= 0 || p2Start.compareTo((Object)p1Start) >= 0 && p2Start.compareTo((Object)p1End) <= 0) {
            PeriodType dType = DataTypeFactory.getPeriodType((IDataType)p1Start.getDataType());
            PeriodValue result = DataValueFactory.createPeriodValue((PeriodType)dType);
            result.set(DateTimeValue.minimum((DateTimeValue)p1Start, (DateTimeValue)p2Start), DateTimeValue.maximum((DateTimeValue)p1End, (DateTimeValue)p2End));
            return result;
        }
        return null;
    }

    public static PeriodValue normalize(PeriodValue p1, PeriodValue p2) throws SQLException {
        return p1.normalize(p2);
    }

    public static DateTimeValue begin(PeriodValue p) throws SQLException {
        return p.getStart();
    }

    public static DateTimeValue end(PeriodValue p) throws SQLException {
        return p.getEnd();
    }

    public static DateTimeValue last(PeriodValue p) throws SQLException {
        return p.last();
    }

    public static DateTimeValue next(DateTimeValue v) throws SQLException {
        return v.next();
    }

    public static DateTimeValue prior(DateTimeValue v) throws SQLException {
        return v.prior();
    }
}

