SQLActions[] = {
	"BEGIN INSTALL

		-- Extract year field.		
		CREATE FUNCTION _YEAR(D DATE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(YEAR FROM D);
		
		-- Extract year field.		
		CREATE FUNCTION _YEAR(TS TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(YEAR FROM TS);
		
		-- Extract year field.		
		CREATE FUNCTION _YEAR(TS TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(YEAR FROM TS);
		
		-- Extract month field.		
		CREATE FUNCTION _MONTH(D DATE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(MONTH FROM D);
		
		-- Extract month field.		
		CREATE FUNCTION _MONTH(TS TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(MONTH FROM TS);
		
		-- Extract month field.		
		CREATE FUNCTION _MONTH(TS TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(MONTH FROM TS);
		
		-- Extract day field.		
		CREATE FUNCTION _DAY(D DATE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(DAY FROM D);
		
		-- Extract day field.		
		CREATE FUNCTION _DAY(TS TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(DAY FROM TS);
		
		-- Extract day field.		
		CREATE FUNCTION _DAY(TS TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(DAY FROM TS);
		
		-- Extract hour field.		
		CREATE FUNCTION _HOUR(T TIME)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(HOUR FROM T);
		
		-- Extract hour field.		
		CREATE FUNCTION _HOUR(T TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(HOUR FROM T);
		
		-- Extract hour field.		
		CREATE FUNCTION _HOUR(TS TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(HOUR FROM TS);
		
		-- Extract hour field.		
		CREATE FUNCTION _HOUR(TS TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(HOUR FROM TS);
		
		-- Extract minute field.		
		CREATE FUNCTION _MINUTE(T TIME)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(MINUTE FROM T);
		
		-- Extract minute field.		
		CREATE FUNCTION _MINUTE(T TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(MINUTE FROM T);
		
		-- Extract minute field.		
		CREATE FUNCTION _MINUTE(TS TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(MINUTE FROM TS);
		
		-- Extract minute field.		
		CREATE FUNCTION _MINUTE(TS TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(MINUTE FROM TS);
		
		-- Extract seconds field.		
		CREATE FUNCTION _SECOND(T TIME)
		RETURNS DECIMAL(11,2)
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(SECOND FROM T);
		
		-- Extract seconds field.		
		CREATE FUNCTION _SECOND(T TIME WITH TIME ZONE)
		RETURNS DECIMAL(11,2)
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(SECOND FROM T);
		
		-- Extract seconds field.		
		CREATE FUNCTION _SECOND(TS TIMESTAMP)
		RETURNS DECIMAL(11,2)
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(SECOND FROM TS);
		
		-- Extract seconds field.		
		CREATE FUNCTION _SECOND(TS TIMESTAMP WITH TIME ZONE)
		RETURNS DECIMAL(11,2)
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(SECOND FROM TS);
		
		-- Extract timezone hour field.		
		CREATE FUNCTION _TIMEZONE_HOUR(T TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(TIMEZONE_HOUR FROM T);
		
		-- Extract timezone hour field.		
		CREATE FUNCTION _TIMEZONE_HOUR(TS TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(TIMEZONE_HOUR FROM TS);
		
		-- Extract timezone minute field.		
		CREATE FUNCTION _TIMEZONE_MINUTE(T TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(TIMEZONE_MINUTE FROM T);
		
		-- Extract timezone minute field.		
		CREATE FUNCTION _TIMEZONE_MINUTE(TS TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(TIMEZONE_MINUTE FROM TS);
		
		-- Start of day (i.e. TIMESTAMP '2014-11-23 00:00:00').		
		CREATE FUNCTION _START_OF_DAY()
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN CAST(CURRENT_DATE AS TIMESTAMP);

		-- Start of day.		
		CREATE FUNCTION _START_OF_DAY(D DATE)
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN CAST(D AS TIMESTAMP);

		-- Start of day.		
		CREATE FUNCTION _START_OF_DAY(TS TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN CAST(CAST(TS AS DATE) AS TIMESTAMP);

		-- Start of day.		
		CREATE FUNCTION _START_OF_DAY(TS TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN CAST(CAST(TS AS DATE) AS TIMESTAMP);
		
		-- End of day (i.e. TIMESTAMP '2014-11-23 23:59:59').		
		CREATE FUNCTION _END_OF_DAY()
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN _ADD_SECONDS(_ADD_DAYS(CAST(CURRENT_DATE AS TIMESTAMP), 1), -1);

		-- End of day.		
		CREATE FUNCTION _END_OF_DAY(D DATE)
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN _ADD_SECONDS(_ADD_DAYS(CAST(D AS TIMESTAMP), 1), -1);

		-- End of day.		
		CREATE FUNCTION _END_OF_DAY(TS TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN _ADD_SECONDS(_ADD_DAYS(CAST(CAST(TS AS DATE) AS TIMESTAMP), 1), -1);

		-- End of day.		
		CREATE FUNCTION _END_OF_DAY(TS TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN _ADD_SECONDS(_ADD_DAYS(CAST(CAST(TS AS DATE) AS TIMESTAMP), 1), -1);
		
		-- UNIX timestamp.		
		CREATE FUNCTION _UNIX_TIMESTAMP(D DATE)
		RETURNS BIGINT
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(EPOCH FROM D);
		
		-- UNIX timestamp.		
		CREATE FUNCTION _UNIX_TIMESTAMP(TS TIMESTAMP)
		RETURNS BIGINT
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(EPOCH FROM TS);
		
		-- UNIX timestamp.		
		CREATE FUNCTION _UNIX_TIMESTAMP(TS TIMESTAMP WITH TIME ZONE)
		RETURNS BIGINT
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN EXTRACT(EPOCH FROM TS);
		
		-- UNIX timestamp to SQL timestamp.		
		CREATE FUNCTION _FROM_UNIXTIME(UNIX_TIME NUMBER)
		RETURNS TIMESTAMP
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN _ADD_SECONDS(TIMESTAMP '1970-01-01 00:00:00.000000000+00:00', UNIX_TIME);
		
		-- Convert DATE to integer (i.e. DATE '2014-12-05' ==> 20141205).		
		CREATE FUNCTION _DATE_TO_INT(D DATE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN (EXTRACT(YEAR FROM D) * 10000) + (EXTRACT(MONTH FROM D) * 100) + EXTRACT(DAY FROM D);
		
		-- Convert DATE to integer with TIMESTAMP input (i.e. TIMESTAMP '2014-12-05 12:00:00.000' ==> 20141205).		
		CREATE FUNCTION _DATE_TO_INT(TS TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN (EXTRACT(YEAR FROM TS) * 10000) + (EXTRACT(MONTH FROM TS) * 100) + EXTRACT(DAY FROM TS);
		
		-- Convert DATE to integer with TIMESTAMP WITH TIME ZONE input 
		-- (i.e. TIMESTAMP '2014-12-05 12:00:00.000-05:00' ==> 20141205).		
		CREATE FUNCTION _DATE_TO_INT(TS TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE SQL
		CONTAINS SQL
		DETERMINISTIC
		RETURN (EXTRACT(YEAR FROM TS) * 10000) + (EXTRACT(MONTH FROM TS) * 100) + EXTRACT(DAY FROM TS);

	END INSTALL"
}
