SQLActions[] = {
	"BEGIN INSTALL
		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 fully contains period 2.
		CREATE FUNCTION DQMUDF.contains(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.contains';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE,
			p2_start TIME WITH TIME ZONE, p2_end TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Determines if period 1 and period 2 are equal.
		CREATE FUNCTION DQMUDF.equals(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.equals';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE,
			p2_start TIME WITH TIME ZONE, p2_end TIME WITH TIME ZONE)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the starting point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_start(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectStart';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE,
			p2_start TIME WITH TIME ZONE, p2_end TIME WITH TIME ZONE)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the end point of the intersection of two periods that overlap.
		CREATE FUNCTION DQMUDF.intersect_end(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersectEnd';

		-- Returns the portion of the period values that is common between them if they overlap.
		CREATE FUNCTION DQMUDF.intersect(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS PERIOD(DATE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersect';

		-- Returns the portion of the period values that is common between them if they overlap.
		CREATE FUNCTION DQMUDF.intersect(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS PERIOD(TIME)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersect';

		-- Returns the portion of the period values that is common between them if they overlap.
		CREATE FUNCTION DQMUDF.intersect(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS PERIOD(TIME)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersect';

		-- Returns the portion of the period values that is common between them if they overlap.
		CREATE FUNCTION DQMUDF.intersect(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS PERIOD(TIMESTAMP)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersect';

		-- Returns the portion of the period values that is common between them if they overlap.
		CREATE FUNCTION DQMUDF.intersect(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS PERIOD(TIMESTAMP)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.intersect';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_start(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffStart';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 begins before period 2.
		CREATE FUNCTION DQMUDF.ldiff_end(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiffEnd';

		-- Returns the portion of the first period that exists before the beginning of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.ldiff(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS PERIOD(DATE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiff';

		-- Returns the portion of the first period that exists before the beginning of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.ldiff(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS PERIOD(TIME)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiff';

		-- Returns the portion of the first period that exists before the beginning of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.ldiff(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS PERIOD(TIME)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiff';

		-- Returns the portion of the first period that exists before the beginning of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.ldiff(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS PERIOD(TIMESTAMP)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiff';

		-- Returns the portion of the first period that exists before the beginning of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.ldiff(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS PERIOD(TIMESTAMP)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.lDiff';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the starting point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_start(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffStart';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the end point of the difference of two periods in which period 1 ends after period 2.
		CREATE FUNCTION DQMUDF.rdiff_end(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiffEnd';

		-- Returns the portion of the first period that exists from the end of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.rdiff(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS PERIOD(DATE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiff';

		-- Returns the portion of the first period that exists from the end of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.rdiff(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS PERIOD(TIME)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiff';

		-- Returns the portion of the first period that exists from the end of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.rdiff(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS PERIOD(TIME)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiff';

		-- Returns the portion of the first period that exists from the end of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.rdiff(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS PERIOD(TIMESTAMP)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiff';

		-- Returns the portion of the first period that exists from the end of the second period
		-- when the two periods overlap.
		CREATE FUNCTION DQMUDF.rdiff(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS PERIOD(TIMESTAMP)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.rDiff';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the starting point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_start(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionStart';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Returns the end point of the union of two periods that overlap or meet.
		CREATE FUNCTION DQMUDF.union_end(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.unionEnd';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if the end time of period 1 is equal to the start time of period 2.
		CREATE FUNCTION DQMUDF.meets(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.meets';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 precedes (is earlier than) period 2.
		CREATE FUNCTION DQMUDF.precedes(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.precedes';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 succeeds (is later than) period 2.
		CREATE FUNCTION DQMUDF.succeeds(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.succeeds';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 and period 2 overlap (share some time in common).
		CREATE FUNCTION DQMUDF.overlaps(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.overlaps';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Determines if period 1 occurs within period 2.
		CREATE FUNCTION DQMUDF.within(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Returns a new period value that is a combination of two period value that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1_start DATE, p1_end DATE, p2_start DATE, p2_end DATE)
		RETURNS PERIOD(DATE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1_start TIME, p1_end TIME, p2_start TIME, p2_end TIME)
		RETURNS PERIOD(TIME)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1_start TIME WITH TIME ZONE, p1_end TIME WITH TIME ZONE, p2_start TIME WITH TIME ZONE,
			p2_end TIME WITH TIME ZONE)
		RETURNS PERIOD(TIME WITH TIME ZONE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1_start TIMESTAMP, p1_end TIMESTAMP, p2_start TIMESTAMP, p2_end TIMESTAMP)
		RETURNS PERIOD(TIMESTAMP)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1_start TIMESTAMP WITH TIME ZONE, p1_end TIMESTAMP WITH TIME ZONE,
			p2_start TIMESTAMP WITH TIME ZONE, p2_end TIMESTAMP WITH TIME ZONE)
		RETURNS PERIOD(TIMESTAMP WITH TIME ZONE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1 PERIOD(DATE), p2 PERIOD(DATE))
		RETURNS PERIOD(DATE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1 PERIOD(TIME), p2 PERIOD(TIME))
		RETURNS PERIOD(TIME)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.within';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1 PERIOD(TIME WITH TIME ZONE), p2 PERIOD(TIME WITH TIME ZONE))
		RETURNS PERIOD(TIME WITH TIME ZONE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1 PERIOD(TIMESTAMP), p2 PERIOD(TIMESTAMP))
		RETURNS PERIOD(TIMESTAMP)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns a new period value that is a combination of two period values that overlap or meet.
		CREATE FUNCTION DQMUDF.normalize(p1 PERIOD(TIMESTAMP WITH TIME ZONE), p2 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS PERIOD(TIMESTAMP WITH TIME ZONE)
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.normalize';

		-- Returns the beginning bound of the period.
		CREATE FUNCTION DQMUDF.begin(p1 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.begin';

		-- Returns the beginning bound of the period.
		CREATE FUNCTION DQMUDF.begin(p1 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.begin';

		-- Returns the beginning bound of the period.
		CREATE FUNCTION DQMUDF.begin(p1 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.begin';

		-- Returns the beginning bound of the period.
		CREATE FUNCTION DQMUDF.begin(p1 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.begin';

		-- Returns the beginning bound of the period.
		CREATE FUNCTION DQMUDF.begin(p1 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.begin';

		-- Returns the ending bound of the period.
		CREATE FUNCTION DQMUDF.end(p1 PERIOD(DATE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.end';

		-- Returns the ending bound of the period.
		CREATE FUNCTION DQMUDF.end(p1 PERIOD(TIME))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.end';

		-- Returns the ending bound of the period.
		CREATE FUNCTION DQMUDF.end(p1 PERIOD(TIME WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.end';

		-- Returns the ending bound of the period.
		CREATE FUNCTION DQMUDF.end(p1 PERIOD(TIMESTAMP))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.end';

		-- Returns the ending bound of the period.
		CREATE FUNCTION DQMUDF.end(p1 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS INTEGER
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.end';

		-- Returns the end point of the period value minus one granule of the period element type.
		CREATE FUNCTION DQMUDF.last(p1 PERIOD(DATE))
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.last';

		-- Returns the end point of the period value minus one granule of the period element type.
		CREATE FUNCTION DQMUDF.last(p1 PERIOD(TIME))
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.last';

		-- Returns the end point of the period value minus one granule of the period element type.
		CREATE FUNCTION DQMUDF.last(p1 PERIOD(TIME WITH TIME ZONE))
		RETURNS TIME WITH TIME ZONE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.last';

		-- Returns the end point of the period value minus one granule of the period element type.
		CREATE FUNCTION DQMUDF.last(p1 PERIOD(TIMESTAMP))
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.last';

		-- Returns the end point of the period value minus one granule of the period element type.
		CREATE FUNCTION DQMUDF.last(p1 PERIOD(TIMESTAMP WITH TIME ZONE))
		RETURNS TIMESTAMP WITH TIME ZONE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.last';

		-- Returns the succeeding value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.next(p1 DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.next';

		-- Returns the succeeding value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.next(p1 TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.next';

		-- Returns the succeeding value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.next(p1 TIME WITH TIME ZONE)
		RETURNS TIME WITH TIME ZONE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.next';

		-- Returns the succeeding value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.next(p1 TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.next';

		-- Returns the succeeding value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.next(p1 TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP WITH TIME ZONE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.next';

		-- Returns the prior value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.prior(p1 DATE)
		RETURNS DATE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.prior';

		-- Returns the prior value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.prior(p1 TIME)
		RETURNS TIME
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.prior';

		-- Returns the prior value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.prior(p1 TIME WITH TIME ZONE)
		RETURNS TIME WITH TIME ZONE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.prior';

		-- Returns the prior value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.prior(p1 TIMESTAMP)
		RETURNS TIMESTAMP
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.prior';

		-- Returns the prior value of the argument such that there is one granule of the argument type
		-- between the argument and the returned value.
		CREATE FUNCTION DQMUDF.prior(p1 TIMESTAMP WITH TIME ZONE)
		RETURNS TIMESTAMP WITH TIME ZONE
		LANGUAGE JAVA
		PARAMETER STYLE JAVA
		EXTERNAL NAME 'thisjar:com.cognos.xqe.function.udf.builtin.Temporal.prior';
	END INSTALL"
}
